{************************************************}
{                                                }
{                                                }
{************************************************}

program TapeServer;

uses Objects, Drivers, Views, Menus, Dialogs, App;

const
  cmSettings = 100;

type
  TDialogData = record
    CheckBoxData: Word;
    RadioButtonData: Word;
    InputLineData: string[128];
  end;

  TMyApp = object(TApplication)
    DialogData : TDialogData;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure Settings;
  end;

  PDemoDialog = ^TDemoDialog;
  TDemoDialog = object(TDialog)
  end;

{ TMyApp }
procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmSettings: Settings;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~A~ctions', hcNoContext, NewMenu(
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil))),
    NewSubMenu('~S~etup', hcNoContext, NewMenu(
      NewItem('~C~hange settings', 'F2', kbF2, cmSettings, hcNoContext,
      nil)),
    nil))
  )));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      nil)),
    nil)
  ));
end;

procedure TMyApp.Settings;
var
  Bruce: PView;
  Dialog: PDemoDialog;
  R: TRect;
  C: Word;
begin
  R.Assign(20, 6, 60, 19);
  Dialog := New(PDemoDialog, Init(R, 'Demo Dialog'));
  with Dialog^ do
  begin
    R.Assign(3, 3, 18, 6);
    Bruce := New(PCheckBoxes, Init(R,
      NewSItem('~H~varti',
      NewSItem('~T~ilset',
      NewSItem('~J~arlsberg',
      nil)))
    ));
    Insert(Bruce);
    R.Assign(2, 2, 10, 3);
    Insert(New(PLabel, Init(R, 'Cheeses', Bruce)));
    R.Assign(22, 3, 34, 6);
    Bruce := New(PRadioButtons, Init(R,
      NewSItem('~S~olid',
      NewSItem('~R~unny',
      NewSItem('~M~elted',
      nil)))
    ));
    Insert(Bruce);
    R.Assign(21, 2, 33, 3);
    Insert(New(PLabel, Init(R, 'Consistency', Bruce)));
    R.Assign(3, 8, 37, 9);
    Bruce := New(PInputLine, Init(R, 128));
    Insert(Bruce);
    R.Assign(2, 7, 24, 8);
    Insert(New(PLabel, Init(R, 'Delivery instructions', Bruce)));
    R.Assign(15, 10, 25, 12);
    Insert(New(PButton, Init(R, '~O~k', cmOK, bfDefault)));
    R.Assign(28, 10, 38, 12);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
  end;
  Dialog^.SetData(DialogData);
  C := DeskTop^.ExecView(Dialog);
  if C <> cmCancel then Dialog^.GetData(DialogData);
  Dispose(Dialog, Done);
end;

var
  MyApp: TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.
