/* Fichier: codrle1.c
   Auteur: David Bourgin
   Date de creation: 28/1/94
   Date de derniere mise a jour: 22/5/94
   Dessein: Exemple de codage RLE type 1 avec comme donnees a compresser le contenu d'un fichier.
*/

#include <stdio.h>
/* Pour les routines printf,fgetc,fputc et fwrite */
#include <stdlib.h>
/* Pour la routine exit */

/* Codes d'erreur renvoyes a l'appelant */
#define NO_ERROR      0
#define BAD_FILE_NAME 1
#define BAD_ARGUMENT  2

/* Constantes pratiques */
#define FALSE 0
#define TRUE  1

/* Variables globales */
FILE *f_source,*f_dest;

                             /* Puisque fgetc=EOF uniquement apres un acces
                                alors statut_octet_stocke vaut TRUE si un octet a ete engrange par fgetc
                                ou FALSE s'il n'y aucun octet valide, deja lu et non traite dans val_octet_stocke */
int statut_octet_stocke=FALSE;
int val_octet_stocke;

/* Pseudo procedures */
#define fin_des_donnees() (statut_octet_stocke?FALSE:!(statut_octet_stocke=((val_octet_stocke=fgetc(f_source))!=EOF)))
#define lire_octet()  (statut_octet_stocke?statut_octet_stocke=FALSE,(unsigned char)val_octet_stocke:(unsigned char)fgetc(f_source))
#define ecrire_octet(octet)  ((void)fputc((octet),f_dest))
#define ecrire_tableau(tableau,nb_octets_a_ecrire)  ((void)fwrite((tableau),1,(nb_octets_a_ecrire),f_dest))

void codagerle1()
/* Parametres en sortie: Aucun
   Action: Compresse suivant la methode RLE type 1 tous les octets lus par la fonction lire_octet
   Erreurs: Une erreur d'entree/sortie peut perturber le deroulement de l'algorithme
*/
{ register unsigned char octet1,octet2,taille_trame,
                         tableau[129];

  if (!fin_des_donnees())
     { octet1=lire_octet();  /* Y a-t-il au moins 1 octet a analyser? */
       taille_trame=1;
       if (!fin_des_donnees())
                             /* Y a-t-il au moins 2 octets a analyser? */
          { octet2=lire_octet();
            taille_trame=2;
            do { if (octet1==octet2)
                             /* Y a-t-il repetition? */
                    { while ((!fin_des_donnees())&&(octet1==octet2)&&(taille_trame<129))
                            { octet2=lire_octet();
                              taille_trame++;
                            }
                      if (octet1==octet2)
                             /* N'a-t-on rencontre qu'une sequence d'octets identiques? */
                        { ecrire_octet(126+taille_trame);
                          ecrire_octet(octet1);
                          if (!fin_des_donnees())
                             { octet1=lire_octet();
                               taille_trame=1;
                             }
                          else taille_trame=0;
                        }
                      else   /* Non, alors ne pas prendre en compte le dernier octet */
                           { ecrire_octet(125+taille_trame);
                             ecrire_octet(octet1);
                             octet1=octet2;
                             taille_trame=1;
                           }
                      if (!fin_des_donnees())
                         { octet2=lire_octet();
                           taille_trame=2;
                         }
                    }
                 else        /* Preparer le tableau de comparaisons
                                ou seront stockes tous les octets non identiques */
                      { *tableau=octet1;
                        tableau[1]=octet2;
                        while ((!fin_des_donnees())&&(tableau[taille_trame-2]!=tableau[taille_trame-1])&&(taille_trame<128))
                              { tableau[taille_trame]=lire_octet();
                                taille_trame++;
                              }
                        if (tableau[taille_trame-2]==tableau[taille_trame-1])
                             /* A-t-on rencontre une sequence d'octets tous differents suivie d'octets identiques? */
                           { /* Oui, alors decompter les deux derniers octets */
                             ecrire_octet(taille_trame-3);
                             ecrire_tableau(tableau,taille_trame-2);
                             octet1=tableau[taille_trame-2];
                             octet2=octet1;
                             taille_trame=2;
                           }
                        else { ecrire_octet(taille_trame-1);
                               ecrire_tableau(tableau,taille_trame);
                               if (fin_des_donnees())
                                  taille_trame=0;
                               else { octet1=lire_octet();
                                      if (fin_des_donnees())
                                         taille_trame=1;
                                      else { octet2=lire_octet();
                                             taille_trame=2;
                                           }
                                    }
                             }
                      }
               }
            while ((!fin_des_donnees())||(taille_trame>=2));
          }
       if (taille_trame==1)
          { ecrire_octet(0);
            ecrire_octet(octet1);
          }
     }
}

void aide()
/* Parametres en sortie: Aucun
   Action: Affiche l'aide du programme et termine son execution
   Erreurs: Aucune
*/
{ printf("Cet utilitaire permet de compresser un fichier par la methode RLE type 1\n");
  printf("telle qu'elle est exposee dans 'La Video et Les Imprimantes sur PC'\n");
  printf("\nUsage: codrle1 source destination\n");
  printf("source: Nom du fichier a compresser\n");
  printf("destination: Nom du fichier compresse\n");
}

int main(argc,argv)
/* Parametres en sortie: Renvoie un code d'erreur (0=Aucune)
   Action: Procedure principale
   Erreurs: Detectee, traitee et un code d'erreur est renvoye si necessaire
*/
int argc;
char *argv[];
{ if (argc!=3)
     { aide();
       exit(BAD_ARGUMENT);
     }
  else if ((f_source=fopen(argv[1],"rb"))==NULL)
          { aide();
            exit(BAD_FILE_NAME);
          }
       else if ((f_dest=fopen(argv[2],"wb"))==NULL)
               { aide();
                 exit(BAD_FILE_NAME);
               }
            else { codagerle1();
                   fclose(f_source);
                   fclose(f_dest);
                 }
  printf("Execution de codrle1 achevee.\n");
  return (NO_ERROR);
}
