/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* 
 * DESCRIPTION: This file and program were modified on 11-10-1994 
 *              to allow for the renaming of the uu output files 
 *		for dos machines...  
 * EXAMPLE: 
 *    FILE.AAAA.bin was uuencoded into a file we'll call FILEAAAA.uu
 *    on a UN*X machine and transported via sneakernet to an MS-DOS 
 *    machine where I wish to uudecode it.  Because the filename is 
 *    either too long or has two periods in it, it doesn't work.  
 *    So this program and the command:
 *        C:\> bgpuudec.exe FILEAAAA.uu outname.bin
 *    will create FILE.AAAA.bin with the new name outname.bin
 *
 * LIMITATIONS: You can't use stdin and must do one file at a time.
 *              As of yet, no error checking is done on new filename.
 *
 * BUGS: None that I know of except for some of the error messages
 *       aren't very pretty.
 *
 * CONTRIBUTOR:
 *      Brad Parks 
 *      (bparks@intcorp.com)
 *      2675 Patton Road 
 *      St.Paul, MN  55113
 */

/*
 * uudecode [file] [outfile]
 *
 * create the specified outfile, decoding as you go.
 * used with uuencode.
 */

#include <sys/param.h>
#include <sys/stat.h>
#include <pwd.h>
#include <stdio.h>
#include <string.h>

char *filename, *outfile;

/* ARGSUSED */
main(argc, argv)
	int argc;
	char **argv;
{
	extern int errno;
	int rval;

	if (*++argv) {
		rval = 0;

		if (!freopen(filename = *argv, "r", stdin)) {
			(void)fprintf(stderr, "uudecode: %s: %s\n",
			    *argv, "Whoops!");
			rval = 1;
		}

		if (*++argv) {
			outfile = *argv;
		} else {
			outfile = 0;
		} 
		rval |= decode();
	} else {
		usage(*--argv);
		rval = 1;
	}
	exit(rval);
}

decode()
{
	extern int errno;
	struct passwd *pw;
	register int n;
	register char ch, *p;
	int mode, n1;
	char buf[MAXPATHLEN];

	/* search for header line */
	do {
		if (!fgets(buf, sizeof(buf), stdin)) {
			(void)fprintf(stderr,
			    "uudecode: %s: no \"begin\" line\n", filename);
			return(1);
		}
	} while (strncmp(buf, "begin ", 6));
	(void)sscanf(buf, "begin %o %s", &mode, buf);

	/* create output file, set mode */
	if (outfile != 0) {
		strcpy(buf,outfile);
	}
	if (!freopen(buf, "w", stdout)) {
		(void)fprintf(stderr, "uudecode: %s: %s: %s\n", buf,
		    filename, "strerror(errno)");
		return(1);
	}

	/* for each input line */
	for (;;) {
		if (!fgets(p = buf, sizeof(buf), stdin)) {
			(void)fprintf(stderr, "uudecode: %s: short file.\n",
			    filename);
			return(1);
		}
#define	DEC(c)	(((c) - ' ') & 077)		/* single character decode */
		/*
		 * `n' is used to avoid writing out all the characters
		 * at the end of the file.
		 */
		if ((n = DEC(*p)) <= 0)
			break;
		for (++p; n > 0; p += 4, n -= 3)
			if (n >= 3) {
				ch = DEC(p[0]) << 2 | DEC(p[1]) >> 4;
				putchar(ch);
				ch = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
				putchar(ch);
				ch = DEC(p[2]) << 6 | DEC(p[3]);
				putchar(ch);
			}
			else {
				if (n >= 1) {
					ch = DEC(p[0]) << 2 | DEC(p[1]) >> 4;
					putchar(ch);
				}
				if (n >= 2) {
					ch = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
					putchar(ch);
				}
				if (n >= 3) {
					ch = DEC(p[2]) << 6 | DEC(p[3]);
					putchar(ch);
				}
			}
	}
	if (!fgets(buf, sizeof(buf), stdin) || strcmp(buf, "end\n")) {
		(void)fprintf(stderr, "uudecode: %s: no \"end\" line.\n",
		    filename);
		return(1);
	}
	return(0);
}

usage(progname)
	char *progname;
{
	(void)fprintf(stderr, "\tUSAGE: %s infile [outfile]\n",progname);
	(void)fprintf(stderr, 
		"\t  The uuencoded infile will be uudecoded\n");
	(void)fprintf(stderr, 
		"\t  and renamed to outfile (if specified).\n");
	(void)fprintf(stderr, 
		"\t  stdin is not a valid input source.\n");
	exit(1);
}
