#pragma once
#define regax 0
#define regcx 1
#define regdx 2
#define regbx 3
#define regsp 4
#define regbp 5
#define regsi 6
#define regdi 7
#define reges 0
#define regcs 1
#define regss 2
#define regds 3

#ifdef __BIG_ENDIAN__
#define regal 1
#define regah 0
#define regcl 3
#define regch 2
#define regdl 5
#define regdh 4
#define regbl 7
#define regbh 6
#else
#define regal 0
#define regah 1
#define regcl 2
#define regch 3
#define regdl 4
#define regdh 5
#define regbl 6
#define regbh 7
#endif

#define segbase(x)	((uint32_t) x << 4)
#define getmem8(x, y)	read86(segbase(x) + y)
#define getmem16(x, y)	readw86(segbase(x) + y)
#define putmem8(x, y, z)	write86(segbase(x) + y, z)
#define putmem16(x, y, z)	writew86(segbase(x) + y, z)
#define getreg16(regid)	regs.wordregs[regid]
#define putreg16(regid, writeval)	regs.wordregs[regid] = writeval

typedef void (*INTHOOK) ();
union _bytewordregs_ {
	uint16_t wordregs[8];
	uint8_t byteregs[8];
};


void write86 (uint32_t addr32, uint8_t value);
void writew86 (uint32_t addr32, uint16_t value);
uint8_t read86 (uint32_t addr32);
uint16_t readw86 (uint32_t addr32);
int exec86(int execloops); // returns 0 if halted
void reset86(uint16_t startip);
