# Contribute to Collapse OS

Thanks for considering participating to Collapse OS. That the idea of a
post-collapse operating system sparks your interest is great. However, there
have been many contributors so far who seem to have misunderstood Collapse OS'
manifesto. To be clear, let's review its most important points.

## Project goal

Collapse OS' only goal is to preserve humanity's ability to program
microcontrollers with low-tech tools. We accept only contributions advancing
the project towards that goal.

Although Collapse OS is mostly a software product, it's also a documentation
repository. Improving documentation make the project advance towards its goal.

That Collapse OS has such a narrow goal might disappoint many people who are
enthusiastic about the technological achievement. Sorry for that.

If you think that Collapse OS could be repurposed, please fork it. If it serves
the general purpose of post-collapse resilience, that project could be part of
a web of resilience which we'll end up building.

## Priorities and tradeoffs

It is very important for Collapse OS to be self-contained, that is, usable and
hackable with no external ressources. Because of that, code simplicity is
paramount.

It is also important for Collapse OS to run on very tight ressources. Because of
that, code compactness trumps efficiency or features.

All of this means that simplicity is more important than compactness which is
more important than efficiency.

That being said, common sense still prevails. In a critical loop, we will of
course favor efficiency.

## Serious

This project is not made with irony. When being faced with existential threat,
irony offers us a lot of comfort, but this project is not meant to supply this.
It's self evident that this project is a rich source of possible ironic
pleasure. To that end, I suggest a fork. Maybe call it "Pip Boy 3000"?

## Roadmap rigidity

This project has a [roadmap](https://collapseos.org/roadmap.html). It says it's
rigid, but that doesn't mean it's immutable. If you have a good idea that isn't
on the roadmap, please share it.

## Skill requirements

As the roadmap page says, participation to this project requires a certain set
of skills, which is true. Authors of this project don't mind helping you out
honing your skills with code reviews, but please don't expect hand holding.

Important note: the documentation in this project is lacking in many ways. If
you have problem understanding how Collapse OS work because documentation is
lacking, please seek "hand holding". This way, we can improve the documentation
and make post-collapse users much happier.

It is frequently asked by would-be contributors whether I have tips for an
optimal ramping up of skills. [I've put together a little document to answer
that question](https://collapseos.org/skills.html).

## Sending patches

If you have patches to submit, please do so through the [mailing list][ml]. See
<https://git-send-email.io/> for a guide.

[ml]: https://lists.sr.ht/~vdupras/collapseos
