$HOSTNAME = &wherecheck('Finding hostname', 'hostname');
$DEF_MCANALARM = &yncheck('Can we use alarm()?', 'alarm 0;');
&prompt(<<"EOF", "") if (!$DEF_MCANALARM);
Let me guess. You're not using a Unix Perl.

alarm() is no longer required for install, but you should be warned that it
allows better process control, which reduces the chance of system overload.

More importantly, if you intend to use inetd Bucktooth on a system that times
inetd processes out if sockets remain open, you will be running a very
unstable server without alarm() support. (This is only an issue with inetd
Bucktooth, not xinetd or launchd-based Bucktooths.)

You can still install Bucktooth, but consider running this on a system that
supports alarm() in its Perl port.

Press ENTER to continue.
EOF

$INSTALL_PATH = &prompt(<<"EOF", "/usr/local/bin/buckd", 1);

Cool, we made it that far.

Now you'll need to answer a few questions about your installation options
and some functions that need to be hard-coded into Bucktooth. If you just hit
ENTER with nothing entered, the default (in [ ]) will be selected.

Where do you want the resultant script placed? If you're using configure to
build multiple instances of Bucktooth on different ports, make sure this changes
unless you're darn certain that they'll all be configured the same way.
IF YOU'RE USING CONFIGURE TO BUILD MULTIPLE INSTANCES OF Bucktooth ON MULTIPLE
IP ADDRESSES (xinetd only), THIS *MUST* BE DIFFERENT IN EACH CASE!

WARNING TO xinetd/inetd/launchd INSTALLERS: If you are doing a full install
to update (x)inetd/launchd's config files simultaneously, THIS MUST BE AN
ABSOLUTE PATH!

Install path?
EOF
unless ($DEF_MDEMONIC) {
	$DEF_AF_INET = &prompt(<<"EOF", 2, 1);
In an effort to make Bucktooth less Unix-oriented (you decide if this actually
helps any), the one item in Bucktooth that is a hardcoded network constant
actually makes an effort to be portable. If you know that your system's AF_INET
macro is something other than two, enter it here. (I have yet to find an OS
where it wasn't, but I'm sure they're out there, although it was 2 on AIX,
SCO, HP/UX, Solaris, NetBSD and Linux.) 

If you don't know what this is, accept the default -- it's probably correct.

System AF_INET constant (nearly invariably 2)?
EOF
}
$DEF_HTDOCS_PATH = &prompt(<<"EOF", "/usr/local/gopher", 1);
Where do you want the server to serve documents from? All files that Bucktooth
will make available, executables included, must be under this tree (except
for the user filesystem option if enabled, coming up shortly). This is the
server's mount directory.

EOF
print <<"EOF" if (!-d $DEF_HTDOCS_PATH);
WARNING: That directory hasn't been created yet. Make sure you create it.

EOF
$DEF_ACCESS_LOG = &prompt(<<"EOF", "$DEF_HTDOCS_PATH/access.log", 1);

Where do you want the server to put the access log? If you don't want
logging, specify /dev/null. This is the server's log file path.

EOF
print <<"EOF";
WARNING: Make sure the access log is writeable, or there won't be much in it.
Check the file's permissions, just to be safe.

EOF

chomp($j = `$HOSTNAME`) if ($HOSTNAME);
$DEF_SERVER_HOST = &prompt(<<"EOF", $j, 1);
What will the server's name be? This should be a Fully Qualified Domain Name,
like limburgher.cheese.com.

Server host name?
EOF

$PORT_NO = &prompt(<<"EOF", "70", 1);
What numerical TCP port do you want the server to run on? 70 is the default
but if you're using configure to build multiple Bucktooths on multiple ports,
make sure you give a different answer this time. This number is built into
the server, so you must have different built executables for different ports,
and an executable for every port you plan to use.

If you're not doing a full install, this just tells the server what port it
will be on, and doesn't actually change any configuration files.

Which TCP port number?
EOF
$DEF_PORT_NO ||= $PORT_NO; # sigh

$q = 0; $j = '';
($ENV{'TZ'} =~ /[A-Z]+([0-9]+)[A-Z]+/) && ($q = "-" . substr("0${1}00", 
	length("0${1}00") - 4, 4));
$j = <<"EOF" if ($q);
(I made a guess based on your TZ environment variable, which is $ENV{'TZ'}.
But I sometimes don't guess right, so check to be sure.)
EOF
#$DEF_TIME_ZONE = &prompt(<<"EOF", $q || "+0000", 1);
$w = <<"EOF"; # ignore this for now
Bucktooth does CERN logging format making it compatible with most log analysers.
However, to make it as compatible as possible on as wide a range of Perls as
possible, it doesn't do locale() work to find out what your timezone is. 
$j
If you don't care, you can accept the default. If you do, enter a
five-character timezone here (e.g., if you're on Pacific time, like I am,
enter -0800 for 8 hours behind Greenwich mean).
EOF

#$DEF_MGOPHERPERL = &prompt(<<"EOF", "n", 1);
$j = <<"EOF"; # not supported yet
Want faster CGIs? Meet Bucktooth's answer to mod_perl, gopherperl. mod_perl
works its magic by implementing a Perl interpreter in Apache; gopherperl takes
the obvious step of reusing the interpreter already running Bucktooth to run
your executables.

The major advantages:
	* Can be faster (see below for when it won't be), especially if
Perl keeps getting paged out.
	* Your executables have access to all the Bucktooth internals.

The major disadvantages:
	* EVERY EXECUTABLE Bucktooth RUNS HAS TO BE IN PERL. NO EXCEPTIONS! If
you must run a precompiled binary, write a Perl wrapper, and have Bucktooth run
that.

Please read the docs, there's important information in there about this!
Enable gopherperl?
EOF

$DEF_MGOPHERPERL = (($DEF_MGOPHERPERL eq 'y') ? 1 : 0);

$q = &prompt(<<"EOF", "y", 1);
If you don't really care if a hostname or an IP address appears in your
access logs, you can save (in some cases substantial) time by instructing
Bucktooth not to bother doing name lookups when logging. Most of you will
probably want the names resolved, but for a really sleek server you might not,
so it's now a configurable option.

Resolve IP addresses to hostnames?
EOF

$DEF_MHOSTNAMES = (($q eq 'y') ? 1 : 0);

if ($DEF_MHOSTNAMES) {
	$DEF_MANTISPOOF = (&prompt(<<"EOF", "n", 1) eq 'y') ? 1 : 0;
Because of the occasional client address that has incorrect or sometimes
outright fradulent reverse DNS, Bucktooth has a simple antispoofing feature
that simply adds the client IP to every reverse-resolved hostname (e.g.,
127.0.0.1 is rendered localhost/127.0.0.1). Note that an IP without a PTR is
still IP/IP for consistency (e.g., 127.0.0.1/127.0.0.1). This is handy for
nicer logging, but will also affect REMOTE_HOST, so this may break some moles
expecting a "real" domain name. For this reason, this option defaults to no.

Anti-spoof reverse-resolved domain names?
EOF
} else {
	print <<"EOF";
You've elected not to reverse-resolve hostnames, so the PTR anti-spoof feature
is therefore irrelevant.

EOF
}

$q = &prompt(<<"EOF", "n", 0);
Bucktooth does not explicitly enable your (x)inetd/launchd to listen for IPv6
connections, though some will do this automatically. If you have IPv6
connectivity and expect connections over IPv6, you can enable an experimental
compatibility mode to help with reverse resolution. THIS SUPPORT IS
EXPERIMENTAL. If you don't know what to do, or expect primarily to use IPv4,
you should answer no.

Enable EXPERIMENTAL IPv6 support?
EOF

$DEF_MIPV6 = (($q eq 'y') ? 1 : 0);

if ($DEF_MCANALARM) {
	$q = &prompt(<<"EOF", "n", 1);
Now the ugly kludge section. This is really only relevant to inetd users, but
this option may be occasionally useful to xinetd or launchd installs.

Some inetds will time out, and then shut down, services that hold sockets
open for longer than a critical period of time (Linux inetd is the most
notorious). This usually happens when a very large file is being downloaded
over a very slow link. The upshot is, Bucktooth will be turned off by inetd and
fail to respond to requests until inetd gets another -HUP signal. This might
be the basis of a nasty DoS attack, so here it is as a configure option. 
Bucktooth will simply kill the link if too much time passes, and save itself,
if this option is enabled. You can adjust the timeout with the next question.
You might also want to enable this if you get besieged with requests that
just hang sockets up on your system, but you don't need it if you're not
running inetd Bucktooth.

Note that many inetds will not require this, e.g., AIX and HP/UX don't seem
to. Don't turn it on unless you think it's necessary for your OS or security.
(Now that Perl 5.8.x has farked up signals, this also locally sets the
PERL_SIGNALS environment variable to 'unsafe' for the old \$SIG behaviour.)

Auto-kill the link on slow data transfers?
EOF
	$DEF_MAUTOKILL = ($q eq 'y') ? 1 : 0;
	if ($DEF_MAUTOKILL) {
		$DEF_AK_TIMEOUT = &prompt(<<"EOF", "25", 1);
Enter the timeout (in seconds) before Bucktooth should auto-kill the link. This
is system dependent. Some inetds will kick Bucktooth down after as little as
thirty seconds but most are usually up to sixty. Tune this to whatever seems
to give the best performance and stability, which usually is five or ten
seconds before inetd will actually close the port down.

If this is just for security purposes, set it to whatever you like. Sixty
seconds seems good for not-too-busy sites with not-too-big files.

Auto-kill timeout?
EOF
	} else {
		print <<"EOF";
Murderous tendencies quelled.

EOF
	}
} else {
	print <<"EOF";
You don't support alarm(), so I can't give you the ugly kludge for keeping
inetd Bucktooths stable on certain platforms (notably Linux) even though you
might need it.

EOF
}

$DEF_GOPHERGLOB = (&prompt(<<"EOF", "y", 1) eq 'y') ? 'glob(' : '(';
Starting in Bucktooth 0.2, you can now put fileglobs (i.e., * and ? wildcards)
into a gophermap file in place of a usual file specification. Specifically,
this is the case for a gophermap line like this:

?*<TAB>

(i.e., the situation where you specifically don't give a selector, letting
Bucktooth assume the selector and the display string are the same). When
Bucktooth sees this, it will automatically display all the files that match
using the specified item type, or use the magic "?" if you don't care and
Bucktooth will figure out the type. If only one file matches (or there are no
wildcards), the old behaviour is still used, and if NO files match, NOTHING is
displayed. In all other types of gophermap entries, the glob is not expanded
and is left literal.

If you enable gopher tags, if a matched file is a directory and has a tag,
the tag is used for the display string automatically (we'll get to that).

Read the manual for all the details, including notes on glob() in older Perls.
This is unlikely to break most gophermaps, so this is the default. However, if
you DO have files with wildcards in their names, this WILL break them then!

Allow gophermap globbing?
EOF

$DEF_SORT = (&prompt(<<"EOF", "y", 1) eq 'y') ? 'sort(' : '(';
This is a common afterhack I've seen in user Bucktooth modifications, so the
option to sort directory listings (and gophermap globbing if enabled) is now
offered as part of the standard package as a default option. Turn this off if
you'd prefer the old behaviour (unsorted listings in arbitrary order).

Auto-sort directory listings, and globs in gophermap (if enabled)?
EOF

$DEF_MSMARTLINKS = (&prompt(<<"EOF", "y", 1) eq 'y') ? 1 : 0;
Smart linking in Bucktooth 0.2 and up enables a smart parsing module that
looks at the destination of a symbolic link referenced by a directory or glob.
If the symbolic link points to somewhere also within the server's mountpoint,
smart linking rewrites the selector as the true destination while keeping
the display string the same as the name of the symbolic link itself. This can
be very useful for simple menus without any gophermaps at all, and also helps
bots and smart clients see symbolic links as multiple links to single central
resources rather than unnecessarily iterating over multiple links individually
as separate unconnected resources. The process is completely transparent and
automatic for all globs and directories, although you can override it with
explicit statements in a gophermap. So as not to destroy intentional links to
files outside Bucktooth's purview, it will not rewrite links pointing outside
the mountpoint and so does not function as a chroot() or security feature.
Read the manual about this.

Because this is good social behaviour and transparent for almost all typical
applications, smart linking defaults to yes. However, if you have good reason
to keep maintaining links the old way as individual resources, then select no.

Enable smart linking?
EOF

$DEF_MGOPHERTAGS = (&prompt(<<"EOF", "y", 1) eq 'y') ? 1 : 0;
It can be difficult to keep menu titles in sync, especially when you have a
lot of menus pointing to other menus. In 0.2.8 and up, if you put a line of
text in a file named 'gophertag' in a directory, then if you don't specify a
display string (e.g., 1..<TAB>), the tag is used. This makes gophermaps smaller
and causes less headaches.

This option defaults to yes. Say no if you actually have files named
'gophertag'.

Enable gopher tagging?
EOF

$DEF_MEXEC_EXT = (&prompt(<<"EOF", "n", 1) eq 'y') ? 1 : 0;
On certain impoverished filesystems, or places where your umask is weird,
you might not have full control over your execute bits (Cygwin comes to mind)
thereby causing Bucktooth to inadvertently try to execute resources it should
not. If you want to restrict moles to a certain specific extension, you should
answer yes to this question, but most installations won't need this.

Keep in mind that the mole must still have execute bits on it to be even
considered, so to actually get run, it must have execute bits *and* the
specified extension if you answer 'y'.

Restrict executables to a specific extension?
EOF

if ($DEF_MEXEC_EXT) {
	$DEF_EXEC_EXT = &prompt(<<"EOF", ".mol", 1);
Very well then -- specify the extension. This should be a simple string, not
a regex. I discourage the .cgi extension just in case your web server and
your gopher server share a mountpoint (and they're not really CGI scripts in
any case); the default .mol likely won't clash with anything, so it's the
default. INCLUDE THE DOT UNLESS YOU HAVE A GOOD REASON NOT TO!

This will also apply to gophermaps, so to have an executable gophermap, it
must have the extension too (e.g., gophermap.mol). If you have both a
gophermap.mol and gophermap in the same directory, the mole takes over.

Executable extension?
EOF
} else {
	print <<"EOF";
Sailing the wide-open executable seas, bit by bit.

EOF
}

$DEF_MCAPS = &prompt(<<"EOF", "y", 1);
Capability files ("caps" files) are a new de-facto method for out-of-band
metadata on a gopher server. It contains a selection of keys and values telling
a suitable smart client about the server. The important information is how to
understand the server's filesystem, but other keys such as location,
description and so on are also relevant. A sample file is in stuff/. They
are always fetched with the selector "caps.txt" .

By default, Bucktooth is configured to serve a minimal caps file built-in,
even if /caps.txt does not exist. If you have a caps.txt file defined, then
it overrides the built-in file. If for some reason you really don't want this
(and it is strongly recommended for next-generation clients), or you are
running on a non-POSIX filesystem, then you should answer n (you can always
provide a caps.txt file later, of course). Everyone else should answer y.

Serve built-in caps file?
EOF
$DEF_MCAPS = (($DEF_MCAPS eq 'y') ? 1 : 0);

# leave alone
1;

