/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
/* $Id: net.h,v 1.1.1.1 1993/07/04 00:03:21 marca Exp $ */

#include <sys/types.h>
#include "netdata.h"

#define PORTNAMESIZE	25

#define	NET_UNDEF	0
#define	NET_IN		1
#define	NET_OUT		2


typedef enum { NETRIS8, NETSDS, NETPAL, NETTXT, NETSRV, NETCOL, NETDTM,
		NETANIM, NETVDATA, NETSDL, NETCOM, NETEXEC, NETMSG} NetType;

typedef struct {
	int	port;
	char	portName[PORTNAMESIZE];
	char	open;	/*boolean*/
	int	type;
	time_t	queueTime;
	} NetPort;


typedef struct {
	char	*title;
	char	*id;
	int 	selLeft;	/* selection Left */
	int 	selRight;	/* selection Right */
	int 	insertPt;	/* insertion point */
        int     numReplace;     /* number to replace */
	int	replaceAll;	/* boolean should reaplace All text */
	int 	dim;		/* dimensions */
	char	*textString;
	} Text;

typedef struct {
	char	*title;
	char	*id;
	char	*func;
	int	selType;
	int	width;
	int	dim;
	struct	COL_TRIPLET *data;
	} Col;

typedef enum { AF_NO_FUNC, AF_STOP, AF_FPLAY, AF_RPLAY 
		} AnimFunc;

typedef enum { ART_NONE, ART_SINGLE, ART_CONT, ART_BOUNCE
                } AnimRunType;

typedef struct {
	char		*title;
	char		*id;
	AnimFunc 	func;
	int		frameNumber;
	AnimRunType	runType;
	Data 		*data;
	} AnimMesg;

typedef struct {
	char 	id[80];
	char	inPort[80];
	int	func;
	NetPort	*netPort;
	} Server;

typedef struct {
	char *id;
	char *domain;
	char *mesg;
	} Com;


extern	void	NetSetASync();
extern	int	NetRegisterModule();
extern	NetPort *NetCreateInPort();
extern	NetPort *NetCreateOutPort();
extern	NetPort *NetIsConnected();
extern	int	NetInit();
extern	void	NetPollAndRead();
extern	void	NetClientPollAndRead();
extern	void	NetTryResend();
extern	int	NetPALDistribute();
extern	int	NetRISDistribute();
extern	int	NetSendDisconnect();
extern	int	NetSendDoodle();
extern	int	NetSendPointSelect();
extern	int	NetSendLineSelect();
extern	int	NetSendAreaSelect();
extern	int	NetSendClearDoodle();
extern	int	NetSendSetDoodle();
extern	int	NetSendDoodleText();
extern	int	NetSendEraseDoodle();
extern	int	NetSendEraseBlockDoodle();
extern	int	NetSendTextSelection();
extern	int	NetSendPalette8();
extern	int	NetSendRaster8Group();
extern	int	NetGetListOfUsers();
