/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
/* $Id: collage.h,v 1.1.1.1 1993/07/04 00:03:22 marca Exp $ */

#ifndef HAS_COLLAGE_H_BEEN_INCLUDED_BEFORE
#define HAS_COLLAGE_H_BEEN_INCLUDED_BEFORE

#include <stdlib.h>
#include <X11/Intrinsic.h>

#if defined  __STDC__
#ifndef FUNCPROTO
#define FUNCPROTO
#endif
#define CONST		const
#define VOLATILE	volatile
#define SIGNED		signed
#else /* ! defined __STDC__ */
#define CONST
#define VOLATILE
#define SIGNED
#endif /* defined  __STDC__ */

#ifdef FUNCPROTO
#define AND		,
#define PARAMS(paramlist)		paramlist
#define DEFUN(name, arglist, args)	name(args)
#define DEFUN_VOID(name)		name(void)
#else
#define AND		;
#define PARAMS(paramlist)		()
#define DEFUN(name, arglist, args)	name arglist args;
#define DEFUN_VOID(name)		name()
#endif /* FUNCPROTO */

#if defined(SUN) && defined(LINT)
union { char *c; void *vp } mal_r_ptr;
#  define MALLOC(SIZE) (mal_r_ptr.c = malloc(SIZE), mal_r_ptr.vp)
#else
#  define MALLOC malloc
#endif
#define FREE free

typedef union _i_or_f_ {
	int i;
	float f;
} IntOrFloat;

#ifdef NOVOIDPTR
typedef char *GenericPtr;
#else
typedef void *GenericPtr;
#endif

#if 0
struct res_struct {
	XFontStruct     *font;
	Boolean		async;
	char		*id;
	int		base_pixel;
	int		last_pixel;
	Boolean		debug;
	String		anim_source; /* animation source type can be :
				        "server", "memory" or "disk" */
	String		tmp_dir;
} res_gotten;

#define BASE_PIX res_gotten.base_pixel
#define NCOLORS (res_gotten.last_pixel-BASE_PIX+1)
#endif

#endif /* ! HAS_COLLAGE_H_BEEN_INCLUDED_BEFORE */
