.TH UPSL0 8
.SH NAME
upsl0 \- establish a SLIP connection
.SH SYNOPSIS
.B upsl0
[options...] client_hostname server_hostname
.nf

Options:
	-d device        - serial device to use for SLIP
	-b baud          - baud rate to run connect script and SLIP
	-t timeout       - max time to run connect script
	-s sleep_time    - time to sleep between connection and slattach
	-D dbglvl        - level of debugging output to stderr
	-m route_metric  - routing metric to pass to route command
	-M MIN_CHARS     - termio min characters to wait in read()
	-T MIN_TIME      - termio min time to wait in read()
	-A slattach_path - full path name of slattach command
	-C ifconfig_path - full path name of ifconfig command
	-R route_path    - full path name of route command
	-S script_path   - full path name of connection script file
	-n -  No attach, causes only the connection script to be run.
	-N -  No connect, skips the connection script step.
	-a -  No attach, skips calling the "slattach" command.
	-c -  No config, skips calling the "ifconfig" command.
	-r -  No route, skips calling the "route" command.
.fi

.SH DESCRIPTION
.I Upsl0
automates to process of establishing a SLIP connection.
.I Upsl0
executes a script to establish the modem connection, login
to the SLIP sever,
and instantiate the SLIP server software. Once the connection
is established,
.I upsl0
will execute the
.I slattach
command to establish the client side of the SLIP connection,
then run the
.I ifconfig
command to allow interface configuration (e.g. netmask),
and finally run the
.I route
command to add any required routes for the new connection (e.g.,
adding the default route).

.SH CONNECTION SCRIPT
The connection script defaults to the file
.I /etc/slip.dial.
This file is a simple expect/send format with each
expect/send string specified on a line by itself. This
format allows for spaces to be embedded within script lines.
The script will recognize most backslash escapes including
octal specifications.

The following script is an example that dials a modem,
and then logs into the server, and finally waits for
the server to acknowledge that SLIP has begun:

.nf
	             <-- This line is blank
	AT &D0 S58=0\\r
	OK
	ATDT 555 4555\\r
	host:
	login\\r
	ssword:
	password\\r
	beginning...
	             <-- This line is blank
.fi

The first line is blank, so it "expects nothing" and
continues to the next line immediately. The next line
"sends" the modem an initialization command,
(NOTE: the \\r to send a carriage return after the command!),
while the
line after that "expects" the modem to reply with the
string "OK". The next line dials the modem, and the next
waits for the login prompt from the SLIP server. Then
the script sends the login name
and waits
for the password prompt. Finally, the password is sent
and the script waits for the string that the SLIP server
sends when SLIP is started. The last blank line is a
"send nothing" line.

.SH EXAMPLE
The following command would be used to connect the A/UX
SLIP client named
.I tbomb
to the SLIP server host named
.I heifetz
at 19200 baud:

.nf
	upsl0 -b 19200 tbomb heifetz
.fi

.SH DIAGNOSTICS
The debug level can be used to monitor upsl0's progress.
Level one is a feedback level, level three shows the
progress of the connection script, and level five and
above show details of the serial port I/O. Level fifteen
is the maximum level.

.SH BUGS
For some reason, upsl0 will have trouble runnning the
connection script. However, re-running upsl0 will usually
have success running the script.

.SH AUTHOR
Upsl0 was written by Tim Endres of ICE Engineering, Inc. also
known to cavort with Msen, Inc. I love A/UX 3.0, what more
can I say?
All email should be directed to 
.I time@ice.com.
USMail can be directed to:

.nf
	8840 Main Street
	Whitmore Lake, MI  48189
.fi

.SH FILES
.nf
/etc/slip.dial - default connection script
.br
/usr/local/bin/upsl0 - upsl0 executable
.fi
.SH SEE ALSO
slip(1M), slattach(1M), ifconfig(1M), route(1M)

