/* strerror function */
#include <errno.h>
#include <string.h>


char *_Strerror(int errcode, char *buf)
{
	/* copy error message into buffer as needed */

	static char sbuf[] = {"error #xxx"};

	if (buf == NULL)
		buf = sbuf;
	switch (errcode) {	/* switch on known error codes */
	
		case	0:	return ("no error");
		case	EPERM:	 return("Not super-user");
		case	ENOENT:	 return("No such file or directory");
		case	ESRCH:	 return("No such process");
		case	EINTR:	 return("interrupted system call");
		case	EIO:	 return("I/O error");
		case	ENXIO:	 return("No such device or address");
		case	E2BIG:	 return("Arg list too long");
		case	ENOEXEC: return("Exec format error");
		case	EBADF:	 return("Bad file number");
		case	ECHILD:	 return("No children");
		case	EAGAIN:	 return("No more processes");
		case	ENOMEM:	 return("Not enough core");
		case	EACCES:	 return("Permission denied");
		case	EFAULT:	 return("Bad address");
		case	ENOTBLK: return("Block device required");
		case	EBUSY:	 return("Mount device busy");
		case	EEXIST:	 return("File exists");
		case	EXDEV:	 return("Cross-device link");
		case	ENODEV:	 return("No such device");
		case	ENOTDIR: return("Not a directory");
		case	EISDIR:	 return("Is a directory");
		case	EINVAL:	 return("Invalid argument");
		case	ENFILE:	 return("File table overflow");
		case	EMFILE:	 return("Too many open files");
		case	ENOTTY:	 return("Not a typewriter");
		case	ETXTBSY: return("Text file busy");
		case	EFBIG:	 return("File too large");
		case	ENOSPC:	 return("No space left on device");
		case	ESPIPE:	 return("Illegal seek");
		case	EROFS:	 return("Read only file system");
		case	EMLINK:	 return("Too many links");
		case	EPIPE:	 return("Broken pipe");
		case	EDOM:	 return("Math arg out of domain of func");
		case	ERANGE:	 return("Math result not representable");
		case	ENOMSG:	 return("No message of desired type");
		case	EIDRM:	 return("Identifier removed");
		case	ECHRNG:	 return("Channel number out of range");
		case	EL2NSYNC: return("Level 2 not synchronized");
		case	EL3HLT:	 return("Level 3 halted");
		case	EL3RST:	 return("Level 3 reset");
		case	ELNRNG:	 return("Link number out of range");
		case	EUNATCH: return("Protocol driver not attached");
		case	ENOCSI:	 return("No CSI structure available");
		case	EL2HLT:	 return("Level 2 halted");
		case	EDEADLK: return("Deadlock Condition");
		case	EWOULDBLOCK: return("Operation would block");
		case	EINPROGRESS: return("Operation now in progress");
		case	EALREADY: return("Operation already in progress");
		case	ENOTSOCK: return("Socket operation on non-socket");
		case	EDESTADDRREQ: return("Destination address required");
		case	EMSGSIZE: return("Message too long");
		case	EPROTOTYPE: return("Protocol wrong type for socket");
		case	ENOPROTOOPT: return("Protocol not available");
		case	EPROTONOSUPPORT: return("Protocol not supported");
		case	ESOCKTNOSUPPORT: return("Socket type not supported");
		case	EOPNOTSUPP: return("Operation not supported on socket");
		case	EPFNOSUPPORT: return("Protocol family not supported");
		case	EAFNOSUPPORT: return("Address family not supported by protocol family");
		case	EADDRINUSE: return("Address already in use");
		case	EADDRNOTAVAIL: return("Can't assign requested address");
		case	ENETDOWN: return("Network is down");
		case	ENETUNREACH: return("Network is unreachable");
		case	ENETRESET:	return("Network dropped connection on reset");
		case	ECONNABORTED: return("Software caused connection abort");
		case	ECONNRESET:	 return("Connection reset by peer");
		case	ENOBUFS:	 return("No buffer space available");
		case	EISCONN:	 return("Socket is already connected");
		case	ENOTCONN:	 return("Socket is not connected");
		case	ESHUTDOWN:	 return("Can't send after socket shutdown");
		case	ETOOMANYREFS:	 return("Too many references:	 can't splice");
		case	ETIMEDOUT:	 return("Connection timed out");
		case	ECONNREFUSED:	 return("Connection refused");
		case	ELOOP:	 return("Too many levels of symbolic links");
		case	ENAMETOOLONG:	 return("File name too long");
		case	EHOSTDOWN:	 return("Host is down");
		case	EHOSTUNREACH:	 return("No route to host");
		case	ENOTEMPTY:	 return("Directory not empty");
		case	ENOSTR:	 return("Device not a stream");
		case	ENODATA:	 return("No data for no delay IO");
		case	ETIME:	 return("Timer expired");
		case	ENOSR:	 return("Out of streams resources");
		case	ESTALE:	 return("Stale NFS file handle");
		case	EREMOTE:	 return("Too many levels of remote in path");
		case	EPROCLIM:	 return("Too many processes");
		case	EUSERS:	 return("Too many users");
		case	EDQUOT:	 return("Disc quota exceeded");
		case	EDEADLOCK:	 return("Locking deadlock error");
		case	ENOLCK:	 return("No record locks available");
		case	ENOSYS:	 return("Function not implemented");

		default:
			if (errcode < 0 || ENOSYS <= errcode) /* hack-
								 should be
								 sys_errno;
								 see perror(3c)
								 */
				return ("unknown error");
			else {
				/* generate numeric error code */
				strcpy(buf, "error #xxx");
				buf[9] = errcode % 10 + '0';
				buf[8] = (errcode /= 10) % 10 + '0';
				buf[7] = (errcode / 10) % 10 + '0';
				return (buf);
			}
	}
}

char *(strerror)(int errcode)
{
	/* find error message corresponding to errcode */
	return (_Strerror(errcode,NULL));
}
