
/************************************************************************/
/* sun2snd.c - Convert uLAW format into sampled audio files
*/
/************************************************************************/
        
#include <stdio.h>
        
/* convert uLAW format character into sound sample character  */
int cvt(ch)
int ch;
{
        int range, value, sign;
        
        range = (ch & 0xF0) | 0x80;
        value = ch & 0x0F;
        sign  = ch & 0x80;
        
        if (range == 0xF0)
                ch = (15 - value) * 2;
        else if (range == 0xE0)
                ch = (15 - value) * 4 + 32;
        else if (range == 0xD0)
                ch = (15 - value) * 8 + 96;
        else if (range == 0xC0)
                ch = (15 - value) * 16 + 224;
        else if (range == 0xB0)
                ch = (15 - value) * 32 + 480;
        else if (range == 0xA0)
                ch = (15 - value) * 64 + 992;
        else if (range == 0x90)
                ch = (15 - value) * 128 + 2016;
        else if (range == 0x80)
                ch = (15 - value) * 256 + 4064;
        else
                ch = 0;
        
        if (sign)
        	return (0x80 + (ch / 16));
        else
        	return (0x80 - (ch / 16));
        
}
        
main(argc, argv)
int argc;
char *argv[];
{
        FILE *infile, *outfile;
        int ch, counter;

	counter = 0;
       
		if (argc == 1) {
			infile = stdin;
			outfile = stdout;
		} else {
        	if (argc != 3) 
                {
                fprintf(stderr,"Usage: sun2snd [ infile outfile ]\n");
                exit(1);
                }
        
        if ((infile = fopen(argv[argc-2], "rb")) == NULL) 
                {
                perror("Error opening infile");
                exit(0);
                }
        
        if ((outfile = fopen(argv[argc-1], "wb")) == NULL) 
                {
                perror("Error opening outfile");
                exit(0);
                }
		}
        
        ch = fgetc(infile);
        
        while (!feof(infile)) 
                {
		counter++;
		if ((counter % 11) != 0)
                	fputc(cvt(ch), outfile);
        
                ch = fgetc(infile);
                }
        
        fclose(infile);
        fclose(outfile);
        
}


