{CS 310 - Data Structures - program #2 Di-graph - by Matt Martini}
Program Di_Graph(input,output);
 
 
CONST   maxnode = 26;
 
 
TYPE  alf       = SET OF char;
      achar     = 'a'..'z';
      nodecount = 0..maxnode;
      nodeptr   = @nodecell;
      arcptr    = @arcell;
 
      nodecell = RECORD
                   mark  : boolean;
                   value : achar;
                   chain : nodeptr;
                   arcs  : arcptr;
                 END;
 
      arcell = RECORD
                 innode  : nodeptr;
                 nextarc : arcptr;
               END;
 
VAR   alpha   : alf;
      infile  : text;
      outfile : text;
      root    : nodeptr;
 
 
Procedure INITALIZE;
BEGIN
  NEW(root);
  root@.mark  := FALSE;
  root@.value := 'a';
  root@.chain := NIL;
  root@.arcs  := NIL;
END;
 
 
{ Checks graph to see if node is there }
{ returns pointer to node or nil if it isn't found}
Function FINDNODE(G:nodeptr;ch:achar):nodeptr;
VAR node      : nodeptr;
    found     : boolean;
BEGIN
  found := FALSE;
  node := G;
  REPEAT
    IF node@.value = ch
       THEN found := TRUE
       ELSE node := node@.chain;
  UNTIL (found = TRUE) OR (node = NIL);
  findnode := node;
END; {findnode}
 
{ Checks graph to see if arc is there - returns true or false}
Function FINDARC(G:nodeptr;U,V:achar):boolean;
VAR in_node  : nodeptr;
    out_node : nodeptr;
    arc      : arcptr;
    found    : boolean;
BEGIN
  found := FALSE;
  {does in_node exist?}
  in_node := findnode(G,V);
  IF in_node <> NIL THEN
     BEGIN
      {does out_node exist?}
       out_node := findnode(G,U);
       IF out_node <> NIL THEN
         {does this node have any arcs?}
          IF out_node@.arcs <> NIL THEN
             BEGIN
               arc := out_node@.arcs;
               REPEAT
                 IF arc@.innode = in_node THEN found := TRUE;
                 arc := arc@.nextarc;
               UNTIL (found = true) OR (arc = NIL);
             END;
     END;
  findarc := found;
END; {findarc}
 
 
Procedure ADDNODE(var G:nodeptr; ch:achar);
VAR node, lastnode : nodeptr;
BEGIN
  {prevent duplicate nodes}
  node := findnode(G,ch);
  IF node = NIL
     THEN
       BEGIN
        {make a new node}
         NEW(node);
         node@.mark  := FALSE;
         node@.value := ch;
         node@.chain := NIL;
         node@.arcs  := NIL;
        {add new node to end of list}
         lastnode := G;
         WHILE lastnode@.chain <> NIL DO lastnode := lastnode@.chain;
         lastnode@.chain := node;
       END
     ELSE WRITELN(outfile,'NODE ',ch,' ALREADY EXISTS, NODE NOT ADDED.');
END; {addnode}
 
 
Procedure ADDARC(G:nodeptr; U,V:char);
VAR in_node, out_node, node : nodeptr;
    arc, lastarc            : arcptr;
    error                   : boolean;
BEGIN
 {does out_node exist?}
  error := FALSE;
  node := findnode(G,U);
  IF node = NIL
     THEN
       BEGIN
         error := TRUE;
         WRITELN(outfile,'NODE ',U,' NOT FOUND - CAN`T ADD ARC')
       END;
 {does in_node exist?}
  node := findnode(G,V);
  IF node = NIL
     THEN
       BEGIN
         error := TRUE;
         WRITELN(outfile,'NODE ',V,' NOT FOUND - CAN`T ADD ARC')
       END;
 {check to see if arc is already there}
  IF findarc(G,U,V)
     THEN
       BEGIN
         error := TRUE;
         WRITELN(outfile,'ARC FROM ',U,' TO ',V,' ALREADY EXISTS - ARC NOT ADDED');
       END;
  IF NOT error THEN
     BEGIN
       out_node := findnode(G,U);
       in_node  := findnode(G,V);
       NEW(arc);
       arc@.innode := in_node;
       arc@.nextarc:= NIL;
       IF out_node@.arcs = NIL
          THEN out_node@.arcs := arc
          ELSE
            BEGIN
              lastarc := out_node@.arcs;
              WHILE lastarc@.nextarc <> NIL DO lastarc := lastarc@.nextarc;
              lastarc@.nextarc := arc
            END;
     END; {not error}
END; {addarc}
 
 
Procedure READGRAPH(var G:nodeptr);
VAR          ch : char;
    numnodes, j : nodecount;
    current     : nodeptr;
    out_node    : achar;
    in_node     : achar;
BEGIN
  current := G;
  READ(infile,numnodes);
  {Read nodes in and put them into di-graph}
  FOR j := 1 TO numnodes DO
      BEGIN
        {Get a node name ignoring spaces}
        READ(infile,ch);
        WHILE NOT (ch IN alpha) DO READ(infile,ch);
        {make node with that name}
        addnode(current,ch);
        current := current@.chain;
        IF j = 1 THEN G := current;
      END;
  {Read arcs in and put them into di-graph}
  REPEAT
    READ(infile,ch);
    WHILE (NOT (ch IN alpha)) AND (ch <> '.') DO READ(infile,ch);
    IF ch <> '.'
       THEN
         BEGIN
           out_node := ch;
           READ(infile,ch);
           WHILE (NOT (ch IN alpha)) AND (ch <> '.') DO READ(infile,ch);
           in_node := ch;
           addarc(G,out_node,in_node);
         END;
  UNTIL ch = '.';
END; {readgraph}
 
 
Procedure PRINTGRAPH(G:nodeptr);
VAR node : nodeptr;
    arc  : arcptr;
BEGIN
  node := G;
  WRITELN(outfile);
  REPEAT
    WRITE(outfile,'NODE ',node@.value,' POINTS ');
    IF node@.arcs = NIL
       THEN WRITELN(outfile,' NOWHERE')
       ELSE
         BEGIN
           WRITE(outfile,' TO ');
           arc := node@.arcs;
           REPEAT
             WRITE(outfile,arc@.innode@.value,' ');
             arc := arc@.nextarc
           UNTIL arc = NIL;
           WRITELN(outfile)
         END;
    node := node@.chain
  UNTIL node = NIL;
  WRITELN(outfile);
END; {printgraph}
 
 
Procedure TRAVERSE(G:nodeptr; V:char);
VAR node : nodeptr;
    arc  : arcptr;
BEGIN
  node := findnode(G,V);
  IF node = NIL
  THEN WRITELN(outfile,'NODE ',V,' DOESN`T EXIST - CAN`T TRAVERSE')
  ELSE
    BEGIN
      node@.mark := TRUE;
      WRITELN(outfile,'NODE ',node@.value);
        IF node@.arcs <> NIL
           THEN
             BEGIN
               arc := node@.arcs;
               WHILE arc <> nil DO
                 BEGIN
                   IF arc@.innode@.mark = FALSE
                      THEN traverse(G,arc@.innode@.value);
                   arc := arc@.nextarc
                 END; {while}
             END; {if}
    END; {else}
END; {traverse}
 
Procedure UNMARK(var G:nodeptr);
VAR node : nodeptr;
BEGIN
 {unmark all nodes}
  node := G;
  WHILE node <> nil DO
    BEGIN
      node@.mark := FALSE;
      node := node@.chain;
    END;
  WRITELN(outfile);
END; {unmark}
 
Procedure DELARC(G:nodeptr; U,V:char);
VAR in_node, out_node : nodeptr;
    arc, prearc : arcptr;
BEGIN
  IF NOT findarc(G,U,V)
     THEN
       WRITELN(outfile,'ARC FROM ',U,' TO ',V,' DOESN`T EXIST - ARC NOT DELETED')
     ELSE
       BEGIN
         out_node := findnode(G,U);
         in_node  := findnode(G,V);
         arc := out_node@.arcs;
         IF arc@.innode = in_node
            THEN
              BEGIN
                out_node@.arcs := arc@.nextarc;
                dispose(arc)
              END
            ELSE
              BEGIN
                prearc := arc;
                WHILE prearc@.nextarc@.innode <> in_node
                      DO prearc := prearc@.nextarc;
                arc := prearc@.nextarc;
                prearc@.nextarc := arc@.nextarc;
                dispose(arc)
              END;
       END;
END; {delarc}
 
 
Procedure DELNODE(var G:nodeptr; V:char);
VAR node,prenode : nodeptr;
    in_node, out_node :nodeptr;
    arc : arcptr;
BEGIN
  node := findnode(G,V);
  IF node = NIL
     THEN WRITELN(outfile,'NODE ',V,' DOESN`T EXIST - NODE NOT DELETED')
     ELSE
       BEGIN
        {remove all arcs connected to the node}
         out_node := G;
         WHILE out_node <> NIL DO
           BEGIN
            {remove all arcs pointing to the node}
             IF findarc(G,out_node@.value,node@.value)
                THEN
                  BEGIN
                    WRITELN(outfile,'WARNING - ARC FROM ',out_node@.value,
                                    ' TO ',node@.value,' HAS BEEN DELETED');
                    delarc(G,out_node@.value,node@.value)
                  END;
            {remove all arcs pointing away from node}
             in_node := out_node;
             IF findarc(G,node@.value,in_node@.value)
                THEN
                  BEGIN
                    WRITELN(outfile,'WARNING - ARC FROM ',node@.value,
                                    ' TO ',in_node@.value,' HAS BEEN DELETED');
                    delarc(G,node@.value,in_node@.value)
                  END;
             out_node := out_node@.chain;
           END; {while}
        {remove node from chain of nodes}
         IF node = G
            THEN
              BEGIN
               {node is the root node}
                G := node@.chain;
                dispose(node)
              END
            ELSE
              BEGIN
                prenode := G;
                WHILE prenode@.chain <> node DO prenode := prenode@.chain;
                prenode@.chain := node@.chain;
                dispose(node)
              END;
       END; {else}
END; {delnode}
 
 
BEGIN {Di_Graph}
  initalize;
  alpha := ['a'..'z'];
  rewrite(outfile);
  reset(infile);
 
  readgraph(root);
  printgraph(root);
  traverse(root,'o');
  unmark(root);
  delarc(root,'l','y');
  delarc(root,'m','p');
  printgraph(root);
  traverse(root,'o');
  unmark(root);
  traverse(root,'p');
  unmark(root);
  addnode(root,'z');
  addarc(root,'m','z');
  addarc(root,'u','p');
  printgraph(root);
  delnode(root,'y');
  printgraph(root);
  traverse(root,'t');
  unmark(root);
  delarc(root,'y','u');
  delarc(root,'l','m');
  addarc(root,'l','u');
  addarc(root,'l','y');
  delnode(root,'r');
  printgraph(root);
 
  close(infile);
  close(outfile);
END. {Di_Graph}

