/* Output from p2c, the Pascal-to-C translator */
/* From input file "digraph.p" */


/*CS 310 - Data Structures - program #2 Di-graph - by Matt Martini*/

#include <p2c/p2c.h>


#define maxnode         26


typedef long alf[9];

typedef char achar;

typedef char nodecount;


typedef struct nodecell {
  boolean mark;
  achar value;
  struct nodecell *chain;
  struct arcell *arcs;
} nodecell;

typedef struct arcell {
  nodecell *innode;
  struct arcell *nextarc;
} arcell;


Static alf alpha;
Static FILE *infile, *outfile;
Static nodecell *root;


Static Void INITALIZE()
{
  root = (nodecell *)Malloc(sizeof(nodecell));
  root->mark = false;
  root->value = 'a';
  root->chain = NULL;
  root->arcs = NULL;
}


/* Checks graph to see if node is there */
/* returns pointer to node or nil if it isn't found*/
Static nodecell *FINDNODE(G, ch)
nodecell *G;
achar ch;
{
  nodecell *node;
  boolean found;

  found = false;
  node = G;
  do {
    if (node->value == ch)
      found = true;
    else
      node = node->chain;
  } while (found != true && node != NULL);
  return node;
}  /*findnode*/


/* Checks graph to see if arc is there - returns true or false*/
Static boolean FINDARC(G, U, V)
nodecell *G;
achar U, V;
{
  nodecell *in_node, *out_node;
  arcell *arc;
  boolean found;

  found = false;
  /*does in_node exist?*/
  in_node = FINDNODE(G, V);
  if (in_node == NULL)
    return found;
  /*does out_node exist?*/
  out_node = FINDNODE(G, U);
  if (out_node == NULL)
    return found;
  /*does this node have any arcs?*/
  if (out_node->arcs == NULL)
    return found;
  arc = out_node->arcs;
  do {
    if (arc->innode == in_node)
      found = true;
    arc = arc->nextarc;
  } while (found != true && arc != NULL);
  return found;
}  /*findarc*/


Static Void ADDNODE(G, ch)
nodecell **G;
achar ch;
{
  nodecell *node, *lastnode;

  /*prevent duplicate nodes*/
  node = FINDNODE(*G, ch);
  if (node != NULL) {
    fprintf(outfile, "NODE %c ALREADY EXISTS, NODE NOT ADDED.\n", ch);
    return;
  }
  /*make a new node*/
  node = (nodecell *)Malloc(sizeof(nodecell));
  node->mark = false;
  node->value = ch;
  node->chain = NULL;
  node->arcs = NULL;
  /*add new node to end of list*/
  lastnode = *G;
  while (lastnode->chain != NULL)
    lastnode = lastnode->chain;
  lastnode->chain = node;
}  /*addnode*/


Static Void ADDARC(G, U, V)
nodecell *G;
Char U, V;
{
  nodecell *in_node, *out_node, *node;
  arcell *arc, *lastarc;
  boolean error;

  /*does out_node exist?*/
  error = false;
  node = FINDNODE(G, U);
  if (node == NULL) {
    error = true;
    fprintf(outfile, "NODE %c NOT FOUND - CAN`T ADD ARC\n", U);
  }
  /*does in_node exist?*/
  node = FINDNODE(G, V);
  if (node == NULL) {
    error = true;
    fprintf(outfile, "NODE %c NOT FOUND - CAN`T ADD ARC\n", V);
  }
  /*check to see if arc is already there*/
  if (FINDARC(G, U, V)) {
    error = true;
    fprintf(outfile, "ARC FROM %c TO %c ALREADY EXISTS - ARC NOT ADDED\n",
	    U, V);
  }
  if (error) {
    return;
  }  /*not error*/
  out_node = FINDNODE(G, U);
  in_node = FINDNODE(G, V);
  arc = (arcell *)Malloc(sizeof(arcell));
  arc->innode = in_node;
  arc->nextarc = NULL;
  if (out_node->arcs == NULL) {
    out_node->arcs = arc;
    return;
  }
  lastarc = out_node->arcs;
  while (lastarc->nextarc != NULL)
    lastarc = lastarc->nextarc;
  lastarc->nextarc = arc;
}  /*addarc*/


Static Void READGRAPH(G)
nodecell **G;
{
  Char ch;
  nodecount numnodes, j;
  nodecell *current;
  achar out_node, in_node;
  int TEMP;

  current = *G;
  fscanf(infile, "%d", &TEMP);
  numnodes = TEMP;
  /*Read nodes in and put them into di-graph*/
  for (j = 1; j <= numnodes; j++) {
    ch = getc(infile);
    if (ch == '\n')
      ch = ' ';
    while (!P_inset(ch, alpha)) {
      ch = getc(infile);
      if (ch == '\n')
	ch = ' ';
    }
    /*make node with that name*/
    ADDNODE(&current, ch);
    current = current->chain;
    if (j == 1)
      *G = current;
  }
  /*Get a node name ignoring spaces*/
  /*Read arcs in and put them into di-graph*/
  do {
    ch = getc(infile);
    if (ch == '\n')
      ch = ' ';
    while (!P_inset(ch, alpha) && ch != '.') {
      ch = getc(infile);
      if (ch == '\n')
	ch = ' ';
    }
    if (ch != '.') {
      out_node = ch;
      ch = getc(infile);
      if (ch == '\n')
	ch = ' ';
      while (!P_inset(ch, alpha) && ch != '.') {
	ch = getc(infile);
	if (ch == '\n')
	  ch = ' ';
      }
      in_node = ch;
      ADDARC(*G, out_node, in_node);
    }
  } while (ch != '.');
}  /*readgraph*/


Static Void PRINTGRAPH(G)
nodecell *G;
{
  nodecell *node;
  arcell *arc;

  node = G;
  putc('\n', outfile);
  do {
    fprintf(outfile, "NODE %c POINTS ", node->value);
    if (node->arcs == NULL)
      fprintf(outfile, " NOWHERE\n");
    else {
      fprintf(outfile, " TO ");
      arc = node->arcs;
      do {
	fprintf(outfile, "%c ", arc->innode->value);
	arc = arc->nextarc;
      } while (arc != NULL);
      putc('\n', outfile);
    }
    node = node->chain;
  } while (node != NULL);
  putc('\n', outfile);
}  /*printgraph*/


Static Void TRAVERSE(G, V)
nodecell *G;
Char V;
{
  nodecell *node;
  arcell *arc;

  node = FINDNODE(G, V);
  if (node == NULL) {
    fprintf(outfile, "NODE %c DOESN`T EXIST - CAN`T TRAVERSE\n", V);
    return;
  }
  node->mark = true;
  fprintf(outfile, "NODE %c\n", node->value);
  if (node->arcs == NULL) {
    return;
  }  /*if*/
  arc = node->arcs;
  while (arc != NULL) {
    if (arc->innode->mark == false)
      TRAVERSE(G, arc->innode->value);
    arc = arc->nextarc;
  }  /*while*/

  /*else*/
}  /*traverse*/


Static Void UNMARK(G)
nodecell **G;
{
  nodecell *node;

  /*unmark all nodes*/
  node = *G;
  while (node != NULL) {
    node->mark = false;
    node = node->chain;
  }
  putc('\n', outfile);
}  /*unmark*/


Static Void DELARC(G, U, V)
nodecell *G;
Char U, V;
{
  nodecell *in_node, *out_node;
  arcell *arc, *prearc;

  if (!FINDARC(G, U, V)) {
    fprintf(outfile, "ARC FROM %c TO %c DOESN`T EXIST - ARC NOT DELETED\n",
	    U, V);
    return;
  }
  out_node = FINDNODE(G, U);
  in_node = FINDNODE(G, V);
  arc = out_node->arcs;
  if (arc->innode == in_node) {
    out_node->arcs = arc->nextarc;
    Free(arc);
    return;
  }
  prearc = arc;
  while (prearc->nextarc->innode != in_node)
    prearc = prearc->nextarc;
  arc = prearc->nextarc;
  prearc->nextarc = arc->nextarc;
  Free(arc);
}  /*delarc*/


Static Void DELNODE(G, V)
nodecell **G;
Char V;
{
  nodecell *node, *prenode, *in_node, *out_node;

  node = FINDNODE(*G, V);
  if (node == NULL) {
    fprintf(outfile, "NODE %c DOESN`T EXIST - NODE NOT DELETED\n", V);
    return;
  }
  /*remove all arcs connected to the node*/
  out_node = *G;
  while (out_node != NULL) {
    /*remove all arcs pointing to the node*/
    if (FINDARC(*G, out_node->value, node->value)) {
      fprintf(outfile, "WARNING - ARC FROM %c TO %c HAS BEEN DELETED\n",
	      out_node->value, node->value);
      DELARC(*G, out_node->value, node->value);
    }
    /*remove all arcs pointing away from node*/
    in_node = out_node;
    if (FINDARC(*G, node->value, in_node->value)) {
      fprintf(outfile, "WARNING - ARC FROM %c TO %c HAS BEEN DELETED\n",
	      node->value, in_node->value);
      DELARC(*G, node->value, in_node->value);
    }
    out_node = out_node->chain;
  }  /*while*/
  /*remove node from chain of nodes*/
  if (node == *G) {
    /*node is the root node*/
    *G = node->chain;
    Free(node);
    return;
  }
  prenode = *G;
  while (prenode->chain != node)
    prenode = prenode->chain;
  prenode->chain = node->chain;
  Free(node);

  /*else*/
}  /*delnode*/


main(argc, argv)
int argc;
Char *argv[];
{
  PASCAL_MAIN(argc, argv);
  outfile = NULL;
  infile = NULL;
  INITALIZE();
  P_addsetr(P_expset(alpha, 0L), 'a', 'z');
/* p2c: digraph.p, line 345: Note: REWRITE does not specify a name [181] */
  if (outfile != NULL)
    rewind(outfile);
  else
    outfile = tmpfile();
  if (outfile == NULL)
    _EscIO(FileNotFound);
  rewind(infile);

  READGRAPH(&root);
  PRINTGRAPH(root);
  TRAVERSE(root, 'o');
  UNMARK(&root);
  DELARC(root, 'l', 'y');
  DELARC(root, 'm', 'p');
  PRINTGRAPH(root);
  TRAVERSE(root, 'o');
  UNMARK(&root);
  TRAVERSE(root, 'p');
  UNMARK(&root);
  ADDNODE(&root, 'z');
  ADDARC(root, 'm', 'z');
  ADDARC(root, 'u', 'p');
  PRINTGRAPH(root);
  DELNODE(&root, 'y');
  PRINTGRAPH(root);
  TRAVERSE(root, 't');
  UNMARK(&root);
  DELARC(root, 'y', 'u');
  DELARC(root, 'l', 'm');
  ADDARC(root, 'l', 'u');
  ADDARC(root, 'l', 'y');
  DELNODE(&root, 'r');
  PRINTGRAPH(root);

  if (infile != NULL)
    fclose(infile);
  infile = NULL;
  if (outfile != NULL)
    fclose(outfile);
  outfile = NULL;
  if (infile != NULL)
    fclose(infile);
  if (outfile != NULL)
    fclose(outfile);
  exit(EXIT_SUCCESS);
}  /*Di_Graph*/




/* End. */
