.TH netlist V1.0 local
.SH NAME
netlist \- AppleTalk network router utility
.SH SYNOPSIS
.B netlist
[ network [ node ]]
.\"netlist.man
.\"(c)Copyright 1994 by John A. Dundas III
.\"All rights reserved.
.\"@(#)netlist.man; Copyright 1994 by John A. Dundas III; All rights reserved.
.SH DESCRIPTION
The \f7netlist\f1 program is an interesting utility that I initially wrote as a
test suite for a subroutine package that obtains ZIP and RTMP information
from a router in order to perform mapping between AppleTalk network numbers
and zone names from within a program.  This can sometimes be useful for
debugging network problems and can also be used to explore AppleTalk
routing.

When the program is invoked with no parameters, it obtains routing information
from an available router on the local (attached) AppleTalk network.  Optionally,
the program can be invoked with a \fInetwork\fR to look for a router or
a \fInetwork\fR and \fInode\fR of a router to obtain this information from.
The \fInetwork\fR and \fInode\fR parameters are converted using the
\f7strtol(3C)\f1 facility; thus numbers may be expressed in decimal,
hexadecimal, or octal notation, whichever is most convenient.

.SS Commands
Upon invocation, \f7netlist\f1 contacts the indicated or default router and
obtains all known networks and zones.  The program builds a set of in-memory
data structures that can be subsequently manipulated through the following
commands.  The program prompts for all commands with ``>''.  The case of
the command letters is ignored.
.TP
.B i
This command (re)initializes the network and zone lists by querying the
router for all ZIP and RTMP information.  Perhaps this isn't
the best description as the lists are never cleared out.  However,
if new networks or zones are discovered, they are added to the
already-built lists.
.TP
.B n \fR[ \fInetwork range\fR ]
This command displays information about the indicated \fInetwork range\fR
(see below for the syntax of network ranges).  Typical information includes
an indication of whether the network is valid or not, and if valid, the
zone name(s) that are associated with it.  If the \fInetwork range\fR is
omitted, all known networks are displayed.
.TP
.B z \fR[ \fIzone name\fR ]
This command displays information about the indicated \fIzone name\fR
(see below for the syntax of zone names).  Typical information includes
an indication of whether the zone name is valid or not, and if valid, the
network(s) that are associated with it.  If the \fIzone name\fR is
omitted, all known zones are displayed.
.TP
.B d
Toggle debugging; default on.
.TP
.B x
Toggle use of DDP checksums in all query packets; default off.
.TP
.B h
Toggle request of split horizon processing in ZIP query packets; default off.
.TP
.B p
Display the hop vector and hash table performance statistics.
.TP
.B l \fR[ \fIname\fR ]
Look up a registered name.  This uses the A/UX NBP name syntax of
object:type@zone.  If not specified =:=@* is used.  This facility is currently
very crude and subject to extensive modification in the future.
.TP
.B q
Exit the program
.TP
.B ?
Display a usage message showing all of the available commands and their
syntax.
.SS Zone Names
To be written.
.SS Network Ranges
To be written.
.SS Debugging Characters
While netlist is querying the router, progress is presented by using a
character to represent each packet received.  The following characters
are used.
.HP
!
.br
select error
.HP
*
.br
select timeout
.HP
x
.br
bad or unexpected packet type or data
.HP
\&.
.br
good packet
.HP
\-
.br
runt packet (undersized, shouldn't happen!)

.SH INSTALLATION
To be written.
.SH "SEE ALSO"
appletalk(1M)
.br
atlookup(1)
.br
.I Inside AppleTalk
.SH FILES
/dev/appletalk/ddp/socket
.SH AUTHOR
John A. Dundas III
.PP
This document and the software it describes are
.ie t \{\(coCopyright 1994 by John A. Dundas III.  All rights reserved.
\}
.el \{.br
(c) Copypright 1994 by John A. Dundas III.
.br
All rights reserved.
\}
