.\" @(#)mpeg_play.1 2.0 93/01/27 SMI;
.TH MPEG_PLAY 1 "27 January 1993"
.SH NAME
mpeg_play \- plays mpeg-1 encoded bitstreams using X11
.SH SYNOPSIS
.B mpeg_play
[
.B -nob
] [
.B -nop
] [
[
.B -display display_name
] [
.B -dither dither_option
] [
.B -loop 
] [
.B -eachstat 
] [
.B -no_display 
] [
.B -shmem_off 
] [
.B -l_range num
] [
.B -cr_range num
] [
.B -cb_range num
] [
.B -quiet 
]
.B file_name
.SH DESCRIPTION
.B mpeg_play
decodes and displays mpeg-1 encoded bitstreams on systems running X11.
The player will create a new window, display the bitstream, and exit.
Any error messages or notices are sent to stderr. 
.SH OPTIONS
.HP
.B -nob 
: causes the player to ignore and not display any B frames.
.HP
.B -nop 
: causes the player to ignore and not display any P frames.
.HP
.B -display display_name 
: causes the player to open the window on the display \fIdisplay_name\fP.
.HP
.B -dither dither_option 
: selects from a variety of dither options. The possible values are:
.RS
.HP
ordered - ordered dither. 
.HP
ordered2 - a faster ordered dither. This is the default.
.HP
mbordered - ordered dithering at the macroblock level. Although there
is a noticeable decrease in dither quality, this is the fastest dither
available.
.HP
fs4 - Floyd-Steinberg dithering with 4 error values propogated.
.HP
fs2 - Floyd-Steinberg dithering with 2 error values propogated.
.HP
fs2fast - Fast Floyd-Steinberg dithering with 2 error values propogated.
.HP
hybrid - Hybrid dithering, a combination of ordered dithering for the luminance
channel and Floyd-Steinberg 2 error dithering for the chrominance channels. Errors
are NOT propogated properly and are dropped all togethor every two pixels in either
direction.
.HP
hybrid2 - Hybrid dithering as above, but with error propogation among pixels.
.HP
2x2 - A dithering technique using a 2x2 pixel area for each pixel. The image displayed
is 4 times larger than the original image encoded. Random error terms are added to 
each pixel to break up contours and gradients.
.HP
gray - Grayscale dithering. The image is dithered into 128 grayscales. Chrominance
information is thrown away.
.HP
color - Full color display (only available on 24 bit color displays).
.HP
none - no dithering is done, no image is displayed. Used to time decoding process.
.HP
mono - Floyd-Steinberg dithering for monochrome displays.
.HP
threshold - Floyd-simple dithering for monochrome displays.
.RE
.HP
.B -loop
: makes the player loop back to the beginning after reaching the end.
.HP 
-quiet
: supresses printing of frame numbers, timing information, and most error
messages.
.HP
-eachstat
: causes statistics to be displayed after each frame. Only valid when
compiled with -DANALYSIS.
.HP
-shmem_off
: turns shared memory off.
.HP
.B -l_range num_colors
: sets the number of colors assigned to the luminance component when
dithering the image.  The product of l_range, cr_range and cb_range
should be less than the number of colors on the display.
.HP
.B -cr_range num_colors
: sets the number of colors assigned to the red component of the
chrominace range when dithering the image.  The product of l_range,
cr_range and cb_range should be less than the number of colors on the
display.
.HP
.B -cb_range num_colors
: sets the number of colors assigned to the blue component of the
chrominace range when dithering the image.  The product of l_range,
cr_range and cb_range should be less than the number of colors on the
display.
.HP
-no_display
: dithers, but does not display, usually used for testing and timing
purposes.
.SH NOTES
The player expects MPEG-1 video streams only. It can not handle multiplexed MPEG streams
or video+audio streams. The player uses the paris entropy coding 
table set (which we believe to be the MPEG-1 standard), but can not handle any bitstreams
that use the "berlin" entropy coding table set. Berlin data is relatively rare so there
shouldn't be too much to worry about here, but be aware of the difference when looking
for streams to play. 
.LP
Some streams do not end with the proper sequence end code and will probably generate
an "Improper sequence end code." error when done playing.
.LP
This player can play XING data files. Be aware that XING makes no use of temporal 
redundancy or motion vector information. In other words, they do not use any P or 
B frames in their streams. Instead, XING data is simply a sequence of I frames. Since
I frames take significantly longer to decode, performance of the player using XING
data is not representative of the player's ability.
.SH AUTHORS
.HP
Ketan Patel - University of California, Berkeley, kpatel@cs.berkeley.edu
.HP
Brian Smith - University of California, Berkeley, bsmith@cs.berkeley.edu
.HP
Henry Chi-To Ma - University of California, Berkeley, cma@cs.berkeley.edu
.HP
Kim Man Liu - University of California, Berkeley, kliu@cs.berkeley.edu


