/**
***				Copyright (C) 1991 by David W. Trissel
***
***				  Not derived from licensed software.
***
*** Permission is granted to freely use, copy, modify, and redistribute
*** this software, provided that no attempt is made to gain profit from it,
*** the author is not construed to be liable for any results of using the
*** software, alterations are clearly marked as such, and this notice is
*** not modified.
***

#define RECORDBYTES 132				/* complete XMODEM block length */
#define DATABYTES 128				/* data portion of block length */
#define NAMEBYTES 63				/* max file name size in info block */

#define RETRIES 10					/* max number of error retries */
#define ACKTIMO 10					/* seconds timeout waiting for ACK */
#define FLUSHTIMO 2					/* Flush timeout when invalid response
									** recieved, must be very short. Note:
									** a one (1) may not work because timer
									** will trip between 0 and 1 sec. */

#define MAXRECNO 0xff				/* top modulo record number */
#define BYTEMASK 0xff				/* single byte mask for integers */

#define TMO -1						/* timeout function return value */
#define SOH	0x01					/* ANSI Start Of Header */
#define EOT 0x04					/* ANSI End Of Transmission */
#define ACK 0x06					/* ANSI positive ACKnowledge */
#define NAK 0x15					/* ANSI Negative AcKnowledge */
#define CAN 0x18					/* ANSI CANcel */
#define ESC 0x1b					/* ANSI ESCape */

	/* Definition of the 128 byte Mac file info record */
#define H_VEROFF	0				/* Mac OS only supports version zero */
#define H_NLENOFF	1				/* Mac file name length (1..63) */
#define H_NAMEOFF	2				/* Mac file name */
 /* 65 <-> 80 is the FInfo structure */
#define H_TYPEOFF	65				/* file type */
#define H_AUTHOFF	69				/* file application owner */
#define H_FDRFLG	73				/* first finder flag */
#define H_ZERO1		74				/* (should be zero) */
#define H_WVRT		75				/* folder vertical position */
#define H_WHRZ		77				/* folder horizontal position */
#define H_FOLDRID	79				/* folder ID */
#define H_PROT		81				/* file protected bit (0x01) */
#define H_ZERO2		82				/* (should be zero) */
#define H_DLENOFF	83				/* data fork size */
#define H_RLENOFF	87				/* resource fork size */
#define H_CTIMOFF	91				/* file creation time */
#define H_MTIMOFF	95				/* file last time modified time */
#define H_FDRINFO	99				/* Finder word */
#define H_FDRFLG2	101				/* second Finder flags */
#define H_ZERO3		102				/* 15 bytes (should be zero) */
#define H_UNPKSZ	116				/* hint for unpacking size (unused) */
#define H_HDR2		120				/* info header size (unused) */
#define H_UPBIIVER	122				/* highest MacBin II version (unused) */
#define H_MINBIIVER	123				/* minimum MacBin II version (unused) */
#define H_CRC		124				/* MacBin II CRC (unused) */

enum {TEXT, DATA, RSRC, FULL} mode;

#define LOGLO	(Log > 1)
#define LOGMED	(Log > 2)
#define LOGHI	(Log > 3)

/* C library routines */
extern char	*getenv();

struct Macheader
  { char m_name[NAMEBYTES+1];
	char m_type[4];
	char m_author[4];
	long m_datalen;
	long m_rsrclen;
	long m_createtime;
	long m_modifytime;
	} Mh;

struct Filenames
  { char f_info[256];
	char f_data[256];
	char f_rsrc[256];
	} Files;
