/*             
 *	layersize.c
 *
 *		update Unix side with window size information
 *
 *             Copyright (C) 1993 by Eric C. Rosen
 *             Copyright (C) 1989-1992 by David W. Trissel
 *
 *	All rights reserved.
 *
 *  Not derived from licensed software.
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software, provided that no attempt is made to gain profit from it,
 * the author is not construed to be liable for any results of using the
 * software, alterations are clearly marked as such, and this notice is
 * not modified.
 *
 *
 *	NOTE: MacLayers WILL AUTOMATICALLY UPDATE THE UNIX SIDE layers PROGRAM
 *		  WHEN YOU RESIZE YOUR WINDOWS. YOU ONLY NEED TO USE THIS PROGRAM
 *		  IF YOU RESIZE YOUR WINDOWS AFTER LOGGING TO A REMOTE HOST, OR IF
 * 		  YOU ARE NOT RUNNING layers. SEE DOCUMENTATION FOR DETAILS.
 */

#include <stdio.h>
#include <errno.h>
#include <sys/ioctl.h>
#ifdef SVR4
#include <sys/termios.h>
#endif


extern int sys_nerr;
extern char	*sys_errlist[];

static void gotsyserr(/* char * */);
static void goterr(/* char * */);
static int	getnumber(/* char * */);


						/* main() - update BSD window size */

main(ac, av)
int			ac;							/* argument count */
char		**av;						/* argument vector */
{
	struct winsize wsize;				/* window size structure for ioctl() */
	char		*ap;					/* argument scan pointer */
	int			lines;					/* new lines value */
	int			cols;					/* new columns value */

	if (--ac != 2)
		goterr("Missing lines and column options");

	/* get window size (actually do this to set xpixel and ypixel values) */
	if (ioctl(0, TIOCGWINSZ, &wsize) == -1)
		gotsyserr("No window support in host"); /* terminate with message */

	/* scan looking for -l and -c line and column numeric sizes */
	lines = cols = 0;					/* reset values */
	while (ac > 0)
	  {	ap = *++av;						/* point to next argument string */
		if (ac-- > 0 && *ap == '-')		/* if option ... */
		switch (ap[1])
		{ case 'l':		/* lines */
			lines = getnumber(&ap[2]);
			break;

		  case 'c':		/* columns */
			cols = getnumber(&ap[2]);
			break;

		  default:
			goterr("Unsupported option"); /* unsupported option */
			break;

		} /* end '-' argument */
		else
			goterr("Unsupported parameter"); /* unsupported parameter */

	  } /* end while argument vector scan */
			
	/* must have both lines and columns */
	if (lines == 0 || cols == 0)
		goterr("Must specify both lines and columns");

	wsize.ws_col = cols;				/* set columns */
	wsize.ws_row = lines;				/* set lines */
	/* update the kernel */
	if (ioctl(0, TIOCSWINSZ, &wsize) == -1)
		gotsyserr("Failed to update window size"); /* didn't go */

} 


				/* goterr() - issue error and terminate */

static void
goterr(msg)
char		*msg;						/* error message string */
{
	printf("%s\n", msg);				/* send error message to user */
	exit(1);							/* terminate with error */

} /* goterr() */


				/* gotsyserror() - system error return */

static void
gotsyserr(msg)
char		*msg;						/* error string */
{
	if (errno > 0 && errno < sys_nerr)
		printf("%s: %s\n", msg, sys_errlist[errno]);
	else
		printf("%s: Error %d\n", msg, errno);

	exit(1);							/* exit with failure */

} /* gotsyserr() */


					/* getnumber() - parse option number */

static int
getnumber(str)
char		*str;						/* start of option string */
{
	int			n;						/* number being built */

	if (str == NULL)
		goterr("Invalid numeric in option");

	/* skip any leading delimiters */
	while (*str && (*str == ' ' || *str == '\t'))
		str++;

	for(n=0; *str && *str >= '0' && *str <= '9'; str++)
		n = n*10 + *str - '0';			/* add next digit in */

	/* make sure number terminates legally */
	switch (*str)
	{ case '\0':
	  case ' ':
	  case '\t':
	  case '\n':
		if (n <= 0 || n > 200)
			goterr("Number out of range");
		break;							/* these are OK */

	  default:
		goterr("Invalid numeric in option");

	} /* end switch */

	return ( n );						/* return the number */

} /* getnumber() */
