/*             Copyright (C) 1989 by David W. Trissel 
 *
 *  Not derived from licensed software.
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software, provided that no attempt is made to gain profit from it,
 * the author is not construed to be liable for any results of using the
 * software, alterations are clearly marked as such, and this notice is
 * not modified.
 *
 */

#define HOSTPROTOCOL	2					/* current host protocol */

#define MAXPCHAN	7						/* maximum layers supported */

#define MAXSTR		200
#define	MAXARGS		64
#define MAXLINE		1024
#define IOSIZE		800						/* data gulp handling size */

/* WARNING - packet sizes must be insured to never match the ESCAPE char */
#define	ESCAPE		'}'						/* datalink escape character */

#define DO 		if (Dflag)					/* for debugging */

/* miscelaneous common data */
extern	int	Dflag;							/* debug dump indicator flag */
extern	int	Clientversion;					/* client version number */
extern	int	Protocollevel;					/* effective protocol level */
extern	int	Clientlevel;					/* client's protocol level */

/* Shape structure passed between MacLayers and ourselves */
struct Shape
{	short	worigv;							/* verical window bit origin */
	short	worigh;							/* horizontal window bit origin */
	short	wlines;							/* window height */
	short	wchars;							/* window width */
	short	wfont;							/* window font size */
	short	wattr;							/* window attributes */
};

#define Wa_shell	0x01					/* window is a shell */


  /* The following modules define the complete protocol/server interface */

				/* layers.c */

extern void FQuit(/* exitcode */);
extern void ReceiveQuit();
extern void ReceiveNew(/* chanid, shape */);
extern void ReceiveDelete(/* chanid */);
extern void ReceiveSignal(/* chanid, signal */);
extern void	ReceiveData(/* chanid, buff, cnt */);
extern void ReceiveReshape(/*chanid, shape */);
extern void DEBUG(/* format, arg1, arg2, arg3, arg4 */);

				/* protocol.c */

extern int	InitLink();
extern int	TopChannel();
extern int	SendNew(/* shape */);
extern void	SendTitle(/* chan, buff, cnt */);
extern void SendDelete(/* chan */);
extern void SendQuit();
extern void	SendReshape(/* chan, shape */);
extern void	SendData(/* chan, buff, cnt */);
extern void	ProcessStreamin();
