/*
 *     Copyright CERN, Geneva 1989 - Copyright and any other
 *     appropriate legal protection of these computer programs
 *     and associated documentation reserved in all countries
 *     of the world.
 */

#include        "globals.h"

# undef		nl	/* don't need it here, and it interferes	*/

/*
 *	This routine initializes the current and standard screen.
 */

#ifdef STANDARD_C

struct  curwin  *initscr(void)

#else /* STANDARD_C */

struct  curwin  *initscr()

#endif /* STANDARD_C */

{
	if (curscr)
		return ERR;
	curscr = &curscr_window;
	curscr->char_y = curscrch_y;
	curscr->ccset_y = curscrccs_y;

#ifdef EXTENDED
	curscr->ccext_y = curscrcex_y;
#endif /* EXTENDED */

	return (newwin());
}

/*
 * allocate space for and set up defaults for a new window
 */

#ifdef STANDARD_C

struct  curwin  *newwin(void)

#else /* STANDARD_C */

struct  curwin  *newwin()

#endif /* STANDARD_C */

{
	register int    i;
	register int    cols8;

	if (LINES > MAXLINES)
		return ERR;

	cols8 = ((COLS + 7) / 8) * 8;
	curscr->char_y[0] = (unsigned char *) alloc_buffer(LINES * cols8, ' ');
	curscr->ccset_y[0] = (unsigned char *) alloc_buffer(LINES * cols8, '\0');

#ifdef EXTENDED
	curscr->ccext_y[0] = (unsigned char *) alloc_buffer(LINES * cols8, '\0');
#endif /* EXTENDED */

	for (i = 1; i < LINES; i++)
	{
		curscr->char_y[i] = curscr->char_y[i-1] + cols8;
		curscr->ccset_y[i] = curscr->ccset_y[i-1] + cols8;

#ifdef EXTENDED
		curscr->ccext_y[i] = curscr->ccext_y[i-1] + cols8;
#endif /* EXTENDED */

	}
	X = Y = 0;
	curscr->_maxy = LINES;
	curscr->_maxx = COLS;
	curscr->_begy = 0;
	curscr->_begx = 0;
	curscr->_style = 0;

	return curscr;
}

/*
 *	This routine deletes a window and releases it back to the system.
 */

#ifdef STANDARD_C

void    delwin(void)

#else /* STANDARD_C */

void    delwin()

#endif /* STANDARD_C */

{
	free((void *)curscr->char_y[0]);
	free((void *)curscr->ccset_y[0]);

#ifdef EXTENDED
	free((void *)curscr->ccext_y[0]);
#endif /* EXTENDED */

}
