/*
 *     Copyright CERN, Geneva 1989 - Copyright and any other
 *     appropriate legal protection of these computer programs
 *     and associated documentation reserved in all countries
 *     of the world.
 */

/*
 *  Copyright (c) 1984 Marvin Solomon; all rights reserved
 */

/*
 * Some overall defined symbols imply that others should normally be set.
 * The default is, for historical reasons, BSD 4.2.
 * Some symbols may be automatically set by the operating system, others
 * by the Makefile to request a particular environment.
 *
 * Symbols (sometimes) defined by the operating system :-
 * (I may choose to define/use these anyway)
 *
 * SYSV                 System V
 *
 * SVR4                 System V Release 4
 *
 *
 * Symbols defined by the Makefile to specify the general environment :-
 *
 * Note that I follow the X standard as much as possible.
 *
 * STANDARD_C             Use ANSI C (function prototypes etc.)
 *
 * __POSIX__            Use the complete POSIX interface definitions.
 *
 * USE_SYSV_TERMIO      Use the System V termio terminal interface

 * USE_TERMIOS          Use the POSIX termios terminal interface. This pretty
 *                      well includes TERMIO, so we will force in the
 *                      USE_SYSV_TERMIO definition also.
 *
 * SIGNALRETURNSINT     The function called by signal() is an integer function.
 *                      This is the old form of bsd: now it is normally void.
 *
 *
 *
 * Local symbols: may be used in the program #if(n)defs :-
 *
 * STANDARD_C           I make this local so that I can choose whether
 *                      or not to compile with the old or new form.
 *
 * TTY_STRUCT           The structure for the terminal interface: sgttyb, termio
 *                      or termios.
 *
 * SIGNAL_T             The type of the routine called by signal().
 *
 * SIGNAL_RETURN        The return from a routine called by signal().
 *
 *
 *
 *
 */

#ifdef __STDC__
#define STANDARD_C
#endif /* __STDC__ */


/*
 * Now we will look at the lowest level of definitions and see what
 * is specifically chosen (may be different from the higher level default)
 */

/*
 *                       ---------
 *                      | new tty |
 *                       ---------
 */

#ifdef USE_NEWTTY
#define TTY_INTERFACE USE_NEWTTY
#endif /* USE_NEWTTY */

/*
 *                       ---------
 *                      | termio  |
 *                       ---------
 */

#ifdef USE_SYSV_TERMIO
#define TTY_INTERFACE USE_SYSV_TERMIO
#endif /* USE_SYSV_TERMIO */

/*
 *                       ---------
 *                      | termios |
 *                       ---------
 */

#ifdef USE_TERMIOS
#define TTY_INTERFACE USE_TERMIOS
#endif /* USE_TERMIOS */


/*
 * Now at the middle level definitions, to see what is different from
 * the default from the top level definitions.
 */

/*
 *                       ---------
 *                      | BSD     |
 *                       ---------
 */

#ifdef BSD
#define OP_SYSTEM BSD
#endif /* BSD */

/*
 *                       ---------
 *                      | BSD43   |
 *                       ---------
 */

#ifdef BSD43
#define OP_SYSTEM BSD43
#endif /* BSD43 */

/*
 *                       ---------
 *                      | AIX     |
 *                       ---------
 */

#ifdef AIX
#define OP_SYSTEM AIX
#endif /* AIX */

/*
 *                       ---------
 *                      | SYSV    |
 *                       ---------
 */

#ifdef SYSV
#define OP_SYSTEM SYSV
#endif /* SYSV */

/*
 *                       ---------
 *                      | SVR4    |
 *                       ---------
 */

#ifdef SVR4
#define OP_SYSTEM SVR4
#endif /* SVR4 */

#ifndef OP_SYSTEM
#ifndef BSD
#define BSD
#endif /* BSD */
#endif /* OP_SYSTEM */


/*
 * Now we can look at the highest level of definitions and decide what
 * they would normally set at middle levels.
 */

/*
 *                       ---------
 *                      | 3b2     |
 *                       ---------
 */

#ifdef sys_3b2

#define WORKSTATION = sys_3b2

#ifndef OP_SYSTEM
#ifndef SYSV
#define SYSV
#endif /* SYSV */
#endif /* OP_SYSTEM */

#endif /* sys_3b2 */

/*
 *                       ---------
 *                      | apollo  |
 *                       ---------
 */

#ifdef sys_apollo

#define WORKSTATION = sys_apollo

#ifndef OP_SYSTEM
#ifndef BSD43
#define BSD43
#endif /* BSD43 */
#endif /* OP_SYSTEM */

/* Apollo specials */

#define NOT_POSIX

/*
 * For some reason tputs() screws up if I use the ANSI prototypes!
 * I therefore switch them off.
 */

#undef STANDARD_C

#endif /* sys_apollo */

#ifdef sys_hpux

/*
 *                       ---------
 *                      | hpux    |
 *                       ---------
 */

#define WORKSTATION = sys_hpux

#ifndef OP_SYSTEM
#ifndef SVR4
#define SVR4
#endif /* SVR4 */
#endif /* OP_SYSTEM */


#endif /* sys_hpux */

/*
 *                       ---------
 *                      | rs6000  |
 *                       ---------
 */

#ifdef sys_rs6000

#define WORKSTATION = sys_rs6000

#ifndef OP_SYSTEM
#ifndef SVR4
#define SVR4
#endif /* SVR4 */
#endif /* OP_SYSTEM */

#endif /* sys_rs6000 */

/*
 *                       ---------
 *                      | sgi     |
 *                       ---------
 */

#ifdef sys_sgi

#define WORKSTATION = sys_sgi

#ifndef OP_SYSTEM
#ifndef SVR4
#define SVR4
#endif /* SVR4 */
#endif /* OP_SYSTEM */

#endif /* sys_sgi */

/*
 *                       ---------
 *                      | solaris |
 *                       ---------
 */

#ifdef sys_solaris

#define WORKSTATION = sys_solaris

#ifndef OP_SYSTEM
#ifndef SVR4
#define SVR4
#endif /* SVR4 */
#endif /* OP_SYSTEM */

#endif /* sys_solaris */

#ifdef sys_sun

/*
 *                       ---------
 *                      | sun     |
 *                       ---------
 */

#define WORKSTATION = sys_sun

#ifndef OP_SYSTEM
#ifndef BSD
#define BSD
#endif /* BSD */
#endif /* OP_SYSTEM */

#endif /* sys_sun */

#ifdef sys_ultrix

/*
 *                       ---------
 *                      | ultrix  |
 *                       ---------
 */

#define WORKSTATION = sys_ultrix

#ifndef OP_SYSTEM
#ifndef BSD
#define BSD
#endif /* BSD */
#endif /* OP_SYSTEM */

#endif /* sys_ultrix */

#ifndef WORKSTATION
#define WORKSTATION = sys_ultrix

#ifndef OP_SYSTEM
#ifndef BSD
#define BSD
#endif /* BSD */
#endif /* OP_SYSTEM */

#endif /* WORKSTATION */


/*
 * Now look at the middle level and set the basic stuff according to
 * what the workstation is.
 */

#ifdef SYSV

#ifndef TTY_INTERFACE
#define USE_SYSV_TERMIO
#endif /* TTY_INTERFACE */

#endif /* SYSV */

#ifdef SVR4

/*
   Assume that SVR4 normally runs termios interface
   Also assume that SVR4 is a subset of SYSV.
 */

#ifndef TTY_INTERFACE
#define USE_TERMIOS
#endif /* TTY_INTERFACE */

#ifndef SYSV
#define SYSV
#endif /* SYSV */

#endif /* SVR4 */

#ifdef USE_TERMIOS

#define USE_SYSV_TERMIO

#endif /* USE_TERMIOS */

#ifdef SIGNALRETURNSINT

#define SIGNAL_T int
#define SIGNAL_RETURN return 0

#else /* SIGNALRETURNSINT */

#define SIGNAL_T void
#define SIGNAL_RETURN return

#endif /* SIGNALRETURNSINT */

#include <stdio.h>

#ifdef SVR4

#ifdef STANDARD_C
extern  FILE    *fdopen(int fildes, const char *type);
#endif /* STANDARD_C */

#endif /* SVR4 */

/* Load up the typedefs first! */

#include <sys/types.h>

#include <sys/file.h>

#include <ctype.h>
#include <errno.h>
#include <pwd.h>

#ifdef USE_SYSV_TERMIO

#ifdef USE_TERMIOS

#include <termios.h>
#define TTY_STRUCT      termios

#else /* USE_TERMIOS */

#include <termio.h>
#define TTY_STRUCT      termio

#endif /* USE_TERMIOS */

#else /* USE_SYSV_TERMIO */

#include <sgtty.h>
#define TTY_STRUCT      sgttyb

#endif /* USE_SYSV_TERMIO */

#include <string.h>
#include <sys/time.h>
#include <sys/stat.h>

/*
 * I would like to include the stdlib.h header file.
 * Unfortunately, however, it does not exist on all systems.
 * I assume that it exists unless the symbol NOT_STDC_ENV is defined
 * (rather like X11R5 uses the symbol X_NOT_STDC_ENV)
 */

#ifndef NOT_STDC_ENV

#include <stdlib.h>

#endif /* NOT_STDC_ENV */

/*
 * I would also like to include the unistd.h header file.
 * Unfortunately, however, it does not exist on all systems.
 * I assume that it exists unless the symbol NOT_POSIX is defined
 * (rather like X11R5 uses the symbol X_NOT_POSIX)
 */

#ifndef NOT_POSIX

#include <unistd.h>

#endif /* NOT_POSIX */

#ifdef AIX

extern char *sys_errlist[];

#endif /* AIX */

/* A few other things that might or might not be defined! */

#ifndef bool
#define bool    short
#endif /* bool */

#ifndef FALSE
#define FALSE   (0)
#endif /* FALSE */

#ifndef TRUE
#define TRUE    (1)
#endif /* TRUE */

/*
 * Structures that may need to be defined before we can have prototypes.
 */

struct  curwin {
	unsigned char   **char_y, **ccset_y;

#ifdef EXTENDED
	unsigned char   **ccext_y;
#endif /* EXTENDED */

	short		_cury, _curx;
	short		_maxy, _maxx;
	short		_begy, _begx;
	unsigned char   _style;

#ifdef EXTENDED
	unsigned char   _extend;
#endif /* EXTENDED */

};

/*********************************************/
/*                                           */
/* Put all of the prototype definitions here */
/*                                           */
/* The actual definition is ANSI C unless    */
/* the symbol NON_ANSI is defined.           */
/*                                           */
/*********************************************/

#ifdef STANDARD_C

/*********************************************/
/*                                           */
/* ANSI function prototypes                  */
/*                                           */
/*********************************************/

/* Internal telnet.c module routines definition */

extern  unsigned long   *alloc_buffer(int buffer_size, char fill_char);
extern  unsigned long   *incr_buffer(unsigned long *old_buffer, int oldb_size, int increment, char fill_char);
extern  void            usage(char *prog_name);
extern  int             main(int argc, char **argv);

#ifdef LOGFILE

extern  void            logit(char *log_mess, int arg1);
extern  void            logscreen(void);

#endif /* LOGFILE */

extern  void            end_program(int code, char *message, int int1);
extern  int             get_options(void);

#ifdef OPTDIR

extern  int             set_options(int all_options);

#endif /* OPTDIR */

extern  int             fileout(char *filename, int outflag);
extern  int             netopen(char *host, int port);

/* Internal 3270.c module routines definition */

#ifdef DEBUG

extern  char            *print_ascii(unsigned short char_16);

#endif /* DEBUG */

extern  void            init3270(void);
extern  void            reset_ff(int minpos);
extern  void            update_normal(int i);
extern  void            update_cs(void);
extern  void            int_orders(int command, unsigned char *startp, unsigned char *endp1p);
extern  void            int_write(int command, unsigned char *startp, unsigned char *endp1p);
extern  void            interpret(void);
extern  void            setup_field(short attrib);
extern  int             checkSF(void);
extern  void            update_inf(void);
extern  void            changechar(unsigned char c);
extern  void            act_unimpl(int what);
extern  void            sendnet(unsigned char *buffer, unsigned char *bufend, unsigned char key);
extern  bool            next_field(bool backward, int mask);
extern  bool            ok_write(void);
extern  void            act_pa(int key);
extern  void            act_home(int dummy);
extern  void            act_newline(int dummy);
extern  void            act_move(int direction);
extern  void            act_ascii(int how);
extern  void            act_insert(int how);
extern  void            act_debug(int how);
extern  void            act_erase(int how);
extern  void            act_erbsp(int dummy);
extern  char            *set_fname(char *fdir, char *fname);
extern  char            dialogue(char *prompt_string, char helpchar);
extern  void            put_ebcdic(int ch_short);
extern  void            act_help(int dummy);
extern  void            act_escape(int dummy);
extern  void            reset(int cur_save);
extern  void            redraw(int cur_save);
extern  void            mainreset(int cur_save);
extern  void            act_reset(int dummy);
extern  void            act_mreset(int dummy);
extern  void            act_tab(int how);
extern  void            act_delete(int how);
extern  int             delchar(void);
extern  void            place_char(int c, int move);
extern  void            act_nil(int c);
extern  void            act_enter(int key);
extern  void            send_char(int scr_index);
extern  void            act_refresh(int how);
extern  void            act_option(int optval);
extern  void            act_print(int dummy);
extern  void            act_fm(int dummy);
extern  void            act_dup(int dummy);
extern  void            place_special(int c, int move);
extern  void            act_highlight(int input_highlight);
extern  void            act_colour(int input_colour);
extern  int             insertchar(unsigned char c);
extern  void            help_act(int act_index);

/* Internal cr_tty.c module routines definition */

extern  int             count_ch(char);
extern  int             tcstrlen(char *tcstr);
extern  int             add_ch(char addch);
extern  void            zap(void);
extern  void            set_tcstr(void);

/* Internal curscr.c module routines definition */

extern  int             add_char(char addch);
extern  void            add_string(int from, int to, char *tcstring);
extern  void            copy_cp(int from, int to, int oldfrom, int oldto);
extern  void            cchange_setup(void);
extern  int             movestrcnt(int ny, int nx);
extern  void            display_char(int yv, int xv);
extern  void            domvcur(int oy, int ox, int ny, int nx);
extern  bool            isdiff(void);
extern  void            makeline(int scr1, int scr2);

#ifdef EXTENDED
extern  int             set_cse(unsigned char new_style, unsigned char new_extend, bool do_set);
extern  unsigned char   get_extend(void);
extern  int             set_extend(unsigned char new_extend, bool do_set);
#else /* EXTENDED */
extern  int             set_cse(unsigned char new_style, bool do_set);
#endif /* EXTENDED */

extern  void            clscreen(void);
extern  void            update_curscr(void);
extern  void            writecursor(void);
extern  void            putcursor(void);
extern  void            clearnormal(void);
extern  void            clearcurscr(void);
extern  void            clearscreen(void);

#ifdef SHOWFIELDS

extern  void            showfields(void);

#endif /* SHOWFIELDS */

extern  void            movecursor(int dist);
extern  void            winerase(struct curwin *win);

/* Internal finddef.c module routines definition */

extern  int             nextc(FILE *fi);
extern  char            *find_def(char *farray, char *fname, char *termname);

/* Internal initscr.c module routines definition */

extern  struct          curwin  *initscr(void);
extern  struct          curwin  *newwin(void);
extern  void            delwin(void);

/* Internal iomodule.c module routines definition */

extern  void            sys_fail(int code_num, int ret_val);
extern  void            get_opbf(void);
extern  void            rel_opbf(bool keep_one);
extern  void            unset_signals(void);
extern  SIGNAL_T        catch_signal(int sig_num);
extern  void            set_signals(void);

#ifdef TTY

extern  SIGNAL_T        cpu_int(int sig_num);
extern  void            set_cpu_timer(bool setflag);
extern  void            start_cpu_timer(void);
extern  SIGNAL_T        real_int(int sig_num);

#endif /* TTY */

extern  char            *getstime(void);
extern  int             f_compress(char *string);
extern  int             f_uncompress(char *string);
extern  int             select_check(int nfds, int readmval, int writemval, int exceptmval, int sec, int usec, int errnum, char *errmess);
extern  void            show_tty(char *message, struct  TTY_STRUCT *tty_structure);
extern  void            save_tty(void);
extern  void            init_tty(void);
extern  void            setup_tty(bool set_ntty);
extern  void            reset_tty(int req_mode, bool req_flag);
extern  int             f_getc(int secs_timer);
extern  void            f_clearop(int save_buf);
extern  int             f_output(void);
extern  void            f_flush(void);
extern  void            f_addchars(char *chaddr, int count, bool flush);
extern  void            f_putc(char ochar);
extern  void            f_puts(char *string, bool flush);
extern  int             f_putcs(char ochar);
extern  void            f_puttcs(int tcs_index, bool flush);
extern  void            f_putf(char *string, bool flush, int p1);
extern  void            empty_input(void);
extern  void            reset_kbread(void);
extern  bool            kbr_add(short c);
extern  short           kbread_next(void);
extern  void            clear_kbin(void);
extern  void            unget(short c);
extern  int             kbbuf_chars(void);
extern  short           kbbuf_next(void);
extern  int             do_kbbuf(bool help_only);
extern  int             read_kbbuf(int sec_timer);
extern  void            send_transp(int timer);
extern  void            do_kbread(void);
extern  void            put_save(unsigned char ch);
extern  void            reset_user(void);
extern  void            retry_output(bool clock_up);
extern  void            reader(void);
extern  void            resp_check(int cmd, int opt, int *flag);
extern  void            respondto(unsigned char *p);
extern  void            respond_opt(int cmd, int opt, int oldstate, int newstate);

#ifdef TTY

extern  SIGNAL_T        close_int(int sig_num);

#endif /* TTY */

extern  void            close_socket(void);
extern  void            writnet(int s, unsigned char *buf, int n);
extern  int             netgetc(void);

/* Internal parse.c module routines definition */

extern  char            *pr(char *s, int n);
extern  void            parse_init(void);
extern  void            parse_error(char *msg, char *action);
extern  int             parse_profile(char *p);
extern  char            *getstring(char *p, char **qq);
extern  void            buildtrie(void);
extern  int             update_trie(int i, int j, int p);

/* Internal sizer.c module routines definition */

#ifdef NOSIZER

extern  int             sizer(void);

#else /* NOSIZER */

extern  int             next_char(int prods);
extern  int             wait_scanf(void);
extern  int             sizer(void);

#endif /* NOSIZER */

/* Internal statusline.c module routines definition */

extern  void            slputstr(char *slstr, int offset, int bells);
extern  void            slerase(int count, int offset, int bells);
extern  void            slsave(void);
extern  void            slrestore(void);
extern  void            slclear(void);
extern  void            slrefresh(void);
extern  void            slinit(void);
extern  void            slterm(void);
extern  void            slfset(char *slstr, int bells);
extern  void            slfclear(void);


/*********************************************/
/*                                           */
/* end of ANSI function prototypes           */
/*                                           */
/*********************************************/

#else /* STANDARD_C */

/*********************************************/
/*                                           */
/* Non-ANSI function prototypes              */
/*                                           */
/*********************************************/

/* Internal telnet.c module routines definition */

extern  unsigned long   *alloc_buffer();
extern  unsigned long   *incr_buffer();
extern  void            usage();
extern  int             main();

#ifdef LOGFILE

extern  void            logit();
extern  void            logscreen();

#endif /* LOGFILE */

extern  void            end_program();
extern  int             get_options();

#ifdef OPTDIR

extern  int             set_options();

#endif /* OPTDIR */

extern  int             fileout();
extern  int             netopen();

/* Internal 3270.c module routines definition */

#ifdef DEBUG

extern  char            *print_ascii();

#endif /* DEBUG */

extern  void            init3270();
extern  void            reset_ff();
extern  void            update_normal();
extern  void            update_cs();
extern  void            int_orders();
extern  void            int_write();
extern  void            interpret();
extern  void            setup_field();
extern  int             checkSF();
extern  void            update_inf();
extern  void            changechar();
extern  void            act_unimpl();
extern  void            sendnet();
extern  bool            next_field();
extern  bool            ok_write();
extern  void            act_pa();
extern  void            act_home();
extern  void            act_newline();
extern  void            act_move();
extern  void            act_ascii();
extern  void            act_insert();
extern  void            act_debug();
extern  void            act_erase();
extern  void            act_erbsp();
extern  char            *set_fname();
extern  char            dialogue();
extern  void            act_help();
extern  void            act_escape();
extern  void            reset();
extern  void            redraw();
extern  void            mainreset();
extern  void            act_reset();
extern  void            act_mreset();
extern  void            act_tab();
extern  void            act_delete();
extern  int             delchar();
extern  void            place_char();
extern  void            act_nil();
extern  void            act_enter();
extern  void            send_char();
extern  void            act_refresh();
extern  void            act_option();
extern  void            act_print();
extern  void            act_fm();
extern  void            act_dup();
extern  void            place_special();
extern  void            act_highlight();
extern  void            act_colour();
extern  int             insertchar();
extern  void            help_act();

/* Internal cr_tty.c module routines definition */

extern  int             count_ch();
extern  int             tcstrlen();
extern  int             add_ch();
extern  void            zap();
extern  void            set_tcstr();

/* Internal curscr.c module routines definition */

extern  int             add_char();
extern  void            add_string();
extern  void            copy_cp();
extern  void            cchange_setup();
extern  int             movestrcnt();
extern  void            display_char();
extern  void            domvcur();
extern  bool            isdiff();
extern  void            makeline();

extern  int             set_cse();

#ifdef EXTENDED
extern  unsigned char   get_extend();
extern  int             set_extend();
#endif /* EXTENDED */

extern  void            clscreen();
extern  void            update_curscr();
extern  void            writecursor();
extern  void            putcursor();
extern  void            clearnormal();
extern  void            clearcurscr();
extern  void            clearscreen();

#ifdef SHOWFIELDS

extern  void            showfields();

#endif /* SHOWFIELDS */

extern  void            movecursor();
extern  void            winerase();

/* Internal finddef.c module routines definition */

extern  int             nextc();
extern  char            *find_def();

/* Internal initscr.c module routines definition */

extern  struct          curwin  *initscr();
extern  struct          curwin  *newwin();
extern  void            delwin();

/* Internal iomodule.c module routines definition */

extern  void            sys_fail();
extern  void            get_opbf();
extern  void            rel_opbf();
extern  void            unset_signals();
extern  SIGNAL_T        catch_signal();
extern  void            set_signals();

#ifdef TTY

extern  SIGNAL_T        cpu_int();
extern  void            set_cpu_timer();
extern  void            start_cpu_timer();
extern  SIGNAL_T        real_int();

#endif /* TTY */

extern  char            *getstime();
extern  int             f_compress();
extern  int             f_uncompress();
extern  int             select_check();
extern  void            show_tty();
extern  void            save_tty();
extern  void            init_tty();
extern  void            setup_tty();
extern  void            reset_tty();
extern  int             f_getc();
extern  void            f_clearop();
extern  int             f_output();
extern  void            f_flush();
extern  void            f_addchars();
extern  void            f_putc();
extern  void            f_puts();
extern  int             f_putcs();
extern  void            f_puttcs();
extern  void            f_putf();
extern  void            f_putf();
extern  void            empty_input();
extern  void            reset_kbread();
extern  bool            kbr_add();
extern  short           kbread_next();
extern  void            clear_kbin();
extern  void            unget();
extern  int             kbbuf_chars();
extern  short           kbbuf_next();
extern  int             do_kbbuf();
extern  int             read_kbbuf();
extern  void            send_transp();
extern  void            do_kbread();
extern  void            put_save();
extern  void            reset_user();
extern  void            retry_output();
extern  void            reader();
extern  void            resp_check();
extern  void            respondto();
extern  void            respond_opt();

#ifdef TTY

extern  SIGNAL_T         close_int();

#endif /* TTY */

extern  void            close_socket();
extern  void            writnet();
extern  int             netgetc();

/* Internal parse.c module routines definition */

extern  char            *pr();
extern  void            parse_init();
extern  void            parse_error();
extern  int             parse_profile();
extern  char            *getstring();
extern  void            buildtrie();
extern  int             update_trie();

/* Internal sizer.c module routines definition */

#ifdef NOSIZER

extern  int             sizer();

#else /* NOSIZER */

extern  int             next_char();
extern  int             wait_scanf();
extern  int             sizer();

#endif /* NOSIZER */

/* Internal statusline.c module routines definition */

extern  void            slputstr();
extern  void            slerase();
extern  void            slsave();
extern  void            slrestore();
extern  void            slclear();
extern  void            slrefresh();
extern  void            slinit();
extern  void            slterm();
extern  void            slfset();
extern  void            slfclear();


/*********************************************/
/*                                           */
/* end of Non-ANSI function prototypes       */
/*                                           */
/*********************************************/

#endif /* STANDARD_C */

#ifdef NOT_STDC_ENV

/* Library routines definition (ones which would be in stdlib.h) */

#ifdef STANDARD_C

extern  void            exit(int status);
extern  void            free(void *__ptr );
extern  char            *getenv(const char *name);
extern  void            *malloc(size_t size);

#else /* STANDARD_C */

extern  void            exit();
extern  void            free();
extern  char            *getenv();
extern  void            *malloc();

#endif /* STANDARD_C */

#endif /* NOT_STDC_ENV */

#ifdef NOT_POSIX

/* Library routines definition (ones which would be in unistd.h) */

#ifdef STANDARD_C

extern  unsigned        alarm(unsigned seconds);
extern  unsigned        sleep(unsigned seconds);
extern  char            *ttyname(int filedes);

#else /* STANDARD_C */

extern  unsigned        alarm();
extern  unsigned        sleep();
extern  char            *ttyname();

#endif /* STANDARD_C */

#endif /* NOT_POSIX */

#ifdef STANDARD_C

/* ANSI Library routines definition (miscellaneous) */

#ifndef getlogin
extern  char            *getlogin(void);
#endif /* getlogin */

#ifndef getpid

/* Problem here: pid_t is not always defined as a typedef! */

/* extern  pid_t           getpid(void); */

#endif /* getpid */

#ifndef perror
extern  void            perror(const char *s);
#endif /* perror */

#ifdef SYSV

#ifndef rand
extern  int             rand();
#endif /* rand */

#else /* SYSV */

#ifndef random
extern  long            random();
#endif /* random */

#endif /* SYSV */

#ifndef sys_apollo

#ifndef setvbuf
extern  int             setvbuf(FILE *stream, char *buf, int type, size_t size);
#endif /* setvbuf */

#endif /* sys_apollo */

#ifndef strcat
extern  char            *strcat(char *s1, const char *s2);
#endif /* strcat */

#ifndef strcpy
extern  char            *strcpy(char *s1, const char *s2);
#endif /* strcpy */

#ifndef strncpy
extern  char            *strncpy(char *s1, const char *s2, size_t n);
#endif /* strncpy */

#ifndef tgetent
extern  int             tgetent(char *bp, char *name);
#endif /* tgetent */

#ifndef tgetflag
extern  int             tgetflag(char *id);
#endif /* tgetflag */

#ifndef tgetnum
extern  int             tgetnum(char *id);
#endif /* tgetnum */

#ifndef tgetstr
extern  char            *tgetstr(char *id, char **area);
#endif /* tgetstr */

#ifndef tgoto
extern  char            *tgoto(char *cm, int destcol, int destline);
#endif /* tgoto */

#ifndef tputs
extern  void            tputs(char *cp, int affcnt, int (*outc)(char ch));
#endif /* tputs */

/*********************************************/
/*                                           */
/* end of ANSI library function prototypes   */
/*                                           */
/*********************************************/

#else /* STANDARD_C */

/* non-ANSI Library routines definition (miscellaneous) */

#ifndef getlogin
extern  char            *getlogin();
#endif /* getlogin */

#ifndef getpid

/* Problem here: pid_t is not always defined as a typedef! */

/* extern  pid_t           getpid(); */

#endif /* getpid */

#ifndef perror
extern  void            perror();
#endif /* perror */


#ifdef SYSV

#ifndef rand
extern  int             rand();
#endif /* rand */

#else /* SYSV */

#ifndef random
extern  long            random();
#endif /* random */

#endif /* SYSV */

#ifndef sys_apollo

#ifndef setvbuf
extern  int             setvbuf();
#endif /* setvbuf */

#endif /* sys_apollo */

#ifndef strcat
extern  char *          strcat();
#endif /* strcat */

#ifndef strcpy
extern  char *          strcpy();
#endif /* strcpy */

#ifndef strncpy
extern  char *          strncpy();
#endif /* strncpy */

#ifndef tgetent
extern  int             tgetent();
#endif /* tgetent */

#ifndef tgetflag
extern  int             tgetflag();
#endif /* tgetflag */

#ifndef tgetnum
extern  int             tgetnum();
#endif /* tgetnum */

#ifndef tgetstr
extern  char            *tgetstr();
#endif /* tgetstr */

#ifndef tgoto
extern  char            *tgoto();
#endif /* tgoto */

#ifndef tputs
extern  void            tputs();
#endif /* tputs */

/***********************************************/
/*                                             */
/* end of Non-ANSI library function prototypes */
/*                                             */
/***********************************************/

#endif /* STANDARD_C */

#define CTL(c) ('c' & 037)
#define ESC '\033'

#ifndef ANNOUNCE
#define ANNOUNCE  "3270_news"
#endif /* ANNOUNCE */

#ifndef HELPEMUL
#define HELPEMUL  "3270_emulation"
#endif /* HELPEMUL */

#ifndef HELPEXT
#define HELPEXT   "3270_extended"
#endif /* HELPEXT */

#ifndef HELPFALCO
#define HELPFALCO "3270_falco"
#endif /* HELPFALCO */

#ifndef HELPFILE
#define HELPFILE  "3270_help"
#endif /* HELPFILE */

#ifndef HELPMAP
#define HELPMAP   "3270_mhelp"
#endif /* HELPMAP */

#ifndef HELPOPT
#define HELPOPT   "3270_options"
#endif /* HELPOPT */

#ifndef HELPPRINT
#define HELPPRINT  "3270_print"
#endif /* HELPPRINT */

#ifndef PROFILE
#define PROFILE "/etc/map3270"
#endif /* PROFILE */

/*
 * If either GRAPHICS or TTY are defined then we will need transparent I/O.
 * For this we will need to define TRANSP_IO.
 */

#ifdef GRAPHICS

#define TRANSP_IO

/*
 * flag for transparent graphics feature (BS)
 *      > 0 : waiting for transparent input
 *      < 0 : transparent output mode
 */

extern  int             graphics;

#endif /* GRAPHICS */

#ifdef TTY

#define TRANSP_IO

/* flag for kermit (transparent) input mode */

extern  int             kermit;

#endif /* TTY */

#ifdef TRANSP_IO

/*
 * Overall flag non-zero if in transparent I/O mode
 *      > 0 : waiting for transparent input
 *      < 0 : transparent output mode
 */

extern  int             trflag;

#endif /* TRANSP_IO */

extern  char            *ttyn;
extern  int             ttypid;

extern  char            *term_type, termcap[1024];
extern  char            *keymap_type;

/* character buffer for a full file name */
extern  char            full_fname[100];

extern  char            *default_def;

extern  char            eschar[20];

/* Note the IP address of the host: may need it in a file name */

extern  unsigned long   ip_address;
extern  char            ip_chaddr[];

/* Buffer size for network receive buffer */

#define NETBSIZE 1600

/* Incremental size for savebuf */

#define SAVEB_INCR 200

/* pointers to buffer for holding a 3270 command from the host */
extern unsigned char *savebuf;     /* base address of allocated buffer */
extern unsigned char *savep;       /* pointer within allocated buffer  */

/* current size of savebuf */

extern  int             saveb_size;

/* file descriptors */

/* Raw output device file descriptor and stream FILE structure */

extern  int             fd_output;
extern  FILE            *fd_stream;

extern  int             net;    /* file descriptor for the network connection */

#ifdef FROMNET

extern  int             fromnet;/* file descriptor for logging everying from the network */

#endif /* FROMNET */

#ifdef TONET

extern  int             tonet;  /* file descriptor for logging everying to the network */

#endif /* TONET */

#ifdef DEBUG

extern  FILE            *outf;  /* debug output file                    */

#endif /* DEBUG */

#ifdef LDEBUG

extern  FILE            *log;   /* for logging various interesting things */
#define LOG if (log) fprintf

#endif /* LDEBUG */

/* Flag for indicating that the program is ending (in end_program) */

extern  int             ending_program;

/*
 * For the synchronous output cases we will need to have various
 * possible values for the time we are prepared to wait for any
 * synchronous output to terminate. For example, in the case of graphics
 * output some users like to use the "Hold Screen" facility of a
 * terminal, so there should be a relatively long timer. On the other
 * hand, at program termination we are not prepared to wait very long.
 * (remember, though, that there are only real timers on synchronous
 * output if compiled with -DTTY: without this we assume a workstation
 * and are prepared to wait forever).
 */

#define SYNCH_NORMAL    10      /* Normal synchronous wait                 */
#define SYNCH_DIALOGUE  60      /* Dialogue synchronous wait               */

#ifdef TRANSP_IO

#define SYNCH_TRANSP   600      /* Long synchronous wait (graphics/kermit) */

#endif /* TRANSP_IO */

/* Flag when we want synchronous output */

extern  int             synch_op;

/*
 * Flag for saying what is the mode of the user's terminal
 *  0:  We have still got his original terminal setup
 *  1:  Now he is set up in (asynchronous) 3270 setup
 * -1:  Now he is temporarily back in synchronous dialogue mode
 */

extern  int             term_mode;

/*
 * Flag which will be set when the IBM sets telnet binary mode
 * 0: in "glass tty" mode
 * 1: in 3270 emulation mode
 */

extern  int             binflag;

/* states of various options */
extern  int             will_tt, will_eor, do_eor, will_binary, do_binary, do_sga, will_tm;
extern  int             sent_tt; /* IAC SB TERMINAL_TYPE IS ... IAC SE has been sent */

/*
 * There follow the various options that a user can have which can be
 * set in the call or changed in the on-line help options menu.
 * The first, however, is special: it identifies the last ANNOUNCE file
 * which the user has seen.
 * Note that the OPT_COUNT symbol must match the total number of options.
 * Note also that the string values are only needed for if we want to
 * read/write these values from/to an options file in OPTDIR.
 */

#define OPT_COUNT       7

/* Value for the last ANNOUNCE file seen by the user */

extern  int             announce_id;
extern  int             def_announce_id;

/* Indicator for if 7171 emulation is required */

extern  int             emul7171;
extern  int             def_emul7171;

/* Indicator for if quiet mode wanted */

extern  int             bells_mode;
extern  int             def_bells_mode;

/* Indicator for if we should show MDT fields, possibly in reverse video */

extern  int             show_MDT_field;
extern  int             def_show_MDT_field;

/* Indicator for if we should keep insert mode across attention keys */

extern  int             keep_insert;
extern  int             def_keep_insert;

/*
 * To allow users to save screen dumps, including the possibility of
 * some (crontab) procedure to pick up the dumps and print them on
 * a specified printer (perhaps via lpr, perhaps via some other method)
 * we will want to create file names.
 * The file name will consist normally of three parts, separated by
 * a colon ( ':' ) character.
 * part 1: the user name (which might be the id of the calling user
 *         or the VM user name given in the program call.
 * part 2: the type qualifier, with "prt" being the default (to be changed
 *         to some default printer by any crontab shell script).
	   This part can be changed by the user in the options menu.
 * part 3: something, maybe a simple integer, to make the file unique
 *         in the directory in which it is being saved.
 */

/* Base filename for user's screen print files : normally the user name */

#define P_USIZE         10
extern  char            print_user[P_USIZE];

/* File type (may specify a printer!) for user's screen print files */

#define P_TSIZE         40
extern  char            print_type[P_TSIZE];
extern  char            def_print_type[P_TSIZE];

/*
 * Once we have the file name we will want to construct a complete
 * fully qualified file name, specifying the directory chosen for saving
 * the files.
 */

#define P_FSIZE         100
extern  char            print_file[P_FSIZE];

/* FILE structure pointer for the screen print file (NULL if non-existent) */

extern  FILE            *print_fstr;

/*
 * We might also like to know the preferred email address of the user.
 * This can be useful for telling people about problems.
 * It is also used for sending print screen dumps in the case that the
 * user defines the (printer) file type as "email".
 * The same method is used as for the saved screen dumps, except that
 * the name of the saved file will have as part 1 the character '@' in
 * front of the user name.
 * Again, the actual sending of the file will be automatic only if there
 * is a (crontab) procedure to do so. This procedure will normally be
 * the same as for print files, since the scanning of the files in the
 * save directory will be practically identical.
 */

/* Full email address for user's screen print files */

#define P_ESIZE         40
extern  char            email_addr[P_ESIZE];
extern  char            def_email_addr[P_ESIZE];

#ifdef OPTDIR

/* File name for the user's chosen options */

extern  char            opt_file[100];

/* FILE structure pointer for the option file (NULL if non-existent) */

extern  FILE            *opt_fstr;

#endif /* OPTDIR */

/*
 * The addresses of the various option variables.
 * plus the associated format statements to read or write them.
 * Note that the first one MUST be the positive identification value
 * for the last announcement file that the user has seen.
 * Note also that there is one array for integer values, one for string
 * values and one (boolean) to indicate which is which!
 */

extern  int             opt_smaxlen[OPT_COUNT];

extern  void            *opt_pointer[OPT_COUNT];

extern  void            *opt_default[OPT_COUNT];

#ifdef OPTDIR

extern  char            *opt_format[OPT_COUNT];

#endif /* OPTDIR */

/*
 * We will want to be able to interpret the above options via single
 * characters. These characters, which may be specified in the call as
 * -<character>
 * will most often refer to a particular setting of an option pointed
 * to from the opt_pointer array.
 * However, some may not be applicable at call time (such as a request
 * to save the current set of options values)
 *
 * opt_cchar[]          lists all the characters.
 * opt_cindex[]         specifies the index into the opt_pointer array(s),
			but a negative value implies no such index.
 * opt_cival[]          gives the integer value for putting into the variable
			pointed to by the opt_pointer array, but only
			provided that opt_smaxlen is 0, i.e. it is an integer.
 * opt_cmess[]          is a string explaining the character and value.
 */

#define OPT_CSIZE       11

extern  char            opt_cchar[OPT_CSIZE];

extern  int             opt_cindex[OPT_CSIZE];

extern  int             opt_cival[OPT_CSIZE];

extern  char            *opt_cmess[OPT_CSIZE];


/* type of virtual 3270 terminal */

extern  char            *TERMNAME;      /* IBM-3278-x */
extern  int             rows;           /* 24, 32, or 43 */
extern  int             linelen;        /* 80  or 132 */
extern  int             screensize;

extern  char            *progname;      /* to remember argv[0] (BS)  */
extern  char            *remotename;    /* to remember required host name/number (JMG) */
extern  char            *username;      /* to remember (optional) IBM user name (JMG) */
extern  char            *dialname;      /* to remember (optional) dial host name */

#ifdef LOGFILE

extern  int             name_field;     /* field for initial name to be logged */

#endif /* LOGFILE */

/*
 * Tables for input escape sequences.
 *
 * Escape_char[] and escape_ptr are parallel arrays simulating an
 * array of structs (but 25% smaller) containing a trie.  Each node in
 * the trie is represented by a contiguous segment of the arrays,
 * terminated by a slot with escape_char[i] = '\377'.
 * The entries of a node are sorted by the escape_char field.  Each node
 * corresponds to the set of all strings with a given initial prefix.
 * Consider slot i in the node corressponding to prefix 'w',
 * with escape_char[i]=c and escape_ptr[i]=j.  If j>0, j is the start
 * of the node corresponding to wc.  If j<0, -j is the action code associated
 * with the string wc.
 *
 * Escape_start[c] points to the start of the node corresponding to the
 * (one-character) prefix 'c'.  If no string starts with 'c', escape_start[c]
 * is null.
 *
 * Note that this representation precludes '\377' as a character in a
 * <string> (except as the first character).
 */

#define MAXESCAPECHARS  700
#define MAXESCAPES      150
#define FLAG            255

extern  short           escape_start[256];
extern  unsigned char   escape_char[MAXESCAPECHARS];
extern  short           escape_ptr[MAXESCAPECHARS];
extern  int             next_escape;

#define DEFAULTPORT     23

/* ring the bell */
#define DING { (void)f_puts((BL ? tgoto(BL, 0, 0) : "\007"), TRUE); }

/* increment or decrement a counter with wrapping at the ends of the screen */
#define INCR(x) ((x) >= (screensize - 1) ? 0 : (x) + 1)
#define DECR(x) ((x) <= 0 ? (screensize - 1) : (x) - 1)
#define INC(x)  if (++(x) >= screensize) (x)=0
#define DEC(x)  if (--(x) < 0 ) (x) = screensize-1

/* The following is useful for debugging:  Transform a position
 * (0..screensize-1), to a one-origin (line,column) pair.
 */
#define YX(pos) (pos)/linelen+1,(pos)%linelen+1

/* Various 3270 indicators */
extern  int             clearsn;        /* Positive if clear screen requested by IBM */
					/* It is 1 for normal screen, 2 for alternate */
					/* It is negated when the screen has been cleared, */
					/* but before the new IBM screen (if any) drawn. */
extern  bool            insert;         /* TRUE if terminal in insert mode */
extern  bool            unlock;         /* TRUE if terminal input is allowed */

/* status indicators as to whether things are working or hung */

extern  int             op_wait;        /* # characters of output waiting to go to the user */

#ifdef TTY

extern  int             idle_count;     /* count how long user has done nothing */

#endif /* TTY */


/*
 * Data structure for representing fields.
 * The screen array simulates the contents of 3278 internal memory.
 * It is allocated by the alloc_buffer routine.
 * Each position contains in the least significant byte a field-definition
 * character or an ASCII ISO 8859-1 character.
 * The upper part can have flags in it: FIELDSTART is the main one, so that
 * (screen[p] & FIELDSTART) != 0 iff position p is the start of a field.
 * In this case the lower part is copied from the attribute byte following
 * the SF order.
 *
 * For normal characters there is a flag GE_CHAR to indicate that the
 * character came after a Graphics Escape byte. In such cases the translation
 * to and from ASCII must go according to a different table. This table
 * will convert an EBCDIC Graphic character into a 16-bit character in
 * which the least significant 7 bits is the ASCII code, whilst the bits
 * above select one of several possible character sets.
 *
 * In order to have compatibility with an 8-bit system we will consider
 * the 0x80 bit as both part of an 8-bit character and the selection of
 * the required 7-bit character set when in a 7-bit environment.
 * The 0x100 bit may, however, select a different character set from
 * the ASCII ISO 8859-1 one. Thus, the combination of bits 0x100 and 0x80
 * can imply any of the following:-
 *
 * 00   ASCII 7-bit     normally assumed in G0.
 * 01   ASCII 8-bit     normally assumed in G2 (ISO Latin-1 if on a VT300
 *                      or clone, DEC supplemental if a VT200 or clone).
 * 10   Graphics 7-bit  normally assumed in G1 as DEC Special Graphics
 *                      (even exists on the good old VT100!).
 * 11   Graphics 8-bit  normally assumed in G3 as DEC Technical Character
 *                      set, but only on a VT300 or clone.
 *
 * Unfortunately, however, we may get the IBM sending characters which
 * are undefined in the graphics set (to be displayed as '-') or ones we
 * cannot print. To cater for these cases without losing the one-to-one
 * mapping property we include a bit to specify extra sets in which
 * every 8-bit character comes out looking like the same character. Thus,
 * the translation of any such character is the same character byte but
 * in this mythical character set. The reverse mapping is therefore
 * unique and identical. We put this bit into the 0x200 position, making
 * four extra 8-bit mappings of bits 0x200, 0x100 and 0x80 as follows :-
 *
 * 10x  Undefined graphics character: print as '-'
 * 11x  Unprintable graphics character: print as some special character.
 *
 */

extern  short           *screen;

#define FIELDSTART     0x8000
#define GE_CHAR         0x800
#define GE_UNDERSCORE   0x400
#define GE_SET_MASK     0x380
#define GE_A_7          0x000
#define GE_A_8          0x080
#define GE_G_7          0x100
#define GE_G_MASK       0x100
#define GE_G_8          0x180
#define GE_NBG          0x200
#define GE_SET_SHIFT        7

#ifdef EXTENDED

/*
 * If we want to be able to handle extended attributes then we need a
 * parallel array to screen. This parallel array needs to handle
 * extended highlighting, extended color and symbol sets.
 * We will call this parallel array screen_ex.
 * We will assign the low order 4-bit nibble to extended highlighting,
 * the next 4-bit nibble to extended color and the top byte to the
 * symbol set. The exact specs will look as follows :-
 *
 * Extended highlighting
 *
 * Bit 0 : Blink
 * Bit 1 : Reverse Video
 * Bit 2 : Underscore
 * Bit 3 : Indicate that the nibble has been specifically set
 *
 * Extended color
 *
 * Bits 4-6 : requested color   0 - default
 *                              1 - blue
 *                              2 - red
 *                              3 - pink
 *                              4 - green
 *                              5 - turquoise
 *                              6 - yellow
 *                              7 - monochrome (black or white)
 * Bit 7 : Indicate that the nibble has been specifically set
 *
 * Symbol set
 *
 * Bits 8-15 : the symbol set as requested by the IBM
 *
 * In reality the symbol set will not yet be implemented. As far as I
 * can see it is only of use if we have structured fields or the APL
 * character set requirement: neither is possible just yet. Therefore,
 * the screen_ex array will be just 8-bit unsigned char.
 *
 * Note that the significance of bits 3 and 7 is to say that the value
 * is specifically set. If no value is set then we may choose how to
 * output the characters according to the field style.
 */

extern  unsigned char   *screen_ex;

/* And we need to know the current value */

extern  unsigned char   current_ex;

/* Highlight values */

#define EX_BLINK        0x01
#define EX_REVERSE      0x02
#define EX_UNDERSCORE   0x04
#define EX_HIGHLIGHT    0x08

/* Highlight masks */

#define EX_HBITS        0x07
#define EX_HSBITS       0x0f
#define EX_MASKHIGH     0xf0

/* Colour values */

#define EX_C_DEFAULT    0x00
#define EX_C_BLUE       0x10
#define EX_C_RED        0x20
#define EX_C_PINK       0x30
#define EX_C_GREEN      0x40
#define EX_C_TURQUOISE  0x50
#define EX_C_YELLOW     0x60
#define EX_C_MONO       0x70
#define EX_COLOUR       0x80

/* Colour masks */

#define EX_CBITS        0x70
#define EX_CSBITS       0xf0
#define EX_MASKCOLOUR   0x0f

/* Also define the permitted type codes */

#define EX_T_ALL_CHAR   0x00
#define EX_T_F_ATTRIB   0xc0
#define EX_T_F_VALID    0xc1
#define EX_T_F_OUTLINE  0xc2
#define EX_T_HIGHLIGHT  0x41
#define EX_T_COLOUR     0x42
#define EX_T_CHAR_SET   0x43

/*
 * Now we need to know whether the IBM is permitting extended character
 * attributes to be changed, and if so whether the user has selected
 * a different attribute.
 * All that we allow for the moment are extended highlighting and
 * extended colour.
 */

extern  bool            reply_highlight;        /* True if user can change highlight */
extern  unsigned char   user_highlight;         /* highlight choice (lower 4 bits)   */
extern  bool            reply_colour;           /* True if user can change colour    */
extern  unsigned char   user_colour;            /* colour choice (lower 4 bits)      */

#endif /* EXTENDED */

/*
 * To know which regions of the screen array need updating.
 * s_point is an array parallel to screen.
 * s_pfirst is either -1 or an index into s_point.
 *   if an index then s_point[s_pfirst] is also an index into s_point
 *   indicating that the screen region from s_point to screen[s_point]
 *   inclusive is new (to be written to the user screen).
 * Since there may be more than one such region we continue with
 *   screen[screen[s.point]] as either -1 or a new pointer.
 */

extern  short           *s_point, s_pfirst;

/*
 * Now the possible display modes according to the "styles.
 * For each pair of styles we need the escape string to change
 * from one style to another, and we need the pointers to these strings.
 * NB. The blinking style is always odd and the invisible is always last
 */

#define NORMAL          0
#define NORM_BLINK      1
#define NORM_PROT       2
#define NORM_PR_BLINK   3
#define BOLD            4
#define BOLD_BLINK      5
#define BOLD_PROT       6
#define BOLD_PR_BLINK   7
#define NORM_MOD        8
#define NORM_M_BLINK    9
#define BOLD_MOD       10
#define BOLD_M_BLINK   11
#define STATL          12
#define STATL_BLINK    13
#define INVISIBLE      14
#define MAXSTYLES      INVISIBLE+1

/* String to change from one style to another */

extern  char            *change_cp[MAXSTYLES][MAXSTYLES];

/* Length of corresponding change_cp string */

extern  short           change_sl[MAXSTYLES][MAXSTYLES];

/* Indicator for if the string may reset character highlighting */

extern  bool            change_rh[MAXSTYLES][MAXSTYLES];

/* Boolean to say if cursor can be moved when in a particular style */

extern  bool            move_ok[MAXSTYLES];

/* Boolean to say whether blanks look "normal" in this style. */
/* If so then we can use the "clear to end of line" sequence. */

extern  bool            ceol_ok[MAXSTYLES];

/* Boolean to say if the current screen has only NORMAL-style characters */

extern  bool            normal_chars;

/* Boolean to say if the current screen has only NORMAL-style blanks */

extern  bool            normal_blanks;


/* screen[firstfield] is the first element with the FIELDSTART bit set.
 * If no fields are currently defined, firstfield == -1.
 */
extern  int             firstfield;
#define FORMATTED       (firstfield >= 0)

/* The contents of the screen are copied into the curscr data
 * structure maintained by curses.
 * curscr->char_y and curscr->ccset_y are arrays of pointers,
 * each pointing to an array of characters representing one line.
 * The char_y array is the actual character on the user screen.
 * The ccset_y array is both the style and the character set of the
 * character on the user screen.
 * This ccset is divided into two 4-bit "nibbles".
 * The more significant nibble is the "style" as one of the options
 * NORMAL, NORM_BLINK, ... , INVISIBLE
 * On simple terminals this is merely whether the character is highlighted
 * or not: more sophisticated terminals might have more properties such
 * as colour, blinking, dim etc.
 * The less significant nibble is the special indicator for
 * characters which came from the IBM with graphics escape and/or
 * are not part of the standard 8-bit ASCII set.
 */

/* The current (y,x) position is stored in curscr as follows */
#define Y       (curscr->_cury)
#define X       (curscr->_curx)

extern  unsigned char   **char_image;
extern  unsigned char   **ccset_image;

/* The contents of char_image differ from screen in the following ways:
 *   char_image is an array of arrays, while screen is one-dimensional
 *   The following kinds of positions contain spaces in char_image
 *      field definition characters
 *      positions in invisible fields
 *      null characters
 * ccset_image is like char_image, except that it is for the "style and
 * character set" of the character, not the character itself.
 */

#ifdef EXTENDED

/*
 * In case we are handling extended attributes we also need to know what
 * is the extended attribute of the character.
 * This attribute is currently an unsigned character consisting of a nibble
 * for the colour and a nibble for the highlighting.
 */

extern  unsigned char   **ccext_image;

#endif /* EXTENDED */

/* Extension to allow for both a normal and an alternate screen */

extern  int             LINES;          /* Current number of lines */
extern  int             COLS;           /* Current number of columns */

extern  bool            altflip;        /* TRUE if there is an alternate screen  */
extern  int             altscreen;      /* 0: normal screen, 1: alternate screen */

extern  int             init_COLS;      /* lines on initial user display     */
extern  int             init_LINES;     /* columns on initial user display   */

extern  int             normal_linelen; /* lines in normal 3270 screen       */
extern  int             normal_rows;    /* rows in normal 3270 screen        */
extern  int             normal_LINES;   /* lines on normal user display      */
extern  int             normal_COLS;    /* columns on normal user display    */
extern  int             normal_slinenum;/* status line on normal display     */

extern  int             altern_linelen; /* lines in alternate 3270 screen    */
extern  int             altern_rows;    /* rows in alternate 3270 screen     */
extern  int             altern_LINES;   /* lines on alternate user display   */
extern  int             altern_COLS;    /* columns on alternate user display */
extern  int             altern_slinenum;/* status line on normal display     */

extern  short           ly, lx;         /* current cursor position */

/* The following variables keep track of the current cursor position */
extern  int             cursorpos;      /* 0..screensize-1 */
extern  int             cursorsave;     /* 0..screensize-1 */
extern  int             bufferpos;      /* current buffer position (set by SBA order) 0..screensize-1 */
extern  int             fieldstart;     /* first position of field currently containing cursor */
extern  unsigned char   currentstyle;   /* style associated with the current field (fieldstart) */

#ifdef EXTENDED
extern  unsigned char   currentextend;  /* extended characteristics associated with the current field (fieldstart) */
#endif /* EXTENDED */

extern  unsigned char   styletab[];     /* get "style" from field definition */

#define stylebits(c)    (unsigned char)styletab[(c) & 0x7f];

/* the following variables specify new parts of screen for update_curscr */
extern  int             startpos;       /* start position (may be field definition) */
extern  int             endpos;         /* end position (exclusive) */

/* keep count of calls to update_curscr (will be reset by put/writecursor */
extern  int             updateflag;

extern  bool            sline;          /* TRUE if writing 3270 status line */
extern  int             slinenum;       /* status line number if not HS */

extern  int             scroll_line;    /* >0 : line which would cause scroll */
					/* <0 : any line COULD cause a scroll */

/*
 * Variables concerned with 8-bit mode, extended ASCII and so on.
 * Terminals set up for 7-bit mode can nonetheless have the extended
 * characters by the judicious use of Shift In/Out (SI/SO).
 * For 8-bit data input we may need to transform 8-bit control codes
 * into two 7-bit codes unless we have seen that 8-bit controls is OK.
 */

/* Flag for if terminal can handle 8-bit controls */

extern  bool            eight_bc;

/* Flag for if terminal can handle 8-bit data */

extern  bool            eight_bd;

/* Mask for OR of input character (0x80 after SO received, reset by SI) */

extern  short           SO_imask;

/* Used to change incoming 8-bit control character to ESC + 7-bit */

extern  bool            ESC_iflag;

/* Used to change outgoing ESC + 7-bit to 8-bit control character */

extern  bool            ESC_oflag;

/*
 * Used before and after an extended character (>0x7f).
 * The two bits just before the 7-bit character will index into
 * this table.
 */

extern  char            *SO_string[4];
extern  char            *SI_string[4];

/*
 * Chararacter to put out when the IBM has sent a graphics escape
 * character which is either illegal or one that we cannot manage
 * to produce on our ASCII screen.
 */

extern  char            NBG_illegal;
extern  char            NBG_notgot;

/*
 * Table to get from ASCII control characters which somehow appear from
 * the EBCDIC to ASCII translation to a suitable ASCII printable character.
 * Define in 3270.c with all the other translation tables, but only use
 * when actually putting out the screen.
 */

extern  unsigned short atop[];


/*
 * Various things concerned with the use of termcap sequences.
 * We keep a set of standard sequences, possibly including timing chars,
 * so as to avoid using low-level routines like tputs all the time.
 * We also invent a few new entries: if they are not in the actual
 * termcap entry it will not matter.
 */

#define         ERR     (0)
#define         OK      (1)

#define         MAXLINES    (100)

/*
 * Capabilities from termcap
 */

extern short            ospeed;

extern short            AM, BS, CA, MI, MS, ES, HS;

extern  char            *BC, *BT, *CD, *CE, *CL, *CM, *CR,
			*DO, *ND, *NL,
			*SE, *SO, *TE, *TI, *UC, *UE, *UP, *US;
extern  char            *BL, *CV, *DS, *FS, *IS, *LE, *MB, *MD,
			*ME, *MH, *MR, *RS, *TS;
extern char             PC;



/* extra pseudo-termcap capabilities added in by JMG */

extern  short           VW;     /* TRUE if VT-100 type autowrap, i.e. it does not  */
				/* scroll immediately at the end of a line         */

#ifdef EXTENDED

/* Index into tcs*[] arrays for set/unset of extended highlighting */

extern  int             extend_set[8];
extern  int             extend_unset[8];

/* The various colours for the IBM display */

/* First when in normal mode */

extern  char            *C0;    /* sequence for 3279 colour 0 (default)            */
extern  char            *C1;    /* sequence for 3279 colour 1 (red)                */
extern  char            *C2;    /* sequence for 3279 colour 2 (green)              */
extern  char            *C3;    /* sequence for 3279 colour 3 (yellow)             */
extern  char            *C4;    /* sequence for 3279 colour 4 (blue)               */
extern  char            *C5;    /* sequence for 3279 colour 5 (magenta/pink)       */
extern  char            *C6;    /* sequence for 3279 colour 6 (cyanide/turquoise)  */
extern  char            *C7;    /* sequence for 3279 colour 7 (neutral)            */

/* then when in reverse video mode */

extern  char            *R0;    /* sequence for 3279 reverse 0 (default)           */
extern  char            *R1;    /* sequence for 3279 reverse 1 (red)               */
extern  char            *R2;    /* sequence for 3279 reverse 2 (green)             */
extern  char            *R3;    /* sequence for 3279 reverse 3 (yellow)            */
extern  char            *R4;    /* sequence for 3279 reverse 4 (blue)              */
extern  char            *R5;    /* sequence for 3279 reverse 5 (magenta/pink)      */
extern  char            *R6;    /* sequence for 3279 reverse 6 (cyanide/turquoise) */
extern  char            *R7;    /* sequence for 3279 reverse 7 (neutral)           */

#endif /* EXTENDED */

extern  char            *IB;    /* sequence to visually indicate insert mode       */
extern  char            *IE;    /* sequence to visually indicate non-insert mode   */
extern  char            *KE;    /* sequence to end keypad transmit mode            */
extern  char            *KS;    /* sequence to start keypad transmit mode          */
extern  char            *RT;    /* sequence to move cursor right n positions       */
extern  char            *SN;    /* sequence to change to normal (80-col) screen    */
extern  char            *SW;    /* sequence to change to wide (132-col) screen     */

#define         tcsCL   0
#define         tcsIS   1
#define         tcsCR   2
#define         tcsUP   3
#define         tcsDO   4
#define         tcsLE   5
#define         tcsND   6
#define         tcsBL   7
#define         tcsCE   8
#define         tcsDS   9
#define         tcsFS  10
#define         tcsTS  11
#define         tcsSN  12
#define         tcsSW  13
#define         tcsKE  14
#define         tcsKS  15
#define         tcsTE  16
#define         tcsTI  17
#define         tcsIB  18
#define         tcsIE  19
#define         tcsMB  20
#define         tcsMR  21
#define         tcsME  22
#define         tcsUS  23
#define         tcsUE  24

#ifdef EXTENDED

/* The various colours for the IBM display */

#define         tcsC0  25
#define         tcsC1  26
#define         tcsC2  27
#define         tcsC3  28
#define         tcsC4  29
#define         tcsC5  30
#define         tcsC6  31
#define         tcsC7  32

#define         tcsR0  33
#define         tcsR1  34
#define         tcsR2  35
#define         tcsR3  36
#define         tcsR4  37
#define         tcsR5  38
#define         tcsR6  39
#define         tcsR7  40

#define         tcsMAX 41

#else /* EXTENDED */

#define         tcsMAX 25

#endif /* EXTENDED */

extern  char            **tcset[];
extern  char            *tcsptr[];
extern  int             tcslen[];

extern  struct  curwin  curscr_window;
extern  unsigned char   *curscrch_y[MAXLINES];
extern  unsigned char   *curscrccs_y[MAXLINES];

#ifdef EXTENDED
extern  unsigned char   *curscrcex_y[MAXLINES];
#endif /* EXTENDED */

extern  struct  curwin  *curscr;

/* Name and line of the profile currently being parsed (for error messages) */

extern  char            *profile;
extern  int             profline;
