/*
 *     Copyright CERN, Geneva 1989 - Copyright and any other
 *     appropriate legal protection of these computer programs
 *     and associated documentation reserved in all countries
 *     of the world.
 */

/*
 *  Copyright (c) 1984 Marvin Solomon; all rights reserved
 */
/*
 * Global definitions for user telnet
 *
 *
 *
 */
#include "globals.h"

/*
 * If either GRAPHICS or TTY are defined then we will need transparent I/O.
 */

#ifdef GRAPHICS

/*
 * flag for transparent graphics feature (BS)
 *      > 0 : waiting for transparent input
 *      < 0 : transparent output mode
 */

int             graphics = 0;

#endif /* GRAPHICS */

#ifdef TTY

/* flag for kermit (transparent) input mode */

int             kermit = 0;

#endif /* TTY */

#ifdef TRANSP_IO

/*
 * Overall flag non-zero if in transparent I/O mode
 *      > 0 : waiting for transparent input
 *      < 0 : transparent output mode
 */

int             trflag = 0;

#endif /* TRANSP_IO */

char            *ttyn;
int             ttypid;

char            *term_type, termcap[1024];
char            *keymap_type;

/* character buffer for a full file name */
char            full_fname[100] = "";

char            eschar[20] = "";

/* Note the IP address of the host: may need it in a file name */

unsigned long   ip_address;
char            ip_chaddr[] = "xxx.xxx.xxx.xxx";

/* pointers to buffer for holding a 3270 command from the host */
unsigned char *savebuf = 0;     /* base address of allocated buffer */
unsigned char *savep = 0;       /* pointer within allocated buffer  */

/* current size of savebuf */

int             saveb_size = 0;

/* file descriptors */

/* Raw output device file descriptor and stream FILE structure */

int             fd_output;
FILE            *fd_stream;

int             net = 0;        /* file descriptor for the network connection */

#ifdef FROMNET
int             fromnet =  0;   /* file descriptor for logging everying from the network */
#endif /* FROMNET */

#ifdef TONET
int             tonet = 0;      /* file descriptor for logging everying to the network */
#endif /* TONET */

#ifdef DEBUG
FILE            *outf = NULL;   /* debug output file                    */
#endif /* DEBUG */

#ifdef LDEBUG
FILE            *log = NULL;    /* for logging various interesting things */
#endif /* LDEBUG */

/* Flag for indicating that the program is ending (in end_program) */

int             ending_program = 0;

/* Flag when we want synchronous output */

int             synch_op = SYNCH_NORMAL;

/*
 * Flag for saying what is the mode of the user's terminal
 *  0:  We have still got his original terminal setup
 *  1:  Now he is set up in (asynchronous) 3270 setup
 * -1:  Now he is temporarily back in (synchronous) dialogue mode
 */

int             term_mode = 0;

/*
 * Flag which will be set when the IBM sets telnet binary mode
 * 0: in "glass tty" mode
 * 1: in 3270 emulation mode
 */

int             binflag = 0;

/* states of various options */
int             will_tt, will_eor, do_eor, will_binary, do_binary, do_sga, will_tm;
int             sent_tt; /* IAC SB TERMINAL_TYPE IS ... IAC SE has been sent */

/*
 * There follow the various options that a user can have which can be
 * set in the call or changed in the on-line help options menu.
 * The first, however, is special: it identifies the last ANNOUNCE file
 * which the user has seen.
 * Note that the OPT_COUNT symbol must match the total number of options.
 * Note also that the string values are only needed for if we want to
 * read/write these values from/to an options file in OPTDIR.
 */

/* Value for the last ANNOUNCE file seen by the user */

int             announce_id = -1;
int             def_announce_id = -1;

/* Indicator for if 7171 emulation is required */

int             emul7171 = -1;
int             def_emul7171 = 1;

/* Indicator for if quiet mode wanted */

int             bells_mode = -1;
int             def_bells_mode = 1;

/* Indicator for if we should show MDT fields, possibly in reverse video */

int             show_MDT_field = -1;
int             def_show_MDT_field = 0;

/* Indicator for if we should keep insert mode across attention keys */

int             keep_insert = -1;
int             def_keep_insert = 0;

/*
 * To allow users to save screen dumps, including the possibility of
 * some (crontab) procedure to pick up the dumps and print them on
 * a specified printer (perhaps via lpr, perhaps via some other method)
 * we will want to create file names.
 * The file name will consist normally of three parts, separated by
 * a colon ( ':' ) character.
 * part 1: the user name (which might be the id of the calling user
 *         or the VM user name given in the program call.
 * part 2: the type qualifier, with "prt" being the default (to be changed
 *         to some default printer by any crontab shell script).
	   This part can be changed by the user in the options menu.
 * part 3: something, maybe a simple integer, to make the file unique
 *         in the directory in which it is being saved.
 */

/* Base filename for user's screen print files : normally the user name */

char            print_user[P_USIZE] = "user";

/* File type (may specify a printer!) for user's screen print files */

char            print_type[P_TSIZE] = "prt";
char            def_print_type[P_TSIZE] = "prt";

/*
 * Once we have the file name we will want to construct a complete
 * fully qualified file name, specifying the directory chosen for saving
 * the files.
 */

char            print_file[P_FSIZE] = "./user:3270:0000";

/* FILE structure pointer for the screen print file (NULL if non-existent) */

FILE            *print_fstr = NULL;

/*
 * We might also like to know the preferred email address of the user.
 * This can be useful for telling people about problems.
 * It is also used for sending print screen dumps in the case that the
 * user defines the (printer) file type as "email".
 * The same method is used as for the saved screen dumps, except that
 * the name of the saved file will have as part 1 the character '@' in
 * front of the user name.
 * Again, the actual sending of the file will be automatic only if there
 * is a (crontab) procedure to do so. This procedure will normally be
 * the same as for print files, since the scanning of the files in the
 * save directory will be practically identical.
 */

/* Full email address for user's screen print files */

char            email_addr[P_ESIZE] = "none";
char            def_email_addr[P_ESIZE] = "none";

#ifdef OPTDIR

/* File name for the user's chosen options */

char            opt_file[100] = "default_options";

/* FILE structure pointer for the option file (NULL if non-existent) */

FILE            *opt_fstr = NULL;

#endif /* OPTDIR */

/*
 * The addresses of the various option variables.
 * plus the associated format statements to read or write them.
 * Note that the first one MUST be the positive identification value
 * for the last announcement file that the user has seen.
 * Note also that there is one array for integer values, one for string
 * values and one (boolean) to indicate which is which!
 */

int             opt_smaxlen[OPT_COUNT] =   {
						0,
						0,
						0,
						0,
						0,
						P_TSIZE,
						P_ESIZE,
					   };

void            *opt_pointer[OPT_COUNT] =  {
						(void *) &announce_id,
						(void *) &emul7171,
						(void *) &bells_mode,
						(void *) &show_MDT_field,
						(void *) &keep_insert,
						(void *) print_type,
						(void *) email_addr
					   };

void            *opt_default[OPT_COUNT] =  {
						(void *) &def_announce_id,
						(void *) &def_emul7171,
						(void *) &def_bells_mode,
						(void *) &def_show_MDT_field,
						(void *) &def_keep_insert,
						(void *) def_print_type,
						(void *) def_email_addr
					   };

#ifdef OPTDIR

char            *opt_format[OPT_COUNT] =  {
						"announce_id = %d\n",
						"emul7171 = %d\n",
						"bells_mode = %d\n",
						"show_MDT_field = %d\n",
						"keep_insert = %d\n",
						"print_type = %39s\n",
						"email_addr = %39s\n"
					  };

#endif /* OPTDIR */

/*
 * We will want to be able to interpret the above options via single
 * characters. These characters, which may be specified in the call as
 * -<character>
 * will most often refer to a particular setting of an option pointed
 * to from the opt_pointer array.
 * However, some may not be applicable at call time (such as a request
 * to save the current set of options values)
 *
 * opt_cchar[]          lists all the characters.
 * opt_cindex[]         specifies the index into the opt_pointer array(s),
			but a negative value implies no such index.
 * opt_cival[]          gives the integer value for putting into the variable
			pointed to by the opt_pointer array, but only
			provided that opt_smaxlen is 0, i.e. it is an integer.
 * opt_cmess[]          is a string explaining the character and value.
 */

char            opt_cchar[OPT_CSIZE]    = {
					    '3', '7',
					    'n', 'q',
					    'f', 'j',
					    'i', 'r',
					    'c',
					    'e',
					    's'
					  };

int             opt_cindex[OPT_CSIZE]   = {
					      1, 1,
					      2, 2,
					      3, 3,
					      4, 4,
					      5,
					      6,
					      -1
					  };

int             opt_cival[OPT_CSIZE]    = {
					      0, 1,
					      1, 0,
					      1, 0,
					      1, 0,
					      0,
					      0,
					      -1
					  };

char            *opt_cmess[OPT_CSIZE]   = {
					    "normal IBM 3270 emulation"                         , "CERN (7171) 3270 emulation",
					    "noisy mode (bell ringing)"                         , "quiet mode (no bell ringing)",
					    "field definition mode (maybe reverse video)"       , "just the plain mode (no reverse video field indication)",
					    "insert mode retained over IBM attention key"       , "insert mode reset on IBM attention key",
					    "change screen dump/print qualifier",
					    "email address in full",
					    "save current options for user/host combination"
					  };

/* type of virtual 3270 terminal */

char            *TERMNAME;      /* IBM-3278-x */
int             rows;           /* 24, 32, or 43 */
int             linelen;        /* 80  or 132 */
int             screensize;

char            *progname;      /* to remember argv[0] (BS)  */
char            *remotename;    /* to remember required host name/number (JMG) */
char            *username=NULL; /* to remember (optional) IBM user name (JMG) */
char            *dialname=NULL; /* to remember (optional) dial host name */

#ifdef LOGFILE
int             name_field = -1;/* field for initial name to be logged */
#endif /* LOGFILE */

/*
 * Tables for input escape sequences.
 *
 * Escape_char[] and escape_ptr are parallel arrays simulating an
 * array of structs (but 25% smaller) containing a trie.  Each node in
 * the trie is represented by a contiguous segment of the arrays,
 * terminated by a slot with escape_char[i] = '\377'.
 * The entries of a node are sorted by the escape_char field.  Each node
 * corresponds to the set of all strings with a given initial prefix.
 * Consider slot i in the node corressponding to prefix 'w',
 * with escape_char[i]=c and escape_ptr[i]=j.  If j>0, j is the start
 * of the node corresponding to wc.  If j<0, -j is the action code associated
 * with the string wc.
 *
 * Escape_start[c] points to the start of the node corresponding to the
 * (one-character) prefix 'c'.  If no string starts with 'c', escape_start[c]
 * is null.
 *
 * Note that this representation precludes '\377' as a character in a
 * <string> (except as the first character).
 */

short           escape_start[256];
unsigned char   escape_char[MAXESCAPECHARS];
short           escape_ptr[MAXESCAPECHARS];
int             next_escape;

char            *find_def();

/* Various 3270 indicators */
int             clearsn=0;      /* Positive if clear screen requested by IBM */
				/* It is 1 for normal screen, 2 for alternate */
				/* It is negated when the screen has been cleared, */
				/* but before the new IBM screen (if any) drawn. */
bool            insert=FALSE;   /* TRUE if terminal in insert mode */
bool            unlock=FALSE;   /* TRUE if terminal input is allowed */

/* status indicators as to whether things are working or hung */

int             op_wait=0;      /* # characters of output waiting to go to the user */

#ifdef TTY
int             idle_count= -1; /* count how long user has done nothing */
#endif /* TTY */


/*
 * Data structure for representing fields.
 * The screen array simulates the contents of 3278 internal memory.
 * It is allocated by the alloc_buffer routine.
 * Each position contains in the least significant byte a field-definition
 * character or an ASCII ISO 8859-1 character.
 * The upper part can have flags in it: FIELDSTART is the main one, so that
 * (screen[p] & FIELDSTART) != 0 iff position p is the start of a field.
 * In this case the lower part is copied from the attribute byte following
 * the SF order.
 *
 * For normal characters there is a flag GE_CHAR to indicate that the
 * character came after a Graphics Escape byte. In such cases the translation
 * to and from ASCII must go according to a different table. This table
 * will convert an EBCDIC Graphic character into a 16-bit character in
 * which the least significant 7 bits is the ASCII code, whilst the bits
 * above select one of several possible character sets.
 *
 * In order to have compatibility with an 8-bit system we will consider
 * the 0x80 bit as both part of an 8-bit character and the selection of
 * the required 7-bit character set when in a 7-bit environment.
 * The 0x100 bit may, however, select a different character set from
 * the ASCII ISO 8859-1 one. Thus, the combination of bits 0x100 and 0x80
 * can imply any of the following:-
 *
 * 00   ASCII 7-bit     normally assumed in G0.
 * 01   ASCII 8-bit     normally assumed in G2 (ISO Latin-1 if on a VT300
 *                      or clone, DEC supplemental if a VT200 or clone).
 * 10   Graphics 7-bit  normally assumed in G1 as DEC Special Graphics
 *                      (even exists on the good old VT100!).
 * 11   Graphics 8-bit  normally assumed in G3 as DEC Technical Character
 *                      set, but only on a VT300 or clone.
 *
 * Unfortunately, however, we may get the IBM sending characters which
 * are undefined in the graphics set (to be displayed as '-') or ones we
 * cannot print. To cater for these cases without losing the one-to-one
 * mapping property we include a bit to specify extra sets in which
 * every 8-bit character comes out looking like the same character. Thus,
 * the translation of any such character is the same character byte but
 * in this mythical character set. The reverse mapping is therefore
 * unique and identical. We put this bit into the 0x200 position, making
 * four extra 8-bit mappings of bits 0x200, 0x100 and 0x80 as follows :-
 *
 * 10x  Undefined graphics character: print as '-'
 * 11x  Unprintable graphics character: print as some special character.
 *
 */

short           *screen;

#ifdef EXTENDED

/*
 * If we want to be able to handle extended attributes then we need a
 * parallel array to screen. This parallel array needs to handle
 * extended highlighting, extended color and symbol sets.
 * We will call this parallel array screen_ex.
 * We will assign the low order 4-bit nibble to extended highlighting,
 * the next 4-bit nibble to extended color and the top byte to the
 * symbol set. The exact specs will look as follows :-
 *
 * Extended highlighting
 *
 * Bit 0 : Blink
 * Bit 1 : Reverse Video
 * Bit 2 : Underscore
 * Bit 3 : Indicate that the nibble has been specifically set
 *
 * Extended color
 *
 * Bits 4-6 : requested color   0 - default
 *                              1 - blue
 *                              2 - red
 *                              3 - pink
 *                              4 - green
 *                              5 - turquoise
 *                              6 - yellow
 *                              7 - monochrome (black or white)
 * Bit 7 : Indicate that the nibble has been specifically set
 *
 * Symbol set
 *
 * Bits 8-15 : the symbol set as requested by the IBM
 *
 * In reality the symbol set will not yet be implemented. As far as I
 * can see it is only of use if we have structured fields or the APL
 * character set requirement: neither is possible just yet. Therefore,
 * the screen_ex array will be just 8-bit unsigned char.
 *
 * Note that the significance of bits 3 and 7 is to say that the value
 * is specifically set. If no value is set then we may choose how to
 * output the characters according to the field style.
 */

unsigned char   *screen_ex;

/* And we need to know the current value */

unsigned char   current_ex = 0;

/*
 * Now we need to know whether the IBM is permitting extended character
 * attributes to be changed, and if so whether the user has selected
 * a different attribute.
 * All that we allow for the moment are extended highlighting and
 * extended colour.
 */

bool            reply_highlight = FALSE;        /* True if user can change highlight */
unsigned char   user_highlight;                 /* highlight choice (lower 4 bits)   */
bool            reply_colour = FALSE;           /* True if user can change colour    */
unsigned char   user_colour;                    /* colour choice (lower 4 bits)      */

#endif /* EXTENDED */

/*
 * To know which regions of the screen array need updating.
 * s_point is an array parallel to screen.
 * s_pfirst is either -1 or an index into s_point.
 *   If an index then s_point[s_pfirst] is also an index into s_point
 *   indicating that the screen region from s_point to screen[s_point]
 *   inclusive is new (to be written to the user screen).
 * Since there may be more than one such region we continue with
 *   screen[screen[s.point]] as either -1 or a new pointer.
 */

short           *s_point, s_pfirst = -1;

/* String to change from one style to another */

char            *change_cp[MAXSTYLES][MAXSTYLES];

/* Length of corresponding change_cp string */

short           change_sl[MAXSTYLES][MAXSTYLES];

/* Indicator for if the string may reset character highlighting */

bool            change_rh[MAXSTYLES][MAXSTYLES];

/* Boolean to say if cursor can be moved when in a particular style */

bool            move_ok[MAXSTYLES] = { TRUE, TRUE, TRUE, TRUE, TRUE,
				       TRUE, TRUE, TRUE, TRUE, TRUE,
				       TRUE, TRUE, TRUE, TRUE, TRUE
				     };

/* Boolean to say whether blanks look "normal" in this style. */
/* If so then we can use the "clear to end of line" sequence. */

bool            ceol_ok[MAXSTYLES] = { TRUE, TRUE, TRUE, TRUE, TRUE,
				       TRUE, TRUE, TRUE, TRUE, TRUE,
				       TRUE, TRUE, TRUE, TRUE, TRUE
				     };

/* Boolean to say if the current screen has only NORMAL-style characters */

bool            normal_chars;

/* Boolean to say if the current screen has only NORMAL-style blanks */

bool            normal_blanks;


/* screen[firstfield] is the first element with the FIELDSTART bit set.
 * If no fields are currently defined, firstfield == -1.
 */
int             firstfield;

/* The contents of the screen are copied into the curscr data
 * structure maintained by curses.
 * curscr->char_y and curscr->ccset_y are arrays of pointers,
 * each pointing to an array of characters representing one line.
 * The char_y array is the actual character on the user screen.
 * The ccset_y array is both the style and the character set of the
 * character on the user screen.
 * This ccset is divided into two 4-bit "nibbles".
 * The more significant nibble is the "style" as one of the options
 * NORMAL, NORM_BLINK, ... , INVISIBLE
 * On simple terminals this is merely whether the character is highlighted
 * or not: more sophisticated terminals might have more properties such
 * as colour, blinking, dim etc.
 * The less significant nibble is the special indicator for
 * characters which came from the IBM with graphics escape and/or
 * are not part of the standard 8-bit ASCII set.
 */

unsigned char   **char_image;
unsigned char   **ccset_image;

/* The contents of char_image differ from screen in the following ways:
 *   char_image is an array of arrays, while screen is one-dimensional
 *   The following kinds of positions contain spaces in char_image
 *      field definition characters
 *      positions in invisible fields
 *      null characters
 * ccset_image is like char_image, except that it is for the "style and
 * character set" of the character, not the character itself.
 */

#ifdef EXTENDED

/*
 * In case we are handling extended attributes we also need to know what
 * is the extended attribute of the character.
 * This attribute is currently an unsigned character consisting of a nibble
 * for the colour and a nibble for the highlighting.
 */

unsigned char   **ccext_image;

#endif /* EXTENDED */

/* Extension to allow for both a normal and an alternate screen */

int             LINES;          /* Current number of lines */
int             COLS;           /* Current number of columns */

bool            altflip;        /* TRUE if there is an alternate screen  */
int             altscreen;      /* 0: normal screen, 1: alternate screen */

int             init_COLS;      /* lines on initial user display     */
int             init_LINES;     /* columns on initial user display   */

int             normal_linelen; /* lines in normal 3270 screen       */
int             normal_rows;    /* rows in normal 3270 screen        */
int             normal_LINES;   /* lines on normal user display      */
int             normal_COLS;    /* columns on normal user display    */
int             normal_slinenum;/* status line on normal display     */

int             altern_linelen; /* lines in alternate 3270 screen    */
int             altern_rows;    /* rows in alternate 3270 screen     */
int             altern_LINES;   /* lines on alternate user display   */
int             altern_COLS;    /* columns on alternate user display */
int             altern_slinenum;/* status line on normal display     */

short           ly, lx;         /* current cursor position */

/* The following variables keep track of the current cursor position */
int             cursorpos;      /* 0..screensize-1 */
int             cursorsave;     /* 0..screensize-1 */
int             bufferpos;      /* current buffer position (set by SBA order) 0..screensize-1 */
int             fieldstart;     /* first position of field currently containing cursor */
unsigned char   currentstyle;   /* style associated with the current field (fieldstart) */

#ifdef EXTENDED
unsigned char   currentextend;  /* extended characteristics associated with the current field (fieldstart) */
#endif /* EXTENDED */

/* the following variables specify new parts of screen for update_curscr */
int             startpos = -1;  /* start position (may be field definition) */
int             endpos;         /* end position (exclusive) */

/* keep count of calls to update_curscr (will be reset by put/writecursor */
int             updateflag;

bool            sline = FALSE;  /* TRUE if writing 3270 status line */
int             slinenum;       /* status line number if on normal screen */

int             scroll_line= -1;/* >0 : line which would cause scroll */
				/* <0 : any line COULD cause a scroll */

/*
 * Variables concerned with 8-bit mode, extended ASCII and so on.
 * Terminals set up for 7-bit mode can nonetheless have the extended
 * characters by the judicious use of Shift In/Out (SI/SO).
 * For 8-bit data input we may need to transform 8-bit control codes
 * into two 7-bit codes unless we have seen that 8-bit controls is OK.
 */

/* Flag for if terminal can handle 8-bit controls */

bool            eight_bc = FALSE;

/* Flag for if terminal can handle 8-bit data */

bool            eight_bd = FALSE;

/* Mask for OR of input character (0x80 after SO received, reset by SI) */

short           SO_imask = 0;

/* Used to change incoming 8-bit control character to ESC + 7-bit */

bool            ESC_iflag = FALSE;

/* Used to change outgoing ESC + 7-bit to 8-bit control character */

bool            ESC_oflag;

/*
 * Used before and after an extended character (>0x7f).
 * The two bits just before the 7-bit character will index into
 * this table.
 */

char            *SO_string[4] = {
				  "\0"    ,
				  "\033N" ,
				  "\016"  ,
				  "\033O"
				};
char            *SI_string[4] = {
				  "\0"    ,
				  "\0"    ,
				  "\017"  ,
				  "\0"
				};

/*
 * Chararacter to put out when the IBM has sent a graphics escape
 * character which is either illegal or one that we cannot manage
 * to produce on our ASCII screen.
 */

char            NBG_illegal = '-';
char            NBG_notgot  = '?';

/*
 * Various things concerned with the use of termcap sequences.
 * We keep a set of standard sequences, possibly including timing chars,
 * so as to avoid using low-level routines like tputs all the time.
 * We also invent a few new entries: if they are not in the actual
 * termcap entry it will not matter.
 */

struct          curwin  curscr_window;
unsigned char   *curscrch_y[MAXLINES];
unsigned char   *curscrccs_y[MAXLINES];

#ifdef EXTENDED
unsigned char   *curscrcex_y[MAXLINES];
#endif /* EXTENDED */

struct  curwin  *curscr;

