/*
 * Terminal initialization routines.
 *
 * 6/1/83 (Berkeley) @(#)cr_tty.c	1.14
 */

/*
 *     Copyright CERN, Geneva 1989 - Copyright and any other
 *     appropriate legal protection of these computer programs
 *     and associated documentation reserved in all countries
 *     of the world.
 */

# include       "globals.h"


short   AM, BS, CA, MI, MS, ES, HS;

char    *BL, *CV, *DS, *FS, *IS, *LE, *MB, *MD,
	*ME, *MH, *MR, *RS, *TS,
	*BC, *BT, *CD, *CE, *CL, *CM, *CR, *DO,
	*ND, *NL, *SE, *SO, *TE, *TI, *UC, *UE,
	*UP, *US;

char     PC;


/* extra pseudo-termcap capabilities added in by JMG */

short   VW;     /* TRUE if VT-100 type autowrap, i.e. it does not  */
		/* scroll immediately at the end of a line         */

#ifdef EXTENDED

/* Character strings for set/unset of extended highlighting */

int     extend_set[8] =   { 0, tcsMB, tcsMR, 0, tcsUS, 0, 0, 0 };
int     extend_unset[8] = { 0, tcsME, tcsME, 0, tcsUE, 0, 0, 0 };

/* The various colours for the IBM display */

/* First when in normal mode */

char    *C0;    /* sequence for 3279 colour 0 (default)            */
char    *C1;    /* sequence for 3279 colour 1 (red)                */
char    *C2;    /* sequence for 3279 colour 2 (green)              */
char    *C3;    /* sequence for 3279 colour 3 (yellow)             */
char    *C4;    /* sequence for 3279 colour 4 (blue)               */
char    *C5;    /* sequence for 3279 colour 5 (magenta/pink)       */
char    *C6;    /* sequence for 3279 colour 6 (cyanide/turquoise)  */
char    *C7;    /* sequence for 3279 colour 7 (neutral)            */

/* then when in reverse video mode */

char    *R0;    /* sequence for 3279 reverse 0 (default)           */
char    *R1;    /* sequence for 3279 reverse 1 (red)               */
char    *R2;    /* sequence for 3279 reverse 2 (green)             */
char    *R3;    /* sequence for 3279 reverse 3 (yellow)            */
char    *R4;    /* sequence for 3279 reverse 4 (blue)              */
char    *R5;    /* sequence for 3279 reverse 5 (magenta/pink)      */
char    *R6;    /* sequence for 3279 reverse 6 (cyanide/turquoise) */
char    *R7;    /* sequence for 3279 reverse 7 (neutral)           */

#endif /* EXTENDED */

char    *IB;    /* sequence to visually indicate insert mode       */
char    *IE;    /* sequence to visually indicate non-insert mode   */
char    *KE;    /* sequence to end keypad transmit mode            */
char    *KS;    /* sequence to start keypad transmit mode          */
char    *RT;    /* sequence to move cursor right n positions       */
char    *SN;    /* sequence to change to normal (80-col) screen    */
char    *SW;    /* sequence to change to wide (132-col) screen     */

/* end of extra capabilities added in by JMG */

char    **tcset[tcsMAX] = {  &CL , &IS , &CR , &UP , &DO , &LE , &ND , &BL
			   , &CE , &DS , &FS , &TS , &SN , &SW , &KE , &KS
			   , &TE , &TI , &IB , &IE , &MB , &MR , &ME , &US
			   , &UE

#ifdef EXTENDED
			   , &C0 , &C1 , &C2 , &C3 , &C4 , &C5 , &C6 , &C7
			   , &R0 , &R1 , &R2 , &R3 , &R4 , &R5 , &R6 , &R7
#endif /* EXTENDED */

			  };
char    *tcsptr[tcsMAX];
int     tcslen[tcsMAX] =  {    0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0
			   ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0
			   ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0
			   ,   0

#ifdef EXTENDED
			   ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0
			   ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0 ,   0
#endif /* EXTENDED */

			  };

	int     tcsind;
	int     tcschind;
	int     tcscount;

static short    *sflags[]       = {
			&AM, &BS, &CA, &MI, &MS, &ES, &HS,
			&VW
		};

static char     *xPC;
static char     **sstrs[]       = {
			&BC, &BT, &CD, &CE, &CL, &CM, &CR, &DO,
			&ND, &NL, &SE, &SO, &TE, &TI, &UC, &UE,
			&UP, &US,
			&BL, &CV, &DS, &FS, &IS, &LE, &MB, &MD,
			&ME, &MH, &MR, &RS, &TS,
			&xPC,

#ifdef EXTENDED
			&C0, &C1, &C2, &C3, &C4, &C5, &C6, &C7,
			&R0, &R1, &R2, &R3, &R4, &R5, &R6, &R7,
#endif /* EXTENDED */

			&IB, &IE, &KE, &KS, &RT, &SN, &SW
		};


static char     tspace[500],            /* Space for capability strings */
		*aoftspace;             /* pointer into tspace          */

#ifdef STANDARD_C

int     count_ch(char ch)

#else /* STANDARD_C */

int     count_ch(ch)

char    ch;

#endif /* STANDARD_C */

{
	tcscount++;
	return (ch);
}

#ifdef STANDARD_C

int     tcstrlen(char *tcstr)

#else /* STANDARD_C */

int     tcstrlen(tcstr)

char    *tcstr;

#endif /* STANDARD_C */

{
	tcscount = 0;
	tputs(tcstr, 1, count_ch);

#ifdef DEBUG

	(void)fprintf(outf, "tcstrlen    : string %d has length %d \"",
				tcsind, tcscount);
	if (tcscount)
	{
		char    *string;

		for (string = tcstr ; *string ; string++)
			(void)fprintf(outf, "%s", print_ascii((unsigned short)*string));
	}
	(void)fprintf(outf, "\"\n");

#endif /* DEBUG */

	return (tcscount);
}

#ifdef STANDARD_C

int     add_ch(char addch)

#else /* STANDARD_C */

int     add_ch(addch)

char    addch;

#endif /* STANDARD_C */

{
	tcsptr[tcsind][tcschind++] = (addch ? addch : 0x80);
	return ((int)addch);
}

/*
 *	This routine gets all the terminal flags from the termcap database
 */

#ifdef STANDARD_C

void    zap(void)

#else /* STANDARD_C */

void    zap()

#endif /* STANDARD_C */

{
	register short  **fp;
	register char   *namp, ***sp;

	aoftspace = tspace;

	/*
	 * get boolean flags
	 */
/*      namp = "ambseohzinmimsncosulxn\0\0"; */
	namp = "ambscamimseshsvw\0\0";

#ifdef DEBUG
	(void)fprintf(outf, "ZAP         : namp = \"%s\"\n", namp);
#endif /* DEBUG */

	fp = sflags;
	do
	{
		*(*fp++) = tgetflag(namp);

#ifdef DEBUG
		(void)fprintf(outf, "ZAP         : %.2s = %d\n", namp, *(*(fp - 1)));
#endif /* DEBUG */

		namp += 2;
	} while (*namp);

	/*
	 * get string values
	 */

#ifdef EXTENDED

	namp = "bcbtcdceclcmcrdondnlsesoteti\
ucueupusblcvdsfsislembmdmemhmrrstspcc0c1c2c3c4c5c6c7r0r1r2r3r4r5r6r7ibiekeksrtsnsw";

#else /* EXTENDED */

	namp = "bcbtcdceclcmcrdondnlsesoteti\
ucueupusblcvdsfsislembmdmemhmrrstspcibiekeksrtsnsw";

#endif /* EXTENDED */


#ifdef DEBUG
	(void)fprintf(outf, "ZAP         : namp = \"%s\"\n", namp);
#endif /* DEBUG */

	sp = sstrs;
	do
	{
		*(*sp) = tgetstr(namp, &aoftspace);

#ifdef DEBUG
	{
		char    *string;

		(void)fprintf(outf, "ZAP         : %.2s = ", namp);
		if (string = *(*(sp)))
		{
			(void)fprintf(outf, "\"");
			for ( ; *string ; string++)
				(void)fprintf(outf, "%s", print_ascii((unsigned short)*string));
			(void)fprintf(outf, "\"\n");
		}
		else
			(void)fprintf(outf, "NULL\n");
	}
#endif /* DEBUG */

		/*
		 * On some systems, especially ones which emulate the old
		 * termcap routines but really run under terminfo we may
		 * get back the character string "@", meaning that this
		 * capability no longer exists. I have seen this on SGI
		 * and RS6000.
		 * On the optimistic assumption that the sequence can never
		 * really mean anything (and perhaps until I have a version
		 * for native terminfo) I will treat such strings as NULL.
		 */

		if ((*(*sp)) && !strcmp(*(*sp), "@"))
		{
			*(*(sp)) = NULL;

#ifdef DEBUG
	{
		(void)fprintf(outf, "ZAP         : %.2s changed to NULL\n", namp);
	}
#endif /* DEBUG */

		}

		sp++;
		namp += 2;
	} while (*namp);

	if (tgetnum("sg") > 0)
		SO = NULL;

	if (tgetnum("ug") > 0)
		US = NULL;

	if (!SO && US)
	{
		SO = US;
		SE = UE;
	}
	aoftspace = tspace;
	PC = xPC ? xPC[0] : 0;

}

/*
 * For certain standard sequences it is worthwhile getting the
 * interpreted version, including delay characters, so as to avoid
 * the overhead of going via tputs or tgoto every time.
 */

#ifdef STANDARD_C

void    set_tcstr(void)

#else /* STANDARD_C */

void    set_tcstr()

#endif /* STANDARD_C */

{
	char            *tc;
	char            *tcbufad;
	int             tcbufsiz = 0;

	for (tcsind = 0 ; tcsind < tcsMAX ; tcsind++)
	{
		if ((tc = *(tcset[tcsind])) && strlen(tc))
		{
			tcslen[tcsind] = tcstrlen(tc);
			tcbufsiz += (tcslen[tcsind] + 1);
		}
		else
			tcslen[tcsind] = 0;
	}

	tcsptr[0] = tcbufad = (char *) alloc_buffer(tcbufsiz, '\0');

	for (tcsind = 0 ; tcsind < tcsMAX ; tcsind++)
	{
		if (tcslen[tcsind])
		{
			tcsptr[tcsind] = tcbufad;
			tcschind = 0;
			tputs(*(tcset[tcsind]), 1, add_ch);
			tcbufad += (tcslen[tcsind] + 1);
		}
		else
			tcsptr[tcsind] = "";

#ifdef DEBUG
	{
		char    *string;

		(void)fprintf(outf, "set_tcstr   : tcs[%d] %d chars <",
				tcsind, tcslen[tcsind]);
		for (string = tcsptr[tcsind] ; *string ; string++)
			(void)fprintf(outf, "%s", print_ascii((unsigned short)*string));
		(void)fprintf(outf, ">\n");
	}
#endif /* DEBUG */

	}
}
