/*
 *     Copyright CERN, Geneva 1989 - Copyright and any other
 *     appropriate legal protection of these computer programs
 *     and associated documentation reserved in all countries
 *     of the world.
 */

/*
 *  Copyright (c) 1984 Marvin Solomon; all rights reserved
 */

/*
 * Various translation tables and constants for describing 327x IBM terminals
 *
 *
 */

/*
 * Format control orders.
 * SUBSTITUTE, DUPLICATE and FIELD_MARK convert to the identical ASCII
 * code, which then has a second translation to go onto the screen.
 * This translation tries to be as like a real IBM display as possible,
 * on which they should appear as solid circle, overscore asterisk and
 * overscore semicolon respectively: see the atop table in 3270.c.
 * The other control orders should come out as blanks.
 */


#define SUBSTITUTE                      0x3f
#define DUPLICATE                       0x1c
#define FIELD_MARK                      0x1e
#define FORM_FEED                       0x0c
#define CARRIAGE_RETURN                 0x0d
#define NEW_LINE                        0x15
#define END_MESSAGE                     0x19
#define END_OUTPUT                      0xff


/* translation table to convert from a six bit value to a printable character
 * (used in 12-bit cursor addresses)
 */
extern  unsigned char   SIXBITtoEBCDIC[];

#define byte1(n)        SIXBITtoEBCDIC[((n)>>6) & 077]
#define byte2(n)        SIXBITtoEBCDIC[(n) & 077]

/* values for the AID byte */
#define ENTERkey                        0x7d
#define NOattentionKEY                  0x60

/* 3270 commands */
#define WRITEcommand                     1
#define READBUFFERcommand                2
#define READMODIFIEDcommand              6
#define READMOD_ALLcommand              14
#define ERASEWRITEcommand                5
#define ERASEWRITEALTERNATEcommand      13
#define ERASEALLUNPROTECTEDcommand      15
#define WSFcommand                      17

/* bits in the WCC byte */
#define WCCreset                        0x40    /* reset terminal state */
#define WCCbell                         0x04    /* ring bell at end of operation */
#define WCCprinter                      0x08    /* start the printer operation */
#define WCCunlock                       0x02    /* unlock keyboard */
#define WCCresetMDT                     0x01    /* reset all modified-data tags */

/* 3270 orders */
#define SFchar                          0x1D    /* Start Field */
#define SFEchar                         0x29    /* Start Field Extended */
#define SBAchar                         0x11    /* Set Buffer Address */
#define SAchar                          0x28    /* Set Attribute */
#define MFchar                          0x2C    /* Modify Field */
#define ICchar                          0x13    /* Insert Cursor */
#define PTchar                          0x05    /* Program Tab */
#define RAchar                          0x3C    /* Repeat to Address */
#define EUAchar                         0x12    /* Erase Unprotected to Address */
#define GEchar                          0x08    /* Graphics Escape. */

#ifdef EXTENDED

extern  unsigned char   wsf_q_response[];

/*
 * Need to know the number of rows and columns for the alternate screen.
 * (the normal screen is assumed always to be 24*80)
 * Remember that the code allows for a Model 2 to have a 24*132 alternate
 * screen if the symbol DENSE is defined, but this 24*132 must NOT be
 * indicated in the wsf responses.
 */

extern  unsigned char   wsf_a_rows;
extern  unsigned char   wsf_a_cols;

/*
 * Here is a nice place to put various defines for structured field code.
 * Note, however, that this implementation might try to avoid having
 * the IBM send them or might not (yet) be able to handle them if they
 * do come. For instance, we try to restrict the IBM to one partition,
 * i.e. the whole screen!
 *
 * Start with the various values that can come as the first byte (after
 * the length byte pair) from the IBM.
 *
 */

#define WSF_RESET_P     0x00    /* Reset Partition                      */
#define WSF_READ_P      0x01    /* Read Partition                       */
#define WSF_ERESET      0x03    /* Erase/Reset                          */
#define WSF_LPS         0x06    /* Load Programmed Symbols              */
#define WSF_SET_R       0x09    /* Set Reply Mode                       */
#define WSF_SET_W       0x0b    /* Set Window Origin                    */
#define WSF_CREATE      0x0c    /* Create Partition                     */
#define WSF_DESTROY     0x0d    /* Destroy Partition                    */
#define WSF_ACTIVATE    0x0e    /* Activate Partition                   */
#define WSF_0F          0x0f    /* Various: see next byte               */
#define WSF_SAVE_REST   0x10    /* Save/Restore (if followed by 0x34)   */
#define WSF_3270DS      0x40    /* Outbound 3270 Data Stream            */
#define WSF_SCSDATA     0x41    /* SCS Data                             */
#define WSF_SFG         0x4a    /* Select Format Group                  */
#define WSF_PAF         0x4b    /* Present Absolute Format              */
#define WSF_PRF         0x4c    /* Present Relative Format              */

/*
 * Now options for a subsequent byte in some specific cases.
 * Start with options for Read Partition.
 */

#define WSF_R_QUERY     0x02    /* Query                                */
#define WSF_R_QLIST     0x03    /* Query List                           */
#define WSF_R_M_ALL     0x6e    /* Read Modified All                    */
#define WSF_R_BUFFER    0xf2    /* Read Buffer                          */
#define WSF_R_MOD       0xf6    /* Read Modified                        */

/* Items in Set Reply Mode */

#define WSF_SR_FIELD    0x00    /* Field Mode                           */
#define WSF_SR_EXTEND   0x01    /* Extended-field Mode                  */
#define WSF_SR_CHAR     0x02    /* Character Mode                       */

/* Various, following WSF_0F */

#define WSF_V_SMSR      0x01    /* Set MSR Control                      */
#define WSF_V_MP        0x0a    /* Modify Partition                     */
#define WSF_V_TEXT      0x71    /* Outbound Text Header                 */
#define WSF_V_1TEXT     0xc1    /* Outbound Type 1 Text Header          */
#define WSF_V_DO        0x02    /* Destination/origin                   */
#define WSF_V_OEM       0x1f    /* OEM Data                             */

/* Following WSF_SAVE_REST */

#define WSF_SR_2        0x34    /* Second byte for Save/Restore         */

#endif /* EXTENDED */

#define TRANSP_WRITE                    0x70    /* Transparent write (e.g. Kermit) */

/* If handling 7171 extended functions then define the intro bytes and functions */

#define EXT7171_1                       0x2b    /* 7171 extended function : first byte of two */
#define EXT7171_2                       0x5b    /* 7171 extended function : second byte of two */

#define E_OFF_NULL                      0x95    /* Turn off 7171 null processing */
#define E_ON_NULL                       0xd5    /* Turn on 7171 null processing */

#define E_DROP_INS                      0x89    /* Drop insert mode on attention key */
#define E_KEEP_INS                      0xc9    /* Keep insert mode on attention key */

#define E_SET_MARK                      0xb0    /* Set mark at current buffer address */
#define E_CLR_MARK                      0xb4    /* Clear mark */


/* bits in a start-field byte */
#define SFspecialBITS                   0x40    /* Blinking field (non-standard!!!) */
#define SFmodentryBITS                  0x02    /* Copy of entry SFmodifiedBITS */
#define SFprotectedBITS                 0x20    /* The operator can not change this field */
#define SFnumericBITS                   0x10    /* Numeric field (NB: (prot&num)==autoskip) */
#define SFvisibleBITS                   0x0C    /* Visibility attributes; one of:  */
#define SFinvisibleBITS                 0x0C    /*    do not show the field */
#define SFstandoutBITS                  0x08    /*    show in high intensity */
#define SFnormalBITS                    0x00    /*    show normally */
#define SFmodifiedBITS                  0x01    /* The user has changed this field. */

#define ATTRMASK                        (0x3f & ~SFmodentryBITS)

/*
 * Turn the two bytes p[0] and p[1] into an address.
 * Support 12-bit and 14-bit coding.
 */

#define decodepos(p) ( (*(p) & 0xc0) ? ((*(p) & 0x3f) << 6) | (*((p)+1) & 0x3f) : ((*(p) & 0x3f) << 8) | (*((p)+1) & 0xff))

/* convert to row/column (mostly for debugging) */
#define ROWCOL(n) ((n) / COLS + 1) , ((n) % COLS + 1)

/*
 * keyboard actions
 * For each action there is a name, an action routine, an argument
 * for this routine and an indicator to say if the action can be
 * taken immediately or must wait until the IBM has unlocked input.
 * An argument of 999 is always used for unimplemented actions.
 * The indicator values are:-
 *      -1      For immediate action (nothing to go to IBM!)
 *       0      Wait until IBM unlocks (then action to IBM)
 *       1      Wait until IBM unlocks (but nothing to go to IBM)
 */

struct  action_entry {
			char    *name;
			void    (*action)();
			short   arg;
			short   immediate;
			char    *act_hmess;
		     };

extern  struct  action_entry    actions[];
