.\" Copyright (c) 1985, 1991 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)inetd.8	6.7 (Berkeley) 3/16/91
.\"
.ds vT (A/UX Local)
.Dd March 16, 1991
.Dt INETD 1M
.Os (A/UX)
.Sh NAME
.Nm inetd
.Nd internet
.Dq super-server
.Sh SYNOPSIS
.Nm inetd
.Op Fl d
.Op Fl l
.Op Fl a
.Op Fl p
.Op Ar configuration file
.Sh DESCRIPTION
.Nm Inetd
should be run at boot time by an entry in
.Pa /etc/inittab
(see
.Xr inittab 4 ) .
It then listens for connections on certain
internet sockets.  When a connection is found on one
of its sockets, it decides what service the socket
corresponds to, and invokes a program to service the request.
After the program is
finished, it continues to listen on the socket (except in some cases which
will be described below).  Essentially,
.Nm inetd
allows running one daemon to invoke several others,
reducing load on the system.
.Pp
The options available for
.Nm inetd:
.Bl -tag -width Ds
.It Fl d
Turns on debugging.
.It Fl l
Turns on logging. When enabled,
.Nm inetd
will log when a daemon is spawned and what host
requested the daemon. This logging is done via
.Nm syslogd
using the
.Nm LOG_LOCAL2
facility at the
.Nm LOG_INFO
level.
.It Fl a
Enables host-access control. When enabled,
.Nm inetd
will check the access control files,
.Nm /etc/hosts.allow
and
.Nm /etc/hosts.deny ,
to see if the requesting host is authorized to exec the requested daemon.
.Nm inetd
will verify that the requesting host is, indeed, who they claim to be.
If there is a hostname-to-address mismatch,
.Nm inetd
will still spawn the daemon, but will inform you, via
.Nm syslog ,
about the mismatch. If this isn't secure enough for you, see
the next option.
.It Fl p
Similar to the
.Nm -a
option but
.Nm inetd
will refuse to exec the requested daemon if there is a name-address mismatch.
If both
.Nm -p
and
.Nm -a
are used,
.Nm -p
has higher authority and will be honored.
.El
.Pp
Upon execution,
.Nm inetd
reads its configuration information from a configuration
file which, by default, is
.Pa /etc/servers .
If
.Pa /etc/servers
doesn't exist, then
.Nm inetd
will check for
.Pa /etc/inetd.conf .
There must be an entry for each field of the configuration
file, with entries for each field separated by a tab or
a space.  Comments are denoted by a ``#'' at the beginning
of a line.  There must be an entry for each field.  The
fields of the configuration file are as follows:
.Pp
.Bd -unfilled -offset indent -compact
service name
socket type
protocol
wait/nowait
user
server program
server program arguments
.Ed
.Pp
The
.Em service-name
entry is the name of a valid service in
the file
.Pa /etc/services .
For
.Dq internal
services (discussed below), the service
name
.Em must
be the official name of the service (that is, the first entry in
.Pa /etc/services ) .
.Pp
The
.Em socket-type
should be one of
.Dq stream ,
.Dq dgram ,
.Dq raw ,
.Dq rdm ,
or
.Dq seqpacket ,
depending on whether the socket is a stream, datagram, raw,
reliably delivered message, or sequenced packet socket.
.Pp
The
.Em protocol
must be a valid protocol as given in
.Pa /etc/protocols .
Examples might be
.Dq tcp
or
.Dq udp .
.Pp
The
.Em wait/nowait
entry is applicable to datagram sockets only (other sockets should
have a
.Dq nowait
entry in this space).  If a datagram server connects
to its peer, freeing the socket so
.Nm inetd
can received further messages on the socket, it is said to be
a
.Dq multi-threaded
server, and should use the
.Dq nowait
entry.  For datagram servers which process all incoming datagrams
on a socket and eventually time out, the server is said to be
.Dq single-threaded
and should use a
.Dq wait
entry.
.Xr Comsat 1M
.Pq Xr biff 1
and
.Xr talkd 1M
are both examples of the latter type of
datagram server.
.Xr Tftpd 1M
is an exception; it is a datagram server that establishes pseudo-connections.
It must be listed as
.Dq wait
in order to avoid a race;
the server reads the first packet, creates a new socket,
and then forks and exits to allow
.Nm inetd
to check for new service requests to spawn new servers.
.Pp
The
.Em user
entry should contain the user name of the user as whom the server
should run.  This allows for servers to be given less permission
than root.
.Pp
The
.Em server-program
entry should contain the pathname of the program which is to be
executed by
.Nm inetd
when a request is found on its socket.  If
.Nm inetd
provides this service internally, this entry should
be
.Dq internal .
.Pp
The
.Em server program arguments
should be just as arguments
normally are, starting with argv[0], which is the name of
the program.  If the service is provided internally, the
word
.Dq internal
should take the place of this entry. Under
.Nm A/UX ,
this field must be
.Em <address>
for
.Em in.remshd
and
.Em in.rlogind
to work correctly. It appears that adding
.Em <address>
to
.Em in.ftpd
and
.Em in.telnetd
causes no harm (what this actually does is call the
.Em server-program
with the client's address.port# as an argument.
.Em in.remshd
and
.Em in.rlogind
require this, but
.Em in.ftpd
and
.Em in.telnetd
simply ignore it. Having it though does result in the address.part#
being printed in a
.Nm ps
listing, as the original
.Nm inetd
did.)
.Pp
.Nm Inetd
provides several
.Dq trivial
services internally by use of
routines within itself.  These services are
.Dq echo ,
.Dq discard ,
.Dq chargen
(character generator),
.Dq daytime
(human readable time), and
.Dq time
(machine readable time,
in the form of the number of seconds since midnight, January
1, 1900).  All of these services are tcp based.  For
details of these services, consult the appropriate
.Tn RFC
from the Network Information Center.
.Pp
.Nm Inetd
rereads its configuration file when it receives a hangup signal,
.Dv SIGHUP .
Services may be added, deleted or modified when the configuration file
is reread.
.Sh SECURITY
.Nm
inetd
supports the host-access control capability of Wietse Venemas'
.Nm tcpd
``tcp_wrapper'' daemon (located on ftp.win.tue.nl). This is due to the fact that
.Nm
inetd
actually uses the same routines.
The host-access control files, described in
.Nm hosts_access(5) ,
specify which hosts can spawn which daemons. If these files do not exist,
all hosts are allowed to spawn all daemons (i.e. no access control).
.Sh SEE ALSO
.Xr comsat 1M ,
.Xr fingerd 1M ,
.Xr ftpd 1M ,
.Xr rexecd 1M ,
.Xr rlogind 1M ,
.Xr rshd 1M ,
.Xr telnetd 1M ,
.Xr tftpd 1M ,
.Xr hosts_access 5
.Sh BUGS
Most
.Nm rpc
daemon requests appear to originate from the local host. This is due
to the way
.Nm portmapper
operates and thus not really a bug in
.Nm inetd .
Getting Wietse Venemas'
.NM portmapper
replacement (also on ftp.win.tue.nl) will help out a great deal.
.Sh FILES
.Bd -unfilled -offset indent -compact
/etc/hosts.allow
/etc/hosts.deny
.Sh HISTORY
The
.Nm
command appeared in
.Bx 4.3 .
