#!/bin/sh

if test $# != 1
then
echo You must specify a slice number for the emergency filesystem!
exit 1
fi

echo Using slice $1 for the emergency filesystem

#
# Mount the emergency filesystem
#

echo Mounting emergency filesystem

if mount /dev/dsk/c0d0s$1 /mnt >/dev/null 2>&1
then
:
else
echo Unable to mount /dev/dsk/c0d0s$1!
exit 1
fi

#
# Create the required directories and subdirectories
#

echo Creating directories

mkdir /mnt/dev
mkdir /mnt/dev/dsk
mkdir /mnt/dev/rdsk
mkdir /mnt/dev/rmt
mkdir /mnt/shlib
mkdir /mnt/bin
mkdir /mnt/etc
mkdir /mnt/etc/fs
mkdir /mnt/etc/fs/ufs
mkdir /mnt/etc/fs/svfs
mkdir /mnt/usr
mkdir /mnt/usr/news
mkdir /mnt/usr/bin
mkdir /mnt/usr/lib
mkdir /mnt/usr/lib/terminfo
mkdir /mnt/usr/lib/terminfo/m
mkdir /mnt/tmp

#
# Copy all required files
#

echo Copying files

cp /shlib/libc1_s /mnt/shlib
cp /shlib/libc_s /mnt/shlib

cp /bin/sh /mnt/bin
cp /bin/rm /mnt/bin
cp /bin/cp /mnt/bin
cp /bin/mv /mnt/bin
cp /bin/mkdir /mnt/bin
cp /bin/ln /mnt/bin
cp /bin/su /mnt/bin
cp /bin/ed /mnt/bin
cp /bin/tset /mnt/bin
cp /bin/df /mnt/bin
cp /bin/stty /mnt/bin
cp /bin/sync /mnt/bin
cp /bin/ls /mnt/bin
cp /bin/cat /mnt/bin
cp /bin/rmdir /mnt/bin
cp /bin/expr /mnt/bin
cp /bin/hostname /mnt/bin
cp /bin/date /mnt/bin
cp /bin/news /mnt/bin
cp /bin/mt /mnt/bin

cp /etc/init /mnt/etc
cp /etc/restore /mnt/etc
cp /etc/fpsp /mnt/etc
cp /etc/utmp /mnt/etc
cp /etc/ioctl.syscon /mnt/etc
cp /etc/mount /mnt/etc
cp /etc/umount /mnt/etc
cp /etc/termcap /mnt/etc
cp /etc/fs/ufs/restore /mnt/etc/fs/ufs
cp /etc/fs/ufs/fstyp /mnt/etc/fs/ufs
cp /etc/fs/svfs/restore /mnt/etc/fs/svfs
cp /etc/fs/svfs/fstyp /mnt/etc/fs/svfs
cp /etc/fsck /mnt/etc
cp /etc/gettydefs /mnt/etc
cp /etc/group /mnt/etc
cp /etc/ttytype /mnt/etc
cp /etc/fstyp /mnt/etc
cp /etc/fstypes /mnt/etc
cp /etc/reboot /mnt/etc

cp /usr/lib/terminfo/m/mac2 /mnt/usr/lib/terminfo/m
cp /usr/lib/terminfo/m/mac2cs /mnt/usr/lib/terminfo/m

cp /usr/bin/id /mnt/usr/bin

cp /unix /mnt
cp /.profile /mnt

#
# Create the required device nodes
#

echo Creating device nodes

mknod /mnt/dev/console c 7 0
mknod /mnt/dev/dsk/c0d0s0 b 24 0
mknod /mnt/dev/kmem c 2 1
mknod /mnt/dev/null c 2 2
mknod /mnt/dev/rdsk/c0d0s0 c 24 0
mknod /mnt/dev/rmt/tc6 c 4 6

#
# Create synonyms
#

echo Setting up links

ln /mnt/dev/console /mnt/dev/syscon
ln /mnt/dev/console /mnt/dev/systty

#
# Set correct ownership and permissions
#

echo Fixing device ownership and permissions

chmod 666 /mnt/dev/console
chmod 600 /mnt/dev/dsk/c0d0s0
chmod 644 /mnt/dev/kmem
chown bin /mnt/dev/kmem
chgrp sys /mnt/dev/kmem
chmod 666 /mnt/dev/null
chmod 600 /mnt/dev/rdsk/c0d0s0
chmod 666 /mnt/dev/rmt/tc6
chmod 777 /mnt/tmp

#
# Create minimal single-user files
#

echo Creating minimal single-user files

echo 'is:S:initdefault:' > /mnt/etc/inittab

echo 'root::0:0::/:/bin/ksh' > /mnt/etc/passwd
echo 'daemon:*:1:1::/:' >> /mnt/etc/passwd
echo 'bin:*:2:2::/bin:' >> /mnt/etc/passwd
echo 'sys:*:3:3::/bin:' >> /mnt/etc/passwd
echo 'adm:*:4:4::/usr/adm:' >> /mnt/etc/passwd
echo 'uucp:*:5:5:UUCP Administrator:/usr/lib/uucp:' >> /mnt/etc/passwd
echo 'nuucp:*:10:10:UUCP User:/usr/spool/uucppublic:/usr/lib/uucp/uucico' >> /mnt/etc/passwd
echo 'lp:*:7:7:lp:/usr/spool/lp:' >> /mnt/etc/passwd
echo 'nobody:*:60001:60001:NFS generic user:/tmp:/bin/noshell' >> /mnt/etc/passwd
echo 'start:*:100:100:Initial login:/users/start:/bin/csh' >> /mnt/etc/passwd

echo > /mnt/etc/mtab

#
# Patch the kernel to run from the emergency filesystem
#

echo Patching emergency kernel

echo ROOTDEV=0x180$1\\nPIPEDEV=0x180$1 | kconfig -n /mnt/unix

#
# Dismount the emergency filesystem
#

if umount /dev/dsk/c0d0s$1 >/dev/null 2>&1
then
:
else
echo Unable to unmount /dev/dsk/c0d0s$1!
exit 1
fi

echo Emergency filesystem created

