#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)daemon.c	5.3 (Berkeley) 12/28/90";
#endif				/* LIBC_SCCS and not lint */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>

int daemon(nochdir, noclose)
int nochdir, noclose;
{
    int cpid;

    if ((cpid = fork()) == -1)
	return (-1);
    if (cpid)
	exit(0);
    if (!nochdir)
	(void) chdir("/");
    if (!noclose) {
	int fd;
	int mopen = getdtablesize();
	for (fd = 0; fd < mopen; fd++)
	    (void) close(fd);

	(void) open("/dev/null", O_RDWR, 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
    }

    if (setsid() == -1) {
	setpgrp(0, getpid());
	cpid = open("/dev/tty", O_RDWR);
	if (cpid != -1) {
	    ioctl(cpid, TIOCNOTTY, 0);
	    (void) close(cpid);
	}
    }

    return(0);
}
