/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef lint
static char sccsid[] = "@(#)logwtmp.c	based on 5.5 (Berkeley) 4/2/89";
#endif /* not lint */

#include <stdio.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <utmp.h>


static int fd = -1;

/*
 * Modified version of logwtmp that holds wtmp file open
 * after first call, for use with ftp (which may chroot
 * after login, but before logout).
 */
logwtmp(line, name, host, adduser)
	char *line, *name, *host;
	int adduser;
{
	static struct utmp ut;
	struct stat buf;
	time_t time();
	char *strncpy();

	if (fd < 0 && (fd = open(WTMP_FILE, O_WRONLY|O_APPEND, 0)) < 0)
		return;
	if (fstat(fd, &buf) == 0) {
		(void)time(&ut.ut_time);
		ut.ut_pid = (short) getpid();
		if (adduser) {
			(void)strncpy(ut.ut_user, name, sizeof(ut.ut_user));
			(void)strncpy(ut.ut_host, host, sizeof(ut.ut_host));
			(void)strncpy(ut.ut_line, line, sizeof(ut.ut_line));
			(void)strncpy(ut.ut_id, "net9", sizeof(ut.ut_id));
			ut.ut_exit.e_termination = 0;
			ut.ut_exit.e_exit = 0;
			ut.ut_type = USER_PROCESS;
		}
		else {
			ut.ut_type = DEAD_PROCESS;
		}
		if (write(fd, (char *)&ut, sizeof(struct utmp)) !=
		    sizeof(struct utmp))
			(void)ftruncate(fd, buf.st_size);
	}
}
