.\" Copyright (c) 1985 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)getusershell.3	6.3 (Berkeley) 11/30/88
.\"
.TH GETUSERSHELL 3  "November 30, 1988"
.UC 6
.SH NAME
getusershell, setusershell, endusershell \- get legal user shells
.SH SYNOPSIS
.nf
.B char *getusershell()
.PP
.B setusershell()
.PP
.B endusershell()
.fi
.SH DESCRIPTION
.I Getusershell
returns a pointer to a legal user shell as defined by the
system manager in the file 
.IR /etc/shells .
If 
.I /etc/shells
is unreadable or does not exist,
.I getusershell
behaves as if
.I /bin/sh
,
.I /bin/ksh
and
.I /bin/csh
were listed in the file.
.PP
.I Getusershell
reads the next
line (opening the file if necessary);
.I setusershell
rewinds the file;
.I endusershell
closes it.
.SH FILES
/etc/shells
.SH "SEE ALSO"
shells(5)
.SH DIAGNOSTICS
The routine
.I getusershell
returns a null pointer (0) on EOF.
.SH BUGS
All information
is contained in a static area
so it must be copied if it is
to be saved.
