.\" Copyright (c) 1990, 1991 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" This code is derived from software contributed to Berkeley by
.\" Van Jacobson.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)traceroute.8	5.4 (Berkeley) 3/16/91
.\"
.Dd March 16, 1991
.Dt TRACEROUTE 8
.Os BSD 4.3
.Sh NAME
.Nm traceroute
.Nd print the route packets take to network host
.Sh SYNOPSIS
.Nm traceroute
.Op Fl m Ar max_ttl
.Op Fl n
.Op Fl p Ar port
.Op Fl q Ar nqueries
.Op Fl r
.Bk -words
.Op Fl s Ar src_addr
.Ek
.Op Fl t Ar tos
.Op Fl w Ar waittime
.Ar host
.Op Ar packetsize
.Sh DESCRIPTION
The Internet is a large and complex aggregation of
network hardware, connected together by gateways.
Tracking the route one's packets follow (or finding the miscreant
gateway that's discarding your packets) can be difficult.
.Nm Traceroute
utilizes the IP protocol `time to live' field and attempts to elicit an
.Tn ICMP
.Dv TIME_EXCEEDED
response from each gateway along the path to some
host.
.Pp
The only mandatory parameter is the destination host name or IP number.
The default probe datagram length is 38 bytes, but this may be increased
by specifying a packet size (in bytes) after the destination host
name.
.Pp
Other options are:
.Bl -tag -width Ds
.It Fl m Ar max_ttl
Set the max time-to-live (max number of hops) used in outgoing probe
packets.  The default is 30 hops (the same default used for
.Tn TCP
connections).
.It Fl n
Print hop addresses numerically rather than symbolically and numerically
(saves a nameserver address-to-name lookup for each gateway found on the
path).
.It Fl p Ar port
Set the base
.Tn UDP
.Ar port
number used in probes (default is 33434).
.Nm Traceroute
hopes that nothing is listening on
.Tn UDP
ports
.Em base
to
.Em base+nhops-1
at the destination host (so an
.Tn ICMP
.Dv PORT_UNREACHABLE
message will
be returned to terminate the route tracing).  If something is
listening on a port in the default range, this option can be used
to pick an unused port range.
.It Fl q Ar nqueries
Set the number of probes per ``ttl'' to
.Ar nqueries
(default is three probes).
.It Fl r
Bypass the normal routing tables and send directly to a host on an attached
network.
If the host is not on a directly-attached network,
an error is returned.
This option can be used to ping a local host through an interface
that has no route through it (e.g., after the interface was dropped by
.Xr routed 8 ) .
.It Fl s Ar src_addr
Use the following IP address
(which must be given as an IP number, not
a hostname) as the source address in outgoing probe packets.  On
hosts with more than one IP address, this option can be used to
force the source address to be something other than the IP address
of the interface the probe packet is sent on.  If the IP address
is not one of this machine's interface addresses, an error is
returned and nothing is sent.
.It Fl t Ar tos
Set the
.Em type-of-service
in probe packets to the following value (default zero).  The value must be
a decimal integer in the range 0 to 255.  This option can be used to
see if different types-of-service result in different paths.  (If you
are not running a
.Bx 4.3 tahoe
or later system, this may be academic since the normal network
services like telnet and ftp don't let you control the
.Dv TOS ) .
Not all values of
.Dv TOS
are legal or
meaningful \- see the IP spec for definitions.  Useful values are
probably
.Ql \-t 16
(low delay) and
.Ql \-t 8
(high throughput).
.It Fl v
Verbose output.  Received
.Tn ICMP
packets other than
.Dv TIME_EXCEEDED
and
.Dv UNREACHABLE Ns s
are listed.
.It Fl w
Set the time (in seconds) to wait for a response to a probe (default 3
sec.).
.El
.Pp
This program attempts to trace the route an IP packet would follow to some
internet host by launching
.Tn UDP
probe
packets with a small ttl (time to live) then listening for an
.Tn ICMP
"time exceeded" reply from a gateway.  We start our probes
with a ttl of one and increase by one until we get an
.Tn ICMP
"port unreachable"
(which means we got to "host") or hit a max (which
defaults to 30 hops & can be changed with the
.Fl m
flag).  Three
probes (changed with
.Fl q
flag) are sent at each ttl setting and a
line is printed showing the ttl, address of the gateway and
round trip time of each probe.  If the probe answers come from
different gateways, the address of each responding system will
be printed.  If there is no response within a 3 sec. timeout
interval (changed with the
.Fl w
flag), a "*" is printed for that
probe.
.Pp
We don't want the destination
host to process the
.Tn UDP
probe packets so the destination port is set to an
unlikely value (if some clod on the destination is using that
value, it can be changed with the
.Fl p
flag).
.Pp
A sample use and output might be:
.Bd -literal
[yak 71]% traceroute nis.nsf.net.
traceroute to nis.nsf.net (35.1.1.48), 30 hops max, 56 byte packet
1  helios.ee.lbl.gov (128.3.112.1)  19 ms  19 ms  0 ms
2  lilac-dmc.Berkeley.EDU (128.32.216.1)  39 ms  39 ms  19 ms
3  lilac-dmc.Berkeley.EDU (128.32.216.1)  39 ms  39 ms  19 ms
4  ccngw-ner-cc.Berkeley.EDU (128.32.136.23)  39 ms  40 ms  39 ms
5  ccn-nerif22.Berkeley.EDU (128.32.168.22)  39 ms  39 ms  39 ms
6  128.32.197.4 (128.32.197.4)  40 ms  59 ms  59 ms
7  131.119.2.5 (131.119.2.5)  59 ms  59 ms  59 ms
8  129.140.70.13 (129.140.70.13)  99 ms  99 ms  80 ms
9  129.140.71.6 (129.140.71.6)  139 ms  239 ms  319 ms
10  129.140.81.7 (129.140.81.7)  220 ms  199 ms  199 ms
11  nic.merit.edu (35.1.1.48)  239 ms  239 ms  239 ms

.Ed
Note that lines 2 & 3 are the same.  This is due to a buggy
kernel on the 2nd hop system \- lbl-csam.arpa \- that forwards
packets with a zero ttl (a bug in the distributed version
of 4.3
.Tn BSD ) .
Note that you have to guess what path
the packets are taking cross-country since the
.Tn NSFNet
(129.140)
doesn't supply address-to-name translations for its
.Tn NSS Ns es .
.Pp
A more interesting example is:
.Bd -literal
[yak 72]% traceroute allspice.lcs.mit.edu.
traceroute to allspice.lcs.mit.edu (18.26.0.115), 30 hops max
1  helios.ee.lbl.gov (128.3.112.1)  0 ms  0 ms  0 ms
2  lilac-dmc.Berkeley.EDU (128.32.216.1)  19 ms  19 ms  19 ms
3  lilac-dmc.Berkeley.EDU (128.32.216.1)  39 ms  19 ms  19 ms
4  ccngw-ner-cc.Berkeley.EDU (128.32.136.23)  19 ms  39 ms  39 ms
5  ccn-nerif22.Berkeley.EDU (128.32.168.22)  20 ms  39 ms  39 ms
6  128.32.197.4 (128.32.197.4)  59 ms  119 ms  39 ms
7  131.119.2.5 (131.119.2.5)  59 ms  59 ms  39 ms
8  129.140.70.13 (129.140.70.13)  80 ms  79 ms  99 ms
9  129.140.71.6 (129.140.71.6)  139 ms  139 ms  159 ms
10  129.140.81.7 (129.140.81.7)  199 ms  180 ms  300 ms
11  129.140.72.17 (129.140.72.17)  300 ms  239 ms  239 ms
12  * * *
13  128.121.54.72 (128.121.54.72)  259 ms  499 ms  279 ms
14  * * *
15  * * *
16  * * *
17  * * *
18  ALLSPICE.LCS.MIT.EDU (18.26.0.115)  339 ms  279 ms  279 ms

.Ed
Note that the gateways 12, 14, 15, 16 & 17 hops away
either don't send
.Tn ICMP
"time exceeded" messages or send them
with a ttl too small to reach us.  14 \- 17 are running the
.Tn MIT
C Gateway code that doesn't send "time exceeded"s.  God
only knows what's going on with 12.
.Pp
The silent gateway 12 in the above may be the result of a bug in
the 4.[23]
.Tn BSD
network code (and its derivatives):  4.x (x <= 3)
sends an unreachable message using whatever ttl remains in the
original datagram.  Since, for gateways, the remaining ttl is
zero, the
.Tn ICMP
"time exceeded" is guaranteed to not make it back
to us.  The behavior of this bug is slightly more interesting
when it appears on the destination system:
.Bd -literal
1  helios.ee.lbl.gov (128.3.112.1)  0 ms  0 ms  0 ms
2  lilac-dmc.Berkeley.EDU (128.32.216.1)  39 ms  19 ms  39 ms
3  lilac-dmc.Berkeley.EDU (128.32.216.1)  19 ms  39 ms  19 ms
4  ccngw-ner-cc.Berkeley.EDU (128.32.136.23)  39 ms  40 ms  19 ms
5  ccn-nerif35.Berkeley.EDU (128.32.168.35)  39 ms  39 ms  39 ms
6  csgw.Berkeley.EDU (128.32.133.254)  39 ms  59 ms  39 ms
7  * * *
8  * * *
9  * * *
10  * * *
11  * * *
12  * * *
13  rip.Berkeley.EDU (128.32.131.22)  59 ms !  39 ms !  39 ms !

.Ed
Notice that there are 12 "gateways" (13 is the final
destination) and exactly the last half of them are "missing".
What's really happening is that rip (a Sun-3 running Sun OS3.5)
is using the ttl from our arriving datagram as the ttl in its
.Tn ICMP
reply.  So, the reply will time out on the return path
(with no notice sent to anyone since
.Tn ICMP's
aren't sent for
.Tn ICMP's )
until we probe with a ttl that's at least twice the path
length.  I.e., rip is really only 7 hops away.  A reply that
returns with a ttl of 1 is a clue this problem exists.
.Nm Traceroute
prints a "!" after the time if the ttl is <= 1.
Since vendors ship a lot of obsolete
.Pf ( Tn DEC Ns \'s
Ultrix, Sun 3.x) or
non-standard
.Pq Tn HPUX
software, expect to see this problem
frequently and/or take care picking the target host of your
probes.
Other possible annotations after the time are
.Sy !H ,
.Sy !N ,
.Sy !P
(got a host, network or protocol unreachable, respectively),
.Sy !S
or
.Sy !F
(source route failed or fragmentation needed \- neither of these should
ever occur and the associated gateway is busted if you see one).  If
almost all the probes result in some kind of unreachable,
.Nm traceroute
will give up and exit.
.Pp
This program is intended for use in network testing, measurement
and management.
It should be used primarily for manual fault isolation.
Because of the load it could impose on the network, it is unwise to use
.Nm traceroute
during normal operations or from automated scripts.
.Sh AUTHOR
Implemented by Van Jacobson from a suggestion by Steve Deering.  Debugged
by a cast of thousands with particularly cogent suggestions or fixes from
C. Philip Wood, Tim Seaver and Ken Adelman.
.Sh SEE ALSO
.Xr netstat 1 ,
.Xr ping 8
.Sh HISTORY
The
.Nm
command
.Bt
