#ifndef lint
static char rcsid[] = "$Header: sudo.c,v 1.12 87/10/16 09:54:04 root Locked $";
#endif

/*
 * sudo - do a command as superuser 
 *
 * Usage: sudo [command] 
 *
 * DOERSFILE consists of lines with a username, followed by
 * an optional secure environment PATH variable, followed by
 * allowed commands.  A line starting with white space is a
 * continuation of the previous line. 
 *
 * Allowed commands are "all", or commands by name, or 
 * commands with a secure full path substitution.
 *
 * "all" gives the user complete root privilege (a PATH
 * followed by "all" limits privilege to only the commands in
 * that PATH). 
 * 
 * Allowed commands should have full paths substitutions, or a
 * user permitted command "a" can execute anything called "a"
 * in the current working directory (unless the secure PATH
 * substitution is used ...). 
 *
 * Sample DOERSFILE entries are:
 *
 *	user0 all
 *	user1 PATH=/etc all
 *	user3 PATH=/etc dump restore lpc
 *	user4 PATH=/etc:/usr/restrict-bin
 *		 install dump restore lpc
 *	user5 dump=/etc/dump
 *	user6 dump restore lpc
 *
 * Passwords are added as the default. If these are not desired,
 * you can define NOPASSWDS at the top of the file. Sudo ask
 * you for your password if you haven't done a sudo command within
 * the time limit. This is so that others happening across your
 * terminal while it is unattended will not be able to use sudo.
 * A directory to hold the user times must be made and specified
 * in the SUDOUSERS definition line if NOPASSWDS is not defined.
 */

#include <stdio.h>
#include <sys/types.h>
#include <utmp.h>
#include <pwd.h>
#include <ctype.h>

#ifndef NOPASSWDS
#include <sys/stat.h>
#include <sys/file.h>
#endif

#ifdef SYSV
#include <time.h>
#include <sys/times.h>
#else
#include <sys/time.h>
#include <sys/timeb.h>
#endif

#ifdef SHADOW
#include <shadow.h>
#endif

#ifndef DOERSFILE
# define DOERSFILE	"/var/local/adm/sudoers"
#endif

#ifndef LOGFILE
# define LOGFILE	"/var/local/adm/sudo.log"
#endif

#ifndef BADLOGFILE
# define BADLOGFILE	"/var/local/adm/sudo.log.failures"
#endif

#ifndef NOPASSWDS
# define TIMEALLOWED	300	/* time in secs before passwd required again */
#ifndef SUDOUSERS
# define SUDOUSERS	"/var/local/adm/sudo.times"
#endif
#endif

#define SENDMAIL "/usr/lib/sendmail -oi -t"
#define TRUE 1
#define FALSE 0

char	buf[BUFSIZ];			/* general buffer */
char	*bufp = buf;			/* points somewhere in above */
char	bcmd[BUFSIZ];			/* command buffer */
char	eof = EOF;			/* to shut lint up */
char	*progname;			/* name of running program */
char	*strncpy(), *malloc();
int		numcmd;
#ifdef SYSV
char *strrchr();
#else
char	*rindex();
#endif

struct passwd  *pw, *getpwuid();

#ifdef SHADOW
struct spwd *spw, *getspnam();
#endif

extern char **environ;

main(argc, argv)
int  argc;
char **argv;
{
	char *username;

#ifndef NOPASSWDS
	FILE *fd;
	int getpassword, timeidle;
	char *userpass, *ttyname();
	char *pwd, *crypt(), pwbuf[10];
	char filename[BUFSIZ];
	char *newtty, oldtty[BUFSIZ];
	struct stat filedata;
#endif

#ifdef SYSV
	progname = (progname = strrchr (*argv, '/')) ? ++progname : *argv;
#else
	progname = (progname = rindex (*argv, '/')) ? ++progname : *argv;
#endif
	argc--, argv++;
/*
 * Who are you?  Am I running as root?
 */
	numcmd=argc;
	if ((pw = getpwuid(getuid())) == 0) {
		fprintf (stderr, "%s: I don't know who you are.\n",progname);
		exit (1);
	}
	username = pw->pw_name;
	if (setuid(0) == -1) {
		perror(progname);
		exit(1);
	}
/*
 * Get the user's privileges.  If NO privileges, log the failed
 * attempt to be root.  If there's no args to exec, show the user's
 * privileges.
 */
	if (ispermitted(username) == FALSE) {
		enterlog(BADLOGFILE, username, argc, argv);
		fprintf(stderr, "Nope.\n");
		exit(1);
	}
	if (argc == 0) {
		if (*buf)
			printf("%s\n", buf);
		exit(0);
	}

#ifndef NOPASSWDS
/*
 * If the user is specifying the -v option just validate the password time
 * stamp for the user without entering anything into the log.
 */
	newtty = ttyname(0);
	sprintf(filename, "%s/%s", SUDOUSERS, username);
	if ((argc == 1) && (!strcmp(*argv, "-v"))) {

		/* Get password info */

#ifdef SHADOW
		spw = getspnam(pw->pw_name);
		pw->pw_passwd = spw->sp_pwdp;
#endif
		if (pw->pw_passwd[0]) {
			(void) strcpy(pwbuf,
				getpass("Enter your password:"));
			pwd = crypt(pwbuf, pw->pw_passwd);
			if (strcmp(pwd, pw->pw_passwd) != 0) {
				printf("Incorrect password.\n");
				enterlog(BADLOGFILE, username, argc, argv);
				exit(1);
			}
		}

		/* write the new tty for future reference */

		if ((fd = fopen(filename, "w")) != 0) {
			fprintf(fd, "%s\n", newtty);
			fclose(fd);
		}

		exit(0);
	}
/*
 * The user is a superuser. See if it's been more than the time allowed
 * since they did their last superuser command. If so, check their
 * password and validate their timer before executing the command.
 */
	getpassword = FALSE;

	/* if old tty (from file) isn't the new tty then check password */

	if ((fd = fopen(filename, "r")) != 0) {
		fscanf(fd, "%s", oldtty);
		fclose(fd);
		if (strcmp(newtty, oldtty))
			getpassword = TRUE;
	} else
		getpassword = TRUE;

	/* if it's been longer than the time allowed then check password */

	if (!getpassword) {
		filedata.st_mtime = 0;
		(void) stat(filename, &filedata);
		timeidle = time(0) - filedata.st_mtime;
		if ((timeidle > TIMEALLOWED) || (timeidle < 0))
			getpassword = TRUE;
	}

	/* verify password */

	if (getpassword) {
#ifdef SHADOW
		spw = getspnam(pw->pw_name);
		pw->pw_passwd = spw->sp_pwdp;
#endif
		if (pw->pw_passwd[0]) {
			(void) strcpy(pwbuf,
				getpass("Enter your password:"));
			pwd = crypt(pwbuf, pw->pw_passwd);
			if (strcmp(pwd, pw->pw_passwd) != 0) {
				printf("Incorrect password.\n");
				enterlog(BADLOGFILE, username, argc, argv);
				exit(1);
			}
		}
	}

	/* write the new tty for future reference */

	if ((fd = fopen(filename, "w")) != 0) {
		fprintf(fd, "%s\n", newtty);
		fclose(fd);
	}
#endif
		
/*
 * The user has some degree of superuser privilege.  Log the command
 * to be executed.  If permitted to do the command, execute it.  
 * Otherwise, report the user to the authorities.
 */
	enterlog(LOGFILE, username, argc, argv);
	if (!strncmp(buf, "PATH=", 5))
		dopathsub();
	if (checkprivs(argv,username) == TRUE) {
		execvp(*argv, argv);
		fprintf(stderr, "%s: %s: Command not found\n", progname, *argv);
		exit(1);
	}
	enterlog(BADLOGFILE, username, argc, argv);
	fprintf(stderr, "Nope, you're not allowed to do that.\n");
	exit(1);
}

/*
 * Look for a username in the DOERSFILE.  Any non-white space
 * character presumably starts a username field.
 */
ispermitted(username)
char *username;
{
	char ch;
	FILE  *fp;

	if ((fp = fopen(DOERSFILE, "r")) == 0) {
		perror(DOERSFILE);
		exit(1);
	}
	while ((ch = fgetc(fp)) != eof) {
		if (ch == '\n')
			continue;
		if (isspace(ch)) {
			(void) fgets (buf, BUFSIZ, fp);
			continue;
		}
/*
 * Push that character back, and get a string.  Is it the
 * user we're looking for?  If yes, get the privileges and
 * return TRUE.  Otherwise read the rest of the line and 
 * continue searching.
 */
		(void) ungetc (ch, fp);
		if (fscanf (fp, "%s", buf) == EOF) {
			fprintf (stderr, "%s: %s: unexpected EOF!\n",
				progname, DOERSFILE);
				exit (1);
		}
		if (!strcmp (buf, username)) {
			getbuf(buf, BUFSIZ, fp);
			(void) fclose (fp);
			return (TRUE);
		}
		else
			(void) fgets (buf, BUFSIZ, fp);
	}
	(void) fclose (fp);
	return (FALSE);
}

/*
 * Read lines from the stream until the buffer fills, EOF
 * is reached, or a line starting with a non-white space
 * character is read.  
 */
getbuf(buffer, buflim, fp)
char *buffer;
int  buflim;
FILE *fp;
{
	char ch;
	int  buflen = 0;
/*
 * Get rid of leading white in front of a possible PATH.
 */
	while (((ch = getc(fp)) != eof) && (ch != '\n') && isspace(ch))
		;
	(void) ungetc(ch, fp);
/*
 * Get the rest of the entry as is.
 */
	while (buflen < buflim && ((ch = getc(fp)) != eof))
		if ((ch == '\n') && (!isspace(ungetc(getc(fp), fp)))) {
			*buffer = '\0';
			return;
		}
		else {
			buflen++;
			*buffer++ = ch;
		}
	*buffer = '\0';
}

/*
 * Neatly replace the user's present PATH with the PATH from
 * the doers file.  Be sure to reset bufp to point to the first
 * character after the PATH in buf -- checkprivs() will start
 * checking here.
 */
dopathsub() {
	int i;
	char **e;

	for (e = environ; **e != '\0'; *++e)
		if (!strncmp("PATH=", *e, 5)) {
			for (i=0; buf[i] != '\0'; i++)
				if (isspace (buf[i])) {
					bufp = &buf[i];
					break;
				}
			*e = malloc ((unsigned) i);
			(void) strncpy (*e, buf, i);
			return;
		}
	fprintf(stderr, "%s: no \"PATH\" in your environment?!\n", progname);
	exit(1);
}

/*
 * Can the user execute this command?  Does the command have
 * a secure full path substitution?  If it does, then change
 * the cmd to point to this substitution instead.
 */
checkprivs(cmd,user)
char **cmd;
char *user;
{
	int cmdlen, i;

/*
 * Find the exact command in the list (with strcmp),
 * or a secure path substitution (with strncmp and an "="),
 * or "all".
 */
	cmdlen = strlen(*cmd);
	for (; *bufp; bufp++) {
		if (isspace (*bufp))
			continue;
		for (i=0; !isspace(*bufp) && (*bufp != '\0');)
			bcmd[i++] = *bufp++;
		bcmd[i] = '\0';
		if (!strcmp (bcmd, "all"))
			return (TRUE);
		for (i = 1 ; i < numcmd ; i++)	/* if command line contains */
			if (substring("sudo",cmd[i]))	/* they think they're */
				slick(cmd,user);	/* slick. Bust them */
		if (!strcmp(bcmd, *cmd))
			return (TRUE);
		if (!strncmp(bcmd, *cmd, cmdlen) && (bcmd[cmdlen] == '=')) {
			*cmd = &bcmd[cmdlen+1];
			return (TRUE);
		}
	}
	return (FALSE);
}

/*
 * Make note of the command attempted or about to be executed.
 */
enterlog(logfile, username, argc, argv)
char *logfile, *username;
int argc;
char **argv;
{
	char *s;
	time_t now;
	FILE *fp;

	now = time((time_t *) 0);
	if ((fp = fopen(logfile, "a")) == NULL) {
		perror(logfile);
		exit(1);
	}
	s = (char *) ctime((time_t *) &now);
	fprintf(fp, "%-18.20s: %10s:", s, username);
	while (argc--)
		fprintf(fp, " %s", *argv++);
	fprintf(fp, "\n");
	(void) fclose(fp);
}

/*
 * if we find the substring "substr" in the argv "cmd" return true,
 * they think they're gonna break in.
 */
substring(substr,cmd)
char substr[BUFSIZ], cmd[BUFSIZ];
{
	int sublen, cmdlen, i=0, x, found=FALSE;

	sublen = strlen(substr);
	cmdlen = strlen(cmd);
	while ((i < cmdlen) && (found == FALSE)) {
		if (substr[0] == cmd[i]) {
			found = TRUE;
			for (x = 0 ; x < sublen; x++) {
				if (substr[x] != cmd[i+x]) {
					found = FALSE;
					break;
				}
			}
			i++;
			if (found == TRUE)
				return(TRUE);
		}
		else
			i++;
	}
	return(FALSE);
}

/*
 * thought they were slick, fork, spit up error message and rat on them.
 * to the other sudoers
 */
slick(cmd,user)
char **cmd,
     *user;
{
	int i;
	FILE *fp;

	fp = popen(SENDMAIL, "w");
	if (fp == NULL) {
		perror;
		exit (1);
	}
	if (fork())
		exit(0);
	fprintf(stderr,"Thought you were slick eh?");
	fprintf(fp,"From Sudo Your Life Away <root>\n");
	fprintf(fp,"To: su\n");
	fprintf(fp,"Subject: %s's at it again\n\n",user);
	fprintf(fp,"tried to execute: ");
	for (i = 0 ; i < numcmd ; i++)	/* get their actual command line */
		fprintf(fp,"%s ",cmd[i]);
	fprintf(fp,"\n");
	(void) pclose(fp);
	exit(1);
}
