#if !defined(__pwd_h)
#define __pwd_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:pwd.h	1.17 91/07/10 {Apple version 3.0 90/11/29 11:37:56}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1984-85 AT&T */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif

#if !defined(__stdio_h)
# if defined(__MPW_C__)
#   include "/:usr:include:stdio.h"
# else
#   include <stdio.h>
# endif
#endif

struct	passwd { /* see getpwent(3) */
	char	*pw_name;
	char	*pw_passwd;
#if defined(_POSIX_SOURCE)
	uid_t	pw_uid;
	gid_t	pw_gid;
#else
	int	pw_uid;
	int	pw_gid;
#endif /* _POSIX_SOURCE */
	char	*pw_age;
	char	*pw_comment;
	char	*pw_gecos;
	char	*pw_dir;
	char	*pw_shell;
};

#if defined(__STDC__)
  struct passwd *getpwuid(uid_t uid);
  struct passwd *getpwnam(const char *name);
#else
  struct passwd *getpwuid(), *getpwnam();
#endif /* __STDC__ */

#if defined(_SYSV_SOURCE) || defined(_BSD_SOURCE)
#if defined(__STDC__)
  struct passwd *getpwent(void);
#else
  struct passwd *getpwent();
#endif /* __STDC__ */
#endif /* _SYSV_SOURCE || _BSD_SOURCE */

#if defined(_SYSV_SOURCE)
struct comment {
	char	*c_dept;
	char	*c_name;
	char	*c_acct;
	char	*c_bin;
};

#if defined(__STDC__)
  struct passwd *fgetpwent(FILE *stream);
#else
  struct passwd *fgetpwent();
#endif /* __STDC__ */
#endif /* _SYSV_SOURCE */

#endif /* __pwd_h */
