/*
 * Copyright 1991, 1992, 1993, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.
 */

/*
 * id - print current process user identification information
 *
 *	Print the current process identifiers.  This includes the
 *	UID, GID, effective-UID and effective-GID.  Optionally print
 *	the concurrent group set if the current system supports it.
 */

#include "ngroups.h"
#include <sys/types.h>
#include <stdio.h>
#include <grp.h>
#include "config.h"
#include "pwd.h"

#ifndef	lint
static	char	sccsid[] = "@(#)id.c	3.7	07:17:31	03 Jun 1993";
#endif

usage ()
{
	fprintf (stderr, "usage: id [ -a ]\n");
	exit (1);
}

/*ARGSUSED*/
main (argc, argv)
int	argc;
char	**argv;
{
	int	id;
	GID_T	*groups;
	int	ngroups;
	int	aflg = 0;

	struct	passwd	*pw;
	struct	group	*gr;

	/*
	 * See if the -a flag has been given to print out the
	 * concurrent group set.
	 */

#ifdef AUX
	set42sig();
#endif

	if (argc > 1) {
		if (argc > 2 || strcmp (argv[1], "-a"))
			usage ();
		else
			aflg = 1;
	}

	/*
	 * Print out the real user ID and group ID.  If the user or
	 * group does not exist, just give the numerical value.
	 */

	if (pw = getpwuid (id = getuid ()))
		printf ("uid=%d(%s)", id, pw->pw_name);
	else
		printf ("uid=%d", id);

	if (gr = getgrgid (id = getgid ()))
		printf (" gid=%d(%s)", id, gr->gr_name);
	else
		printf (" gid=%d", id);

	/*
	 * Print out the effective user ID and group ID if they are
	 * different from the real values.
	 */

	if (getuid () != geteuid ()) {
		if (pw = getpwuid (id = geteuid ()))
			printf (" euid=%d(%s)", id, pw->pw_name);
		else
			printf (" euid=%d", id);
	}
	if (getgid () != getegid ()) {
		if (gr = getgrgid (id = getegid ()))
			printf (" egid=%d(%s)", id, gr->gr_name);
		else
			printf (" egid=%d", id);
	}

	/*
	 * Print out the concurrent group set if the user has requested
	 * it.  The group numbers will be printed followed by their
	 * names.
	 */
#ifdef AUX
	if (aflg && NGROUPS_MAX > 1 && (ngroups = NGROUPS_MAX) > 0) {
#else
	if (aflg && NGROUPS_MAX > 1 && (ngroups = getgroups (0, 0)) > 0) {
#endif
		int	i;

		/*
		 * The size of the group set is determined so an array
		 * large enough to hold it can be allocated.
		 */

		if (!(groups = (GID_T *) malloc (ngroups * sizeof *groups))) {
			putchar ('\n');
			perror ("out of memory");
			exit (1);
		}

		/*
		 * Start off the group message.  It will be of the format
		 *
		 *	groups=###(aaa),###(aaa),###(aaa)
		 *
		 * where "###" is a numerical value and "aaa" is the
		 * corresponding name for each respective numerical value.
		 */

#ifdef AUX
		ngroups = getgroups (NGROUPS_MAX, groups);
#else
		getgroups (ngroups, groups);
#endif
		printf (" groups=");
		for (i = 0;i < ngroups;i++) {
			if (i)
				putchar (',');

			if (gr = getgrgid (groups[i]))
				printf ("%d(%s)", (int) groups[i], gr->gr_name);
			else
				printf ("%d", (int) groups[i]);
		}
	}

	/*
	 * Finish off the line.
	 */

	putchar ('\n');
	exit (0);
	/*NOTREACHED*/
}
