#if !defined(__sys_mtio_h)
#define __sys_mtio_h

#if !defined(_NO_IDENTS) && defined(_HEAD_IDENTS)
# pragma ident "@(#)head:sys/mtio.h  1.10 95/07/10 {Apple/jmj version 1.10 95/07/10 14:39:13}"
#endif

/*
 * Copyright 1987-91 Apple Computer, Inc.
 * All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF APPLE COMPUTER, INC.
 * The copyright notice above does not evidence any actual or
 * intended publication of such source code.
 */

/* Copyright 1982, 1986 The Regents of the University of California */

#if !defined(__sys_types_h)
# if defined(__MPW_C__)
#   include "/:usr:include:sys:types.h"
# else
#   include <sys/types.h>
# endif
#endif 

/*
 * Structures and definitions for mag tape io control commands
 */

/*
 * structure for MTIOCTOP - mag tape op command
 */
struct	mtop	{
	short	mt_op;		/* operations defined below */
	daddr_t	mt_count;	/* how many of them */
};

/*
 * operations
 */
#define MTWEOF	0	/* write an end-of-file record */
#define MTFSF	1	/* forward space file */
#define MTBSF	2	/* backward space file */
#define MTFSR	3	/* forward space record */
#define MTBSR	4	/* backward space record */
#define MTREW	5	/* rewind */
#define MTOFFL	6	/* rewind and put the drive offline */
#define	MTNOP	7	/* no operation, sets status only */
#define	MTCACHE	8	/* enable controller cache */
#define	MTNOCACHE 9	/* disable controller cache */
#define	MTFORMAT 10	/* format the tape cartridge */
#define	MTRETEN 11	/* retension the cartridge */

/*
 * structure for MTIOCGET - mag tape get status command
 */

struct	mtget	{
	short	mt_type;	/* type of magtape device */
/*
 * the following two registers are grossly device dependent
 */
	short	mt_dsreg;	/* ``drive status'' register.
				 * Under NEWtc, this ==1 if we are
				 * sure that mt_blkno is correct,
				 * 0 if not.
				 */
	short	mt_erreg;	/* ``error'' register
				 * Under NEWtc, this is the Revision
				 * number (version) of 'tc'.
				 */
/*
 * end device-dependent registers
 */
	short	mt_resid;	/* residual count */
	daddr_t	mt_fileno;	/* file number of current position */
	daddr_t	mt_blkno;	/* block number of current position */
	int     mt_blksize;      /* physical blocksize on tape */
	int     mt_maxblk;      /* max blocks on tape */
};

/*
 * Constants for mt_type byte.  These are the same
 * for controllers compatible with the types listed.
 */
#define	MT_ISTS		0x01		/* TS-11 */
#define	MT_ISHT		0x02		/* TM03 Massbus: TE16, TU45, TU77 */
#define	MT_ISTM		0x03		/* TM11/TE10 Unibus */
#define	MT_ISMT		0x04		/* TM78/TU78 Massbus */
#define	MT_ISUT		0x05		/* SI TU-45 emulation on Unibus */
#define	MT_ISCPC	0x06		/* SUN */
#define	MT_ISAR		0x07		/* Archive Viper */
#define	MT_ISTMSCP	0x08		/* DEC TMSCP protocol (TU81, TK50) */
#define	MT_ISTC40	0x09		/* Apple 40mb tape cartridge */
#define	MT_ISQS1054	0x0a		/* Qualstar 1054 9track */
#define	MT_ISQS3410	0x0b		/* Qualstar 3410 9track */
#define MT_ISARPY       0x0c		/* Archive Python */
#define MT_ISAR150      0x0d		/* Archive Viper 150 */
#define MT_ISAR525      0x0e		/* Archive Viper 525 */
#define MT_ISEX8200     0x10		/* Exabyte 8200 */
#define MT_ISEX8500     0x11		/* Exabyte 8500 */
#define MT_ISTEAC       0x12		/* Teac 600 */
#define MT_ISHP35480	0x13		/* HP 35480 DAT */
#define MT_ISSDT4000	0x14		/* Sony SDT-4000 DAT */
#define MT_ISWDAT	0x7f		/* WangDAT */

/*
 * mag tape io control commands
 */
#define	MTIOCTOP	_IOW('m', 1, struct mtop)	/* do a mag tape op */
#define	MTIOCGET	_IOR('m', 2, struct mtget)	/* get tape status */
#define MTIOCIEOT	_IO('m', 3)			/* ignore EOT error */
#define MTIOCEEOT	_IO('m', 4)			/* enable EOT error */

#ifndef KERNEL
#define	DEFTAPE	"/dev/rmtc"
#endif

/*
 * New stuff
 */
#define MT_ISWDAT1	MT_ISWDAT		/* WangDAT 1300 */
#define MT_ISWTEK1	0x7e			/* WangTek 6130-FS */
#define MT_ISHP		0x7d			/* HP DAT */
#define MT_ISCIP	0x7c			/* Cipher */
#define MT_ISGEN	0x7b			/* Generic Tape Drive */
#define MT_ISWDAT2	0x7a			/* WangDAT 2600 */
#define MT_ISWTEK2	0x79			/* WangTEK 5525ES QIC */
#define MT_ISWTEK3	0x78			/* WangTEK 6130-HS */
#define MT_ISHP1	MT_ISHP35480		/* HP 35480A */
#define MT_ISSONY4	MT_ISSDT4000		/* SONY SDT-4000 */
#define MT_ISSONY2	0x75			/* SONY SDT-2000 */
#define MT_ISTEAC1      0x74			/* Teac 150 */
#define MT_ISMSONY	0x73			/* Misc SONY unit */
#define MT_ISTEAC2	0x72			/* Teac 60 */
#define MT_ISWTEK4	0x71			/* WangTEK 5150ES */
#define MT_ISHP2	0x70			/* HP 35470A */
#define MT_ISTDC38	0x6f			/* TDC 3800 */
#define MT_ISHP3	0x6e			/* HP 35450 */
#define MT_ISWDAT3	0x6d			/* WangDAT 3100 */
#define MT_ISWDAT4	0x6c			/* WangDAT 3200 */
#define MT_ISWDAT5	0x6b			/* WangDAT 3400 */

#define	MTGOEOD  20	/* go to EOD */
#define MTTRCON  21	/* enable trace */
#define MTTRCOFF 22	/* disable trace */
#define MTERASE  23	/* erase tape */
#define MTSTATUS 99	/* get status */

/*
 * structure for MTIOCJGET - mag tape get status command
 */

#define JMODE_LEN	13
struct	mtjget	{
	uchar_t   mt_wprot;		/* TRUE if tape is write protected */
	uchar_t   mt_ateot;		/* TRUE if tape is @ EOT */
	int   mt_pblkno;		/* "real" physical block number */
	int   mt_pblksize;		/* "real" physical block size */
	int   mt_spblksize;		/* sensed physical block size */
	uchar_t   mt_tracing;		/* tracing flags */
	uchar_t mt_mode[JMODE_LEN];	/* Mode Sense stuff */
};

#define	MTIOCJGET	_IOR('m', 5, struct mtjget)	/* get tape status */

#define MTTRC_MODS    0x01
#define MTTRC_SCSI    0x02
#define MTTRC_RETRY   0x04

#endif /* __sys_mtio_h */
