/* <copyright>
 * 
 * Copyright (c) 1994
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 * 
 * </copyright>
 */

/*<file>
 *
 * Name:       hgbindport.c
 *
 * Purpose:    start programs which use protected port numbers
 *             (wwwgate, gophgate and hgserver)
 *
 * Created:     7 Feb 94    Gerald Pani
 * Modified:   13 Jul 94    Gerald Pani
 *                 1.10: close(sd) after dup2
 *
 * Description:
 *
 * hgbindport opens a socket and binds a port number to it. The number
 * of the socket's file descriptor is 3. After that it resets the
 * effective userid of the process and starts an other program. The
 * file descriptor remains open.
 * The owner of hgbindport should have root privileges and the s-bit
 * of the owner should be set.
 * This program is very small and easy to understand.
 * A system administrator could read it and compile with 
 * 'cc -o hgbindport hgbindport.c'.
 * After that, please move it to
 * /usr/local/Hyper-G/bin/{CPU-Type}/hgbindport
 * and attach root privileges to it.
 *
 *</file>
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <string.h>
#include <netinet/in.h>

#ifndef SOMAXCONN
#define SOMAXCONN 5
#endif

#define DESCR 3

char HyperGWhat[] = "@(#)[Hyper-G] [SDA] hgbindport	1.11 [bind port - start progam] [Gerald Pani]";


int main( argc, argv, envp )
int argc ; 
char *argv[], *envp[] ;
{    
     int sd;
     int port;
     struct sockaddr_in name;
     uid_t realuser;
     int optval = 1;
     int optlen = sizeof(int);

     if (argc < 3) {
	  fprintf( stderr, "too few args!\n");
	  fprintf( stderr, "\nusage: %s portnumber program [args ...]\n", argv[0]);
	  exit(1);
     }

     if (sscanf( argv[1], "%d", &port) != 1) {
	  fprintf( stderr, "invalid port number!\n");
	  exit(1);
     }
     
     if ((sd = socket( AF_INET, SOCK_STREAM, 0)) == -1) {
	  perror( "hgbindport:socket");
	  exit(1);
     }

     if (setsockopt( sd, SOL_SOCKET, SO_REUSEADDR, (char*)&optval, optlen) == -1) {
	  perror( "hgbindport:setsockopt");
	  close( sd);
	  exit(1);
     }

     memset( (char*)&name, 0, sizeof( name));
     name.sin_family = AF_INET;
     name.sin_port = htons(port);
     name.sin_addr.s_addr = htonl(INADDR_ANY);

     if (bind( sd, (struct sockaddr*)&name, sizeof(name)) < 0) {
	  perror( "hgbindport:bind");
	  close( sd);
	  exit(1);
     }
     
     if (listen( sd, SOMAXCONN) < 0) {
	  perror( "hgbindport:listen");
	  close( sd);
	  exit(1);
     }
     
     if (sd != DESCR) {
	  if (dup2( sd, DESCR) == -1) {
	       perror( "hgbindport:dup2");
	       close( sd);
	       exit(1);
	  }
	  close(sd);
     }
     
     realuser = getuid();
     
     if (setuid( realuser) == -1) {
	  perror( "hgbindport:seteuid");
	  close( DESCR);
	  exit(1);
     }

     execvp( argv[2], &argv[2]);
     
     perror( "hgbindport:execvp");
     close( DESCR);
     exit(1);
}
