#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <E-mail.h>
#include <netdb.h>


#define BUFFER_SIZE 256


int main(int argc, char *argv[])
{
   BMailMessage *mail = new BMailMessage();
   char buffer[BUFFER_SIZE];
   bool atty;
	
   atty = isatty(fileno(stdin));

   if ((argc > 2) || (!atty && (argc != 2))) {
      printf("USAGE: %s [recipient]\n", argv[0]);
      exit(0);
   }
	
   if (atty) {
      /* Let the user create the mail message. */
      if (argc == 2) {
	 mail->AddHeaderField(B_MAIL_TO, argv[1]);
      } else {
	 printf("To: ");
	 fgets(buffer, BUFFER_SIZE, stdin);
	 /* remove the new line character */
	 buffer[strlen(buffer)-1] = '\0';
	 mail->AddHeaderField(B_MAIL_TO, buffer);
      }
		
      printf("Subject: ");
      fgets(buffer, BUFFER_SIZE, stdin);
      /* remove the new line character */
      buffer[strlen(buffer)-1] = '\0';
      mail->AddHeaderField(B_MAIL_SUBJECT, buffer);
		
      printf("Type a period (`.') on a line by itself to send this message.\n");
	
      do {
	 fgets(buffer, BUFFER_SIZE, stdin);
	 if ((buffer[0] == '.') && (buffer[1] == '\n'))
	    break;
	 mail->AddContent(buffer, strlen(buffer));
      } while (1);	
   } else {
      /* Create a mail message from the text that was piped in. */
      mail->AddHeaderField(B_MAIL_TO, argv[1]);
      mail->AddHeaderField(B_MAIL_SUBJECT, "STDIN");

      do {
	 fgets(buffer, BUFFER_SIZE, stdin);
	 /* We may reach the end of the file on the last line of
	    input, but we still want that line to be sent. */
	 if (!feof(stdin) || 
	     (feof(stdin) && (buffer[strlen(buffer)-1] != '\n'))) {
	    mail->AddContent(buffer, strlen(buffer));
	 }
      } while (!feof(stdin));
   }

   /* Send the email message without waiting. */	
   mail->Send(true);
	
   delete mail;
}
