// Robin Hood Web Server - A web server for BeOS
// Copyright (C) 1999 Joe Kloss

// This program is free software; you can redistribute it and/or 
// modify it under the terms of the GNU General Public License 
// as published by the Free Software Foundation; either version 2 
// of the License, or (at your option) any later version. 

// This program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
// GNU General Public License for more details. 

// You should have received a copy of the GNU General Public License 
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Contact Info:
// Author: Joe Kloss
// E-mail: axly@deltanet.com
// Postal Address: 25002 Ravenswood, Lake Forest, CA 92630, USA

#include <Application.h>
#include <stdio.h>
#include "RHLogger.h"
#include "RHMessages.h"

int log_printf( const char *format, ... )
{
	char		s[4096];
	int 		n;
	va_list 	argList;
	va_start( argList, format );
	n = vsprintf( s, format, argList );
	va_end( argList );
	
	BMessage	msg( MSG_LOG );
	msg.AddString( kMSG_LOG_STRING, s );
	be_app_messenger.SendMessage( &msg );
	
	return n;
}

int log_status_line( int32 sn, const char *statusLine )
{
	return log_printf( "%ld Status-Line: %s\n", sn, statusLine );
}

int log_sending( int32 sn, int32 contentLength, const char *resource )
{
	return log_printf( "%ld Sending: %ld %s\n", sn, contentLength, resource );
}

int log_sent( int32 sn, int32 bytesSent, int32 time, int32 bytesSeconds )
{
	return log_printf( "%ld Sent: %ld bytes %ld ms %ld bytes/second\n", 
		sn, bytesSent, time, bytesSeconds );
}