/*
 * Copyright (c)1997 by Dianne Hackborn.
 * All rights reserved.
 *
 * This is all that is needed to place the ArpVT200 emulator
 * into an external add-on.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@enteract.com>.
 *
 */

#define ARPTERMINAL_ADDON 1

#ifndef ARPVT200_H
#include "ArpVT200.h"
#endif

/* NOTE:
 *
 * This is the -only- symbol you should export.  Do so by
 * selected 'Use ".exp" file' as you PEF/Export Symbols option.
 * The .exp file should appear in the same directory as your
 * add-on binary will be placed, and contain just this line:
 *
 *		GetEmulatorAddon__Fv		# GetEmulatorAddon()
 *
 * (You don't want to select the 'Use #pragma' export option
 * because the rest of the ArpCommon library is itself set up
 * to be placed in a shared library, and thus exports all its
 * symbols with pragmas.  What you'll get is thus the entire
 * library in your add-on.  Probably not what you want!)
 */

const ArpEmulatorAddon* GetEmulatorAddon(void)
{
	return &ArpVT200::AddonInterface;
}
