/*
 * ArpTelnet Copyright (c)1997-98 by Dianne Hackborn.
 * All rights reserved.
 *
 * Based (increasingly loosly) on WebTerm, a Web-based terminal
 * applet written in Java, which is
 * Copyright (C)1996 by the National Alliance for Computational
 * Science and Engineering (NACSE).
 * See <URL:http://www.nacse.org/> for more information.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * TerminalWin.h
 *
 * The TerminalWin class defines a complete window with a
 * terminal placed inside it.  It attaches a VT200 emulator
 * to the terminal, creates an ArpTelnet device, and connects
 * the telnet device with the terminal so that the user can
 * interact with its telnet sessions.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 *
 * 0.1: Created this file.
 *
 */

#ifndef TERMINALWIN_H
#define TERMINALWIN_H

#ifndef _WINDOW_H
#include <Window.h>
#endif

#ifndef ARPCOMMON_ARPEMULATORMANAGER_H
#include <ArpCommon/ArpEmulatorManager.h>
#endif

#ifndef ARPCOMMON_ARPREMOTETERMINAL_H
#include <ArpCommon/ArpRemoteTerminal.h>
#endif

//#define USE_LOOPBACK 1

#ifdef USE_LOOPBACK
class Loopback;
#else
class ArpTelnet;
#endif

class TerminalWin : public BWindow {
private:
	typedef BWindow inherited;
	
public:
	TerminalWin(BPoint pos, const char* title,
					const char* abouttxt = "About" B_UTF8_ELLIPSIS);
	~TerminalWin();
	
	ArpRemoteTerminal* Terminal(void) { return terminal; }
	
	void Connect(const char* rhost, int32 rport=23);
	
	void PrintToTerm(ArpString& str, int32 flags=0);
	void ResizeToTerm(int32 rows=-1, int32 cols=-1);

	virtual void DispatchMessage(BMessage *message,
								 BHandler *handler);
	virtual void MessageReceived(BMessage *message);
	virtual	bool QuitRequested();
	virtual void MenusBeginning(void);
	virtual void Zoom(BPoint leftTop, float width, float height);
	
private:
	ArpEmulatorManager manager;
	
	BMenuItem* lockitem;
	
	BMenuItem* crlfitem;
	BMenuItem* bsdelitem;
	BMenuItem* wrapitem;
	BMenuItem* inverseitem;
	BMenuItem* pqueryitem;
	BMenuItem* rmbpasteitem;
	BMenuItem* iscrollitem;
	BMenuItem* oscrollitem;
	
	ArpRemoteTerminal* terminal;
	#ifdef USE_LOOPBACK
	Loopback* loopback;
	#else
	ArpTelnet* telnet;
	#endif
	
	void update_modes(void);
};

#endif
