/*
 * ArpTelnet Copyright (c)1997-98 by Dianne Hackborn.
 * All rights reserved.
 *
 * Based (increasingly loosly) on WebTerm, a Web-based terminal
 * applet written in Java, which is
 * Copyright (C)1996 by the National Alliance for Computational
 * Science and Engineering (NACSE).
 * See <URL:http://www.nacse.org/> for more information.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@angryredplanet.com>.
 *
 */

#ifndef LOOPBACK_H
#include "Loopback.h"
#endif

#ifndef ARPCOMMON_ARPDEBUG_H
#include <ArpCommon/ArpDebug.h>
#endif

#ifndef ARPCOMMON_ARPTERMINALMSG_H
#include "ArpCommon/ArpTerminalMsg.h"
#endif

Loopback::Loopback(void)
	:curWidth(0), curHeight(0)
{
	Run();
}

Loopback::Loopback(const BMessenger& term)
	:curWidth(0), curHeight(0), terminal(term)
{
	Run();
}

Loopback::~Loopback()
{
}

void Loopback::MessageReceived(BMessage* message)
{
	DB(DBALL, cerr << "Loopback::MessageReceived: " <<
				*message << endl);
	switch( message->what ) {
		case TERM_XFER_TEXT_MSG: {
			if( terminal.IsValid() ) {
				// Just echo it right back to the terminal.
				terminal.SendMessage(message);
			}
		} break;
		case TERM_ATTACH_MSG: {
			message->FindMessenger("terminal",&terminal);
		} break;
		default:
			inherited::MessageReceived(message);
	}
}
