/*****************************************************************************

	Projet	: Droids

	Fichier	:	gCMoteur.cpp
	Partie	: Camera

	Auteur	: RM
	Date		: 130297
	Format	: tabs==2


*****************************************************************************/

#include "machine.h"
#include "gCMoteur.h"
#include "gCThread.h"
#include "gCVideo.h"
#include "bCWinEcran.h"
#include "bCApplication.h"
#include "externs.h"
#include "bCSound.h"

#include <math.h>

//---------------------------------------------------------------------------
// defs

#define K_FRAME_RATE	40000.0

#define K_MAX_TORTUE	200
#define K_VIE_TORTUE	10

//---------------------------------------------------------------------------
// defs index sprites

enum
{
	K_TORTUE_FIXE		=0,
	K_TORTUE_MOUV		=2,
	K_TORTUE_ELEC		=10,		// pendant electrocution
	K_TORTUE_EMORTE	=12,		// mort par electrocution
	K_TIR						=13,		// viseur
	K_ROULEAU				=14,
	K_COCA					=16,
	K_TORTUE_MORTE	=18,		// mort ecrasee -- 3 niveaux
	K_PANEL_BAS			=21,
	K_OUTILS_NORMAL	=22,
	K_OUTILS_ACTIF	=30,
	K_EXPLOSE				=33
};

//---------------------------------------------------------------------------
// defs messages, armes

//**
enum
//**
{
	kMsgArme		= 'mArm',
	kMsgFusil 	= 'mFuz',
	kMsgUzi			= 'mUzi',
	kMsgElec		= 'mElc',
	kMsgExplose	= 'mExp',
	kMsgRedraw	= 'rdrw'
};


#define K_RANGE_FUSIL 96
#define K_RANGE_EXPLOSE 96
#define K_VITESSE_ROULEAU 8
#define K_VITESSE_COCA 32

//---------------------------------------------------------------------------


//***************************************************************************
CMoteur::CMoteur(void)
//***************************************************************************
{
	mVivant = TRUE;
	mSpriteOffset = 0;
	mArme = kFusil;
	mScrollX = 0;
	mScrollY = 0;
	mRouleauX = 0;
	mRouleauY = 0;

	mSpriteDir[0]	= K_TORTUE_MOUV+0;
	mSpriteDir[1]	= K_TORTUE_MOUV+6;
	mSpriteDir[2]	= K_TORTUE_MOUV+4;
	mSpriteDir[3]	= K_TORTUE_MOUV+2;

	mMouseX = mMouseY = mMouseCode = 0;
	mMouseButton = false;
	mMouseUpReceived = true;

	mSoundAhFlag = 0;
	mSoundFunFlag = 0;

	mNbNerd = K_MAX_TORTUE;
	mNbAction = 0;
	mRedrawPanel = false;

	mUseSound = true;

} // end of constructor for CMoteur


//***************************************************************************
CMoteur::~CMoteur(void)
//***************************************************************************
{
	mSound.stop();
	if (mTortue) delete [] mTortue;
} // end of destructor for CMoteur


//---------------------------------------------------------------------------


//***************************************************************************
BOOL CMoteur::init(void)
//***************************************************************************
{
long i;

	if (!mSound.init())
	{
		BAlert *alert;
		alert = new BAlert("Nerdkill Sound Error",
							"Sound couldn't get initialized correctly.\n"
							"(This is OK if you're running R3 Intel -- see terminal)",
							"Keep Cool !");
		if (alert) alert->Go();
		else return FALSE;
		// Houston, we've got a problem
		mUseSound = false;
	}
	if (mUseSound)
		if (!mSound.loadAllSound()) return FALSE;

	srand(system_time()/1e3);	// rand() ==> 0...RAND_MAX

	mTortue = new STortue[K_MAX_TORTUE];
	if (!mTortue) return FALSE;

	mNbTortue = K_MAX_TORTUE;
	for(i=0; i<mNbTortue; i++)
	{
		mTortue[i].draw = TRUE;
		mTortue[i].vivante = K_VIE_TORTUE;
		mTortue[i].vit = (rand()*8.0)/(double)(RAND_MAX+1);
		mTortue[i].dir = (rand()*K_2PI)/(double)(RAND_MAX+1);
		mTortue[i].x = (rand()*(KSX-32))/(RAND_MAX+1);
		mTortue[i].y = (rand()*(KSY-32))/(RAND_MAX+1);
		mTortue[i].elec = false;
		mTortue[i].spriteMort = 0;
	}

	return TRUE;
} // end of init for CMoteur


//---------------------------------------------------------------------------


//***************************************************************************
void CMoteur::threadEntryPoint(void)
//***************************************************************************
{
	if (gMoteur) gMoteur->boucleMoteur();
} // end of threadEntryPoint for CMoteur



//***************************************************************************
void CMoteur::boucleMoteur(void)
//***************************************************************************
{
ULONG msg;
ULONG msgParam;
APTR  msgData;
double temps, deltatemps;
sem_id frameRateSem;
double tempsFutile, limiteFutile;
bool action;
long toto =0;

	frameRateSem = create_sem(0, "frame rate sem");

	if (mUseSound)
		mSound.start();
	if (mUseSound)
		mSound.addSingle(kSoundNerdIn);

	changementArme(0);	// choisi arme 0 == fusil
	mScrollX = KSX/2;
	mScrollY = KSY/2;
	gVideo->setScroll(mScrollX, mScrollY);

	tempsFutile = system_time();
	limiteFutile = 10+(rand()*10)/(RAND_MAX+1);
	while(mVivant)
	{
		temps = system_time();
		action = false;
		
		//lecture message
		if (gThreadMoteur->receiveMessage(msg, msgParam, msgData))
		{
			// process message
			switch(msg)
			{
				case kMsgArme:		// changement d'arme
					if (mUseSound)
						mSound.addSingle(kSoundSelect);
					changementArme(msgParam);
					action = true;
					break;
				case kMsgFusil:		// tir fusil
					if (mUseSound)
						mSound.addSingle(kSoundGun);
					tirFusil((long)msgParam, (long)msgData);
					action = true;
					break;
				case kMsgUzi:			// tir uzi
					//tirFusil((long)msgParam, (long)msgData);
					//action = true;
					break;
				case kMsgElec:		// electrocution
					if (mUseSound)
						mSound.addSingle(kSoundElec);
					electrocuter((long)msgParam, (long)msgData);
					action = true;
					break;
				case kMsgExplose:
					if (mUseSound)
						mSound.addSingle(kSoundGun);
					tirExplose((long)msgParam, (long)msgData);
					action = true;
					break;
				case kMsgRedraw:
					changementArme(msgParam);
					break;
			}
		}
		if (mArme == kUzi && mMouseButton)
		{
			if (mUseSound)
				mSound.addSingle(kSoundGun);
			tirFusil(mMouseX, mMouseY);
			action = true;
		}
		else if (mArme == kRouleau)
		{
			if (mUseSound)
				if (mSound.hasSingle(kSoundRouleau2))
					mSound.addSingle(kSoundRouleau2);
			avanceRouleau();
			action = true;
		}

		if (action)
		{
			tempsFutile = system_time();
		}
		else
			if ((system_time() - tempsFutile)/1e6 > limiteFutile)
			{
				makeFunSound();
				tempsFutile = system_time();
				limiteFutile = 10+(rand()*10)/(RAND_MAX+1);
			}

		// process frame
		oneFrame();

		// synchronize to frame rate
		deltatemps = temps+K_FRAME_RATE-system_time();
		if (deltatemps > 0) acquire_sem_etc(frameRateSem, 1, B_TIMEOUT, deltatemps);

		if (mNbNerd == 0)
		{
			BMessage *msg = new BMessage(K_CALL_END);
			msg->AddInt32("nerd", K_MAX_TORTUE);
			msg->AddInt32("shoot", mNbAction);
			be_app->PostMessage(msg);
			delete msg;
			break;
		}
	}

	if (mUseSound)
	{
		mSound.addSingle(kSoundNerdOut);
		snooze(6e6);
	}

} // end of boucleMoteur for CMoteur


//---------------------------------------------------------------------------


//***************************************************************************
void CMoteur::makeAhSound(void)
//***************************************************************************
/*
	Use bits in mSoundAhFlag in order to prevent generating twice the same sound.
	When all bits are set to 1, reset them to 0 and restart.
	Try to find randomly which sound to play.
	Sound codes range from kSoundAh1 to kSoundAh10.
	Mask below must contains bits 0 throug 9 set to 1, it is used to compare and
	know when all sound have been played.
*/
{
const long nbSound = kSoundAh10-kSoundAh1+1;
const long maskCompare = 0x03FF;	// 10 bits
long n, n2;

	// if all sounds played, reset bit field
	if (mSoundAhFlag == maskCompare)
		mSoundAhFlag = 0;

	do
	{
		n = ((rand()*nbSound)/(RAND_MAX+1)) % nbSound;
		//printf("makeAhSound %d\n", n);
		n2 = 1 << n;
	} while (mSoundAhFlag & n2);
	mSoundAhFlag |= n2;

	if (mUseSound)
		mSound.addSingle(kSoundAh1 + n);

} // end of makeAhSound for CMoteur



//***************************************************************************
void CMoteur::makeFunSound(void)
//***************************************************************************
/*
	Use bits in mSoundFunFlag in order to prevent generating twice the same sound.
	When all bits are set to 1, reset them to 0 and restart.
	Try to find randomly which sound to play.
	Sound codes range from kSoundFun1 to kSoundFun5.
	Mask below must contains bits 0 through 4 set to 1, it is used to compare and
	know when all sound have been played.
*/
{
const long nbSound = kSoundFun5-kSoundFun1+1;
const long maskCompare = 0x01F;	// 5 bits
long n, n2;

	// if all sounds played, reset bit field
	if (mSoundFunFlag == maskCompare)
		mSoundFunFlag = 0;

	do
	{
		n = ((rand()*nbSound)/(RAND_MAX+1)) % nbSound;
		//printf("makeFunSound %d\n", n);
		n2 = 1 << n;
	} while (mSoundFunFlag & n2);
	mSoundFunFlag |= n2;

	if (mUseSound)
		mSound.addSingle(kSoundFun1 + n);
} // end of makeFunSound for CMoteur




//---------------------------------------------------------------------------


//***************************************************************************
void CMoteur::mouseDown(long x, long y)
//***************************************************************************
{
	//printf("CMoteur::mouseDown <arme> <x y> %3d %3d\n", (long)mArme, x, y);
	mMouseButton = true;
	mMouseUpReceived = false;

	switch(mArme)
	{
		case kFusil:
			gThreadMoteur->postMessage(gThreadMoteur, kMsgFusil, (ULONG)x, (APTR)y);
			break;
		case kElectrocution:
			gThreadMoteur->postMessage(gThreadMoteur, kMsgElec, (ULONG)x, (APTR)y);
			break;
		case kExplose:
			gThreadMoteur->postMessage(gThreadMoteur, kMsgExplose, (ULONG)x, (APTR)y);
			break;
	}
} // end of mouseDown for CMoteur


//***************************************************************************
void CMoteur::mouseUp(void)
//***************************************************************************
{
	//printf("CMoteur::mouseUp\n");
	mMouseButton = false;
	mMouseUpReceived = true;
} // end of mouseDown for CMoteur


//***************************************************************************
void CMoteur::mouseMoved(long x, long y, ULONG code)
//***************************************************************************
/*
	Code is 0==B_ENTERED_VIEW, 1==B_INSIDE_VIEW, 2==B_EXITED_VIEW
*/
{
	mMouseX = x;
	mMouseY = y;
	mMouseCode = code;
	if (code == B_EXITED_VIEW) mMouseButton = false;
	else if (code == B_ENTERED_VIEW && !mMouseUpReceived && !mMouseButton)
		mMouseButton = true;

} // end of mouseMoved for CMoteur


//***************************************************************************
void CMoteur::keyDown(ULONG beKeyCode)
//***************************************************************************
{
long touche=0;

	if (beKeyCode == B_FUNCTION_KEY)
	{
		BMessage *msg = gVideo->ecran()->CurrentMessage();
		long key = msg->FindInt32("key");
		if (1) //msg->Error() == B_NO_ERROR)
			switch (key)
			{
				case B_F1_KEY:		touche = 1;	break;
				case B_F2_KEY:		touche = 2;	break;
				case B_F3_KEY:		touche = 3;	break;
				case B_F4_KEY:		touche = 4;	break;
				case B_F5_KEY:		touche = 5;	break;
				case B_F6_KEY:		touche = 6;	break;
				case B_F7_KEY:		touche = 7;	break;
				case B_F8_KEY:		touche = 8;	break;
			}
	}
	else
	 	switch(beKeyCode)
		{
			case 'F':	case 'f':	case '1':	touche = 1;	break;
			case 'U':	case 'u':	case '2':	touche = 2;	break;
			case 'C':	case 'c':	case '3':	touche = 3;	break;
			case 'R':	case 'r':	case '4':	touche = 4;	break;
			case 'E':	case 'e':	case '5':	touche = 5;	break;
			case 'M':	case 'm':	case '6':	touche = 6;	break;
			case 'L':	case 'l':	case '7':	touche = 7;	break;
			case B_ESCAPE:			case '8':	touche = 8;	break;
		}

	if (touche)
		gThreadMoteur->postMessage(gThreadMoteur, kMsgArme, touche-1, NULL);

} // end of keyDown for CMoteur


//---------------------------------------------------------------------------


//***************************************************************************
void CMoteur::changementArme(long code)
//***************************************************************************
{
long i,x;

	switch(code)
	{
		case 0:
			mArme = kFusil;
			break;
		case 1:
			mArme = kUzi;
			break;
		case 2:
			//mArme = kMine;
			mArme = kExplose;
			break;
		case 3:
			mArme = kElectrocution;			
			break;
		case 4:
			mArme = kRouleau;
			mRouleauX = mScrollX;
			mRouleauY = KSY;
			if (mMouseCode == B_INSIDE_VIEW) mRouleauY = mMouseY;
			if (mRouleauY > KSY-64) mRouleauY = mScrollY+(rand()*(480-128-64))/(RAND_MAX+1);
			if (mRouleauY > 64) mRouleauY-=64;
			break;
		case 5:
			mArme = kCoca;
			mCocaX = mScrollX;
			mCocaY = 0;
			if (mMouseCode == B_INSIDE_VIEW) mCocaX = mMouseX;
			if (mMouseY > KSY-64 || mCocaX > KSX-64) mCocaX = mScrollX+(rand()*(640-64))/(RAND_MAX+1);
			break;
		case 6:
			mArme = kExplose;
			break;
		case 7:
			be_app->PostMessage(B_QUIT_REQUESTED);
			break;
	}

	// raffiche les armes
	// commence par remettre le fond
	gVideo->blitSpriteMask(0, 0, K_PANEL_BAS, 1);

	// place toutes les armes...
	for(i=0, x=0; i<4; i++, x+=64)
		//if (i!=2)
			gVideo->blitSpriteMask(x, 0, i+(i == code ? K_OUTILS_ACTIF : K_OUTILS_NORMAL), 1);
	for(i=4, x=0; i<7; i++, x+=64)
		//if (i!=5 && i!=6)
			gVideo->blitSpriteMask(x,64, i+(i == code ? K_OUTILS_ACTIF : K_OUTILS_NORMAL), 1);
	// et drapeau blanc escape
	gVideo->blitSpriteMask(64*3, 64, K_OUTILS_NORMAL + 7, 1);
	// redraw le tout sur l'ecran
	gVideo->redraw(2);

} // end of changementArme for CMoteur



//***************************************************************************
void CMoteur::redrawArme(void)
//***************************************************************************
{
	gThreadMoteur->postMessage(gThreadMoteur, kMsgRedraw, 0, NULL);
} // end of redrawArme for CMoteur



//***************************************************************************
void CMoteur::tryScroll(void)
//***************************************************************************
{
	if (mMouseCode == B_INSIDE_VIEW)
	{
		long x1,y1,x2,y2;
		x1 = mScrollX;
		y1 = mScrollY;
		x2 = mMouseX-mScrollX;
		y2 = mMouseY-mScrollY;

		if (x2 < 64 && x1 > 0)	{ x1 -= 10; if (x1 < 0) x1 = 0; }
		else if (x2 > 640-64 && x1 < KSX-10-640)	x1 += 10;
		if (y2 < 64 && y1 > 0)	{ y1 -= 10; if (y1 < 0) y1 = 0; }
		else if (y2 > 480-128-64 && y1 < KSY-10-(480-128))	y1 += 10;
		if (x1 != mScrollX || y1 != mScrollY)
		{
			mScrollX = x1;
			mScrollY = y1;
			mMouseX = mScrollX+x2;
			mMouseY = mScrollY+y2;
			gVideo->setScroll(x1, y1);
		}
	}
} // end of tryScroll for CMoteur


//***************************************************************************
void CMoteur::tirFusil(long x, long y)
//***************************************************************************
{
long i,dx,dy;
STortue *tortue = mTortue;

	mNbAction++;
	mRedrawPanel = true;

	for(i=0; i<mNbTortue; i++, tortue++)
		if (		tortue->vivante
				&&	(x >= tortue->x && x < tortue->x+32)
				&&	(y >= tortue->y && y < tortue->y+32))
		{
			mNbNerd--;
			mRedrawPanel = true;
			tortue->vivante = 0;
			tortue->vit = 0;
			makeAhSound();
			break;
		}

	// affole les tortues dans les environs (+/- 96 pixels)
	tortue = mTortue;
	for(i=0; i<mNbTortue; i++, tortue++)
		if (		tortue->vivante
				&&	(tortue->x >= x-K_RANGE_FUSIL-16 && tortue->x <= x+K_RANGE_FUSIL-16)
				&&	(tortue->y >= y-K_RANGE_FUSIL-16 && tortue->y <= y+K_RANGE_FUSIL-16))
		{
			// une tortue immobile cherche a se barer dare dare
			if (!tortue->vit) tortue->vit = 4;
			// et une autre a courrir encore plus vite !
			else tortue->vit = max(tortue->vit*1.5, 12);


			// le tout si possible dans la direction opposee
			dx = x - tortue->x-16;
			dy = y - tortue->y-16;
			tortue->dir = K_PI + atan2((double)dy, (double)dx);
		}


} // end of tirFusil for CMoteur


//***************************************************************************
void CMoteur::tirExplose(long x, long y)
//***************************************************************************
{
long i,dx,dy;
STortue *tortue = mTortue;

	mNbAction++;
	mRedrawPanel = true;

	for(i=0; i<mNbTortue; i++, tortue++)
		if (		tortue->vivante
				&&	((long)tortue->x+16 >= x-K_RANGE_EXPLOSE && (long)tortue->x-16 <= x+K_RANGE_EXPLOSE)
				&&	((long)tortue->y+16 >= y-K_RANGE_EXPLOSE && (long)tortue->y-16 <= y+K_RANGE_EXPLOSE))
		{
			mNbNerd--;
			mRedrawPanel = true;
			tortue->vivante = 0;
			if (!tortue->vit) tortue->vit = 4;
			else tortue->vit = max(tortue->vit*1.5, 12);
			dx = x - tortue->x-16;
			dy = y - tortue->y-16;
			tortue->dir = K_PI + atan2((double)dy, (double)dx);
			tortue->spriteMort = 1;
			makeAhSound();
		}
} // end of tirExplose for CMoteur


//***************************************************************************
void CMoteur::electrocuter(long x, long y)
//***************************************************************************
{
long i;
STortue *tortue = mTortue;

	mNbAction++;
	mRedrawPanel = true;

	for(i=0; i<mNbTortue; i++, tortue++)
		if (		tortue->vivante
				&&	(x >= tortue->x && x < tortue->x+32)
				&&	(y >= tortue->y && y < tortue->y+32))
		{
			tortue->elec = !tortue->elec;
			tortue->vivante--;
			tortue->vit = 0;
			tortue->spriteMort = K_TORTUE_EMORTE-K_TORTUE_MORTE;
			if (tortue->vivante < 1) { mNbNerd--; mRedrawPanel = true; makeAhSound(); }
			break;
		}

} // end of electrocuter for CMoteur


//***************************************************************************
void CMoteur::avanceRouleau(void)
//***************************************************************************
{
long i,x1,y1,x2,y2;
STortue *tortue = mTortue;

	x1 = mRouleauX+32;
	y1 = mRouleauY+32;
	x2 = x1+32;
	y2 = y1+32;
	for(i=0; i<mNbTortue; i++, tortue++)
		if (		tortue->vivante
				&&	((x1 >= tortue->x && x1 < tortue->x+32) && (y1 >= tortue->y && y1 < tortue->y+32)
					|| (x2 >= tortue->x && x2 < tortue->x+32) && (y2 >= tortue->y && y2 < tortue->y+32)))
		{
			mNbNerd--;
			mRedrawPanel = true;
			tortue->vivante=0;
			tortue->vit = 0;
			tortue->spriteMort = 2;
			makeAhSound();
			break;
		}

	mRouleauX+=K_VITESSE_ROULEAU;
	if (mRouleauX > mScrollX + 640 || mRouleauX > KSX-64)
	{
		changementArme(0);	// reprend le fusil

		mNbAction++;
		mRedrawPanel = true;
	}

} // end of avanceRouleau for CMoteur


//***************************************************************************
void CMoteur::avanceCoca(void)
//***************************************************************************
{
long i,x1,y1,x2,y2;
STortue *tortue = mTortue;

	x1 = mCocaX+32;
	y1 = mCocaY+32;
	x2 = x1+32;
	y2 = y1+32;
	for(i=0; i<mNbTortue; i++, tortue++)
		if (		tortue->vivante
				&&	((x1 >= tortue->x && x1 < tortue->x+32) && (y1 >= tortue->y && y1 < tortue->y+32)
					|| (x2 >= tortue->x && x2 < tortue->x+32) && (y2 >= tortue->y && y2 < tortue->y+32)))
		{
			mNbNerd--;
			mRedrawPanel = true;
			tortue->vivante=0;
			tortue->vit = 0;
			tortue->spriteMort = 2;
			makeAhSound();
			break;
		}

	mCocaY+=K_VITESSE_COCA;
	if (mCocaY > mScrollY + 480-128 || mCocaY > KSY-64)
	{
		changementArme(0);	// reprend le fusil
		mNbAction++;
		mCocaY = 0;
		mRedrawPanel = true;
	}

} // end of avanceCoca for CMoteur


//---------------------------------------------------------------------------


//***************************************************************************
void CMoteur::oneFrame(void)
//***************************************************************************
{
	gVideo->clearScreen(1);
	bougeTortues(mSpriteOffset);
	mSpriteOffset = !mSpriteOffset;
	gVideo->redraw(1);
	tryScroll();

	if (mRedrawPanel)
	{
		gVideo->setScore(mNbNerd, mNbAction);
		gVideo->drawScore();
		gVideo->redraw(2);
		mRedrawPanel=false;
	}
} // end of oneFrame for CMoteur


//***************************************************************************
void CMoteur::bougeTortues(ULONG offset)
//***************************************************************************
{
double ddir, dvit;
long dir;
long x,y, x2,y2;
double vx,vy;
long i;
long index;
STortue *tortue = mTortue;
long vitmax = 5+(rand()*8)/(RAND_MAX+1);


	for(i=0; i<mNbTortue; i++, tortue++)
	{
		x = tortue->x;
		y = tortue->y;
		if (tortue->vivante && tortue->elec)
		{
			// tortue qui se fait electrocuter
			gVideo->blitSpriteMask(x, y, K_TORTUE_ELEC+offset);
			tortue->vivante--;
			if (mArme != kElectrocution) tortue->elec = false;
			if (tortue->vivante<1)
			{
				mNbNerd--;
				mRedrawPanel = true;
				makeAhSound();
			}
		}
		else if (tortue->vivante)
		{
			// tortue qui coure ou marche normalement
			dvit = tortue->vit;

			if (dvit > vitmax)
			{
				// une tortue essouflee ralenti progressivement
				dvit--;
				tortue->vit = (dvit < 0.0 ? 0.0 : dvit);
			}
			else if (dvit < 1.0)
			{
				// elle a eu le temps de se reposer, elle repart au galot
				dvit+=3;
				tortue->vit = (dvit < 0.0 ? 0.0 : dvit);
			}

			if (dvit > 0.0)
			{
				// tortue qui fretille dans une direction
				ddir = tortue->dir;
				vx = cos(ddir);
				vy = sin(ddir);
				dir = ((long)((ddir+K_PI/4.0)*(2.0/K_PI))) & 0x3;

				//printf("[%3d] <vx vy> %f %f -- <dir vit> %f %f\n", i, vx, vy, ddir, dvit);

				x2 = tortue->x + dvit * vx;
				y2 = tortue->y + dvit * vy;
	
				if (x2 < 0 || y2 < 0 || x2 >= KSX-32 || y2 >= KSY-32)
				{
					double dir2;
					if (x2 < 0 || x2 >= KSX-32) dir2 = (K_2PI-(ddir+K_PI2))-K_PI2;
					if (y2 < 0 || y2 >= KSY-32) dir2 = K_2PI-ddir;
					tortue->dir = (dir2 < 0.0 ? dir2+K_2PI : dir2);
					x2=x;
					y2=y;
				}
	
				tortue->x = x2;
				tortue->y = y2;
				index = offset+mSpriteDir[dir];
				gVideo->blitSpriteMask(x2, y2, index);
			}
			else
			{
				// tortue qui fait du surplace
				gVideo->blitSpriteMask(x, y, K_TORTUE_FIXE+offset);
			}
		}
		else
		{
			if (tortue->draw)
			{
				// tortue morte
				dvit = tortue->vit;
				if (dvit > 0.0)
				{
					// tortue qui fretille dans une direction
					ddir = tortue->dir;
					vx = cos(ddir);
					vy = sin(ddir);
					x2 = tortue->x + dvit * vx;
					y2 = tortue->y + dvit * vy;
		
					if (x2 >= 0 && y2 >= 0 && x2 < KSX-32 && y2 < KSY-32)
					{
						tortue->x = x2;
						tortue->y = y2;
						x = x2;
						y = y2;
					}
					tortue->vit--;
				}
	
				gVideo->blitSpriteMask(x, y, K_TORTUE_MORTE+tortue->spriteMort);
				
				if (tortue->vit <= 0)
				{
					tortue->draw = FALSE;
					gVideo->blitSpriteFond(x, y, K_TORTUE_MORTE+tortue->spriteMort);
				}
			}
		}
	}

	if (mArme == kRouleau)
		gVideo->blitSpriteMask(mRouleauX, mRouleauY, K_ROULEAU+offset);
	else if (mArme == kCoca)
		gVideo->blitSpriteMask(mCocaX, mCocaY, K_COCA);

	if (mMouseButton)
	{
		x = mMouseX-16;
		y = mMouseY-16;
		if (x < 0) x=0;
		if (y < 0) y=0;
		if (x > KSX-32) x=KSX-32;
		if (y > KSY-32) y=KSY-32;
		gVideo->blitSpriteMask(x, y, K_TIR);
	}

} // end of bougeTortues for CMoteur


//---------------------------------------------------------------------------

// eoc
