/********************
*	CInterface.h	*
********************/

#ifndef INC_CINTERFACE
#define INC_CINTERFACE


class CIRect
//**********
{
public:
	CIRect(){ curFocus=NULL; }
	void enable(void){ flag&=(~RECTF_DISABLED); }
	void disable(void){ flag|=RECTF_DISABLED; }
	void getFocus(void);
	void looseFocus(void);
	BOOL isUnderCursor(ULONG x,ULONG y);
protected:
	ULONG x,y;			// Position & size
	ULONG w,h;
	ULONG id;			// Identifiant
	UBYTE flag;			// RECTF_DISABLED ou pas
private:
	static CIRect *curFocus;
};

class CIButton:CIRect
//*******************
{
public:
	BOOL init(ULONG x,ULONG y,ULONG w,ULONG h,ULONG id,ULONG flag,
			ULONG status,ULONG spriteID,CHAR key);
	void redraw(void);
protected:
	ULONG status;		// BUTF_DOWN, BUTF_CHECK, BUTF_NOTUP, BUTF_NOTDOWN
	ULONG spriteID;	// ID du sprite de spriteGrabber
	CHAR  key;			// rappel clavier
};

class CIList:CIRect
//*****************
{
public:
	BOOL init(ULONG x,ULONG y,ULONG w,ULONG h,ULONG id,ULONG flag,ULONG status);
	void redraw(void);
protected:
	ULONG status;
	ULONG firstItem;
	ULONG nbItem;
	ULONG nbLines;
	ULONG curItem;
	CHAR data[MAX_LIST_ENTRY][MAX_LINE_LEN];
};

class CInterface
//**************
{
public:
	CInterface();
	~CInterface();
	BOOL init(void);
	void setPannel(ULONG id);
	void redraw(void);
protected:
	void createLayout(void);
	void addButton(ULONG,ULONG,ULONG,ULONG,ULONG,ULONG,ULONG,ULONG,CHAR);
	void addList(ULONG,ULONG,ULONG,ULONG,ULONG,ULONG,ULONG);
	ULONG nbButton;
	ULONG nbList;
	ULONG lastCommon;			// Dernier bouton affiche dans tous les cas
	ULONG firstBut,lastBut;		// Premier bouton du panneau courant
	ULONG firstList,lastList;	// Dernier """"""""""""""""""""""""
	CIButton *button;			// Devinez...
	CIList *list;
};

#endif

/* eof */