 /* 
  * UAE - The Un*x Amiga Emulator
  * 
  * Memory access functions
  *
  * Copyright 1996 Bernd Schmidt
  */

static __inline__ ULONG do_get_mem_long(ULONG *a)
{
#ifdef LITTLE_ENDIAN
	ULONG x = *a;
	return (x >> 24) | (x >> 8) & 0xff00 | (x << 8) & 0xff0000 | (x << 24);
#else
	return *a;
#endif
}

static __inline__ UWORD do_get_mem_word(UWORD *a)
{
#ifdef LITTLE_ENDIAN
	UWORD x = *a;
	return (x >> 8) | (x << 8);
#else
	return *a;
#endif
}

static __inline__ UBYTE do_get_mem_byte(UBYTE *a)
{
	return *a;
}

static __inline__ void do_put_mem_long(ULONG *a, ULONG v)
{
#ifdef LITTLE_ENDIAN
	*a = (v >> 24) | (v >> 8) & 0xff00 | (v << 8) & 0xff0000 | (v << 24);
#else
	*a = v;
#endif
}

static __inline__ void do_put_mem_word(UWORD *a, UWORD v)
{
#ifdef LITTLE_ENDIAN
	*a = (v >> 8) | (v << 8);
#else
	*a = v;
#endif
}

static __inline__ void do_put_mem_byte(UBYTE *a, UBYTE v)
{
	*a = v;
}

#define call_mem_get_func(func, addr) ((*func)(addr))
#define call_mem_put_func(func, addr, v) ((*func)(addr, v))

#undef USE_MAPPED_MEMORY
#undef CAN_MAP_MEMORY
#undef NO_INLINE_MEMORY_ACCESS
#undef MD_HAVE_MEM_1_FUNCS

