// =============================================================================
//	sample.h -- Sample Application for Red 1.0
// =============================================================================

#include <Application.h>
#include <List.h>
#include <Window.h>
#include <Menu.h>
#include <MenuItem.h>
#include <Button.h>

// -----------------------------------------------------------------------------
//	SApplication
// -----------------------------------------------------------------------------

class SApplication : public BApplication {
public:
						SApplication(const char *signature);
};

// -----------------------------------------------------------------------------
//	SIcons
// -----------------------------------------------------------------------------

class SIcons {
public:
						SIcons();
		const BBitmap	*Bitmap(int32 index) const;				

protected:
		BList			mList;
};

// -----------------------------------------------------------------------------
//	SWindow
// -----------------------------------------------------------------------------

class SWindow : public BWindow {
public:
						SWindow(
							BRect			frame,
							const char		*title, 
							window_type		type,
							uint32			flags,
							uint32			workspace = B_CURRENT_WORKSPACE);
protected:
virtual	bool			QuitRequested();
};

// -----------------------------------------------------------------------------
//	SMenu
// -----------------------------------------------------------------------------

class SMenu : public BMenu {
public:
						SMenu(
							const char		*title,
							menu_layout		layout = B_ITEMS_IN_COLUMN);
};

// -----------------------------------------------------------------------------
//	SMenuItem
// -----------------------------------------------------------------------------

class SMenuItem : public BMenuItem {
public:
						SMenuItem(
							const char		*label,
							BMessage		*message,
							const BBitmap	*bitmap,
							char			shortcut = 0,
							uint32			modifiers = 0);
protected:
		const BBitmap	*mBitmap;
		
virtual	void			DrawContent();
};

// -----------------------------------------------------------------------------
//	SButton
// -----------------------------------------------------------------------------

class SButton : public BButton {
public:
						SButton(
							BRect			frame,
							const char		*name,
							const BBitmap	*bitmap, 
							BMessage		*message,
							uint32			resizeMask = B_FOLLOW_LEFT | B_FOLLOW_TOP, 
							uint32			flags = B_WILL_DRAW | B_NAVIGABLE); 
protected:
		const BBitmap	*mBitmap;
		
virtual	void			Draw(BRect updateRect);
};
