#! /bin/env python
""" Check various email accounts.

This script, based on a shell script from The BeOS Bible, sets up the
E-mail preferences application for an email account and checks for new
mail.

This is useful is you have more than one email account; E-mail only
lets you use one at a time, but you can use scripting to take care of
the drudgery of fixing up the settings and hitting the "Check Now" button.
"""

from BeOS.hey import Hey
import sys

# The accounts we know about.
#
# It's a dictionary indexed by account name; inside is a tuple with:
# - POP user name
# - POP password
# - POP host
# - SMTP host
# - real name
# - reply-to address
#
# NOTE: Some.net.com doesn't exist, AFAIK.  These also aren't real
#       accounts or passwords.
accounts = {
	"poe" : ( "poe", "claws", "pop.some.net.com", "smtp.some.net.com",
			  "Poe (Lord of the Carpet)", "poe@cats.net.com" ),

	"byron" : ( "byronman", "canteloupe", "pop.some.net.com",
				"smtp.some.net.com", "Byron (Baddest cat in the land)",
				"byron@cats.net.com" ),

	"meaghan" : ( "meggie", "furball", "pop.some.net.com",
				  "smtp.some.net.com", "Meaghan the Cutie",
				  "meaghan@cats.net.com" ),

	"chris" : ( "chrish", "funkburg3r", "pop", "smtp",
				"Chris Herborth", "chrish@qnx.com" ),

	"lynette" : ( "lawh", "semprini", "pop", "smtp",
				  "Lynette Woodward-Herborth", "lynette@some.net.com" ),
}

def main():
	# Check to see if we've got the right number of arguments; if there
	# isn't exactly one, we're out of here.
	#
	# So, why check against 2?  Well, the first item is the program name...
	if len( sys.argv ) != 1:
		print "usage: check_mail.py account"
		sys.exit( 1 )

	# Now set up the various interesting bits based on the given
	# account name:
	try:
		( pop_user_name, pop_password, pop_host, smtp_host, real_name, 
			reply_to ) \
			= accounts[sys.argv[1]]
	except KeyError:
		print sys.argv[1], "isn't a valid email account"
		sys.exit( 2 )

	# Create a Hey object for talking to E-mail; this will launch it
	# if it's not already running.
	email = Hey( "application/x-vnd.Be-mprf" )
	
	# Now we can set the fields based on our account info.
	print "Setting up email preferences for account:", sys.argv[1]

	spec = email.Specifier( "Value of View 0 of View 0 of Window 0" )
	email.SetString( spec, pop_user_name )

	spec = email.Specifier()
	spec.Add( "Value" )
	spec.Add( "View", 1 )
	spec.Add( "View", 0 )
	spec.Add( "Window", 0 )
	email.SetString( spec, pop_password )

	# Now that you've seen it both ways, I'll just use the "hey" style,
	# since it's a bit shorter.  They do the same thing though.
	spec = email.Specifier( "Value of View 2 of View 0 of Window 0" )
	email.SetString( spec, pop_host )

	spec = email.Specifier( "Value of View 3 of View 0 of Window 0" )
	email.SetString( spec, smtp_host )

	spec = email.Specifier( "Value of View 10 of View 0 of Window 0" )
	email.SetString( spec, real_name )

	spec = email.Specifier( "Value of View 11 of View 0 of Window 0" )
	email.SetString( spec, reply_to )

	# Now we simulate a click on the Check Now button:
	spec = email.Specifier()
	spec.Add( "Value" )
	spec.Add( "View", 16 )
	spec.Add( "View", 0 )
	spec.Add( "Window", 0 )
	email.SetInt( spec, 1 )

	# That's all folks!

if __name__ == "__main__":
	main()
