/* messages.cpp
	Guile interface to BeOS BMessage and BMessenger
*/
extern "C" {
#include <libguile.h>
#include <libguile/dynl.h>
#include <libguile/numbers.h>
};
//#include <libguile/gobjects.h>
#include "messages.h"

SCM_PROC(s_make_message, "make-message", 1, 0, 0, scm_make_message);

SCM
scm_make_message (SCM wn)
{
	SCM res;
	GMessage *msg;
	
	long w = scm_num2long(wn, (char *)SCM_ARG1, s_make_message);
	msg = new GMessage(w);
	if (! msg) {
		return SCM_BOOL_F;
	}
	return msg->MakeScm();
}	

SCM_PROC(s_make_messenger, "make-messenger", 1, 0, 0, scm_make_messenger);

SCM
scm_make_messenger (SCM sig)
{
	SCM res;
	GMessenger *msgr;
	
	SCM_ASSERT (SCM_NIMP(sig) && SCM_ROSTRINGP(sig),
		sig, SCM_ARG1, s_make_messenger);

	msgr = new GMessenger(SCM_CHARS(sig));
	return msgr->MakeScm();
}


SCM_PROC(s_message_add_specifier, "message-add-specifier", 2, 2, 0, scm_message_add_specifier);

SCM
scm_message_add_specifier (SCM mn, SCM pn, SCM ixn, SCM rgn)
{
	GMessage *msg = cast_as((GObject *)SCM_CDR(mn), GMessage);
	
	SCM_ASSERT(msg, mn, SCM_ARG1, s_message_add_specifier);
	SCM_ASSERT (SCM_NIMP(pn) && SCM_ROSTRINGP(pn),
		pn, SCM_ARG2, s_message_add_specifier);
	if (SCM_INUMP(ixn)) {
		if (SCM_INUMP(rgn)) {
//			fprintf(stderr, " AddSpecifier\trange\n");
			msg->d.AddSpecifier(SCM_CHARS(pn), SCM_INUM(ixn), SCM_INUM(rgn));
		}
		else {
//			fprintf(stderr, " AddSpecifier\tindex %d\n", SCM_INUM(ixn));
			msg->d.AddSpecifier(SCM_CHARS(pn), SCM_INUM(ixn));
		}
	}
	else {
		if (SCM_NIMP(ixn) && SCM_ROSTRINGP(ixn)) {
//			fprintf(stderr, " AddSpecifier\tname\n");
			msg->d.AddSpecifier(SCM_CHARS(pn), SCM_CHARS(ixn));
		}
		else {	 	
//			fprintf(stderr, " AddSpecifier\tdirect\n");
			msg->d.AddSpecifier(SCM_CHARS(pn));
		}
	}
	return mn;
}


SCM_PROC(s_message_add_data, "message-add-data", 5, 0, 0, scm_message_add_data);

SCM
scm_message_add_data (SCM mn, SCM name, SCM type, SCM data, SCM size)
{
	GMessage *msg = cast_as((GObject *)SCM_CDR(mn), GMessage);
	void *obj = (void *)SCM_CDR(data);
	
	SCM_ASSERT(msg, mn, SCM_ARG1, s_message_add_data);
	SCM_ASSERT (SCM_NIMP(name) && SCM_ROSTRINGP(name),
		name, SCM_ARG2, s_message_add_data);
	long ltype = scm_num2long(type, (char *)SCM_ARG3, s_message_add_data);
	SCM_ASSERT (SCM_INUMP(size), size, SCM_ARG5, s_message_add_data); 
	return msg->d.AddData(SCM_CHARS(name), ltype, obj, SCM_INUM(size)) == B_OK ?
		mn : SCM_BOOL_F;
}


SCM_PROC(s_message_add_object, "message-add-object", 4, 0, 0, scm_message_add_object);

SCM
scm_message_add_object (SCM mn, SCM name, SCM type, SCM data)
{
	GMessage *msg = cast_as((GObject *)SCM_CDR(mn), GMessage);
	GObject *obj = (GObject *)SCM_CDR(data);
	
	SCM_ASSERT(msg, mn, SCM_ARG1, s_message_add_object);
	SCM_ASSERT (SCM_NIMP(name) && SCM_ROSTRINGP(name),
		name, SCM_ARG2, s_message_add_data);
	long ltype = scm_num2long(type, (char *)SCM_ARG3, s_message_add_object);
//	SCM_ASSERT (SCM_INUMP(size), size, SCM_ARG5, s_bmessage_add_object); 
	return msg->d.AddData(SCM_CHARS(name), ltype, obj->Data(), obj->Size()) == B_OK ? mn : SCM_BOOL_F;
}


SCM_PROC(s_message_add_number, "message-add-number", 3, 0, 0, scm_message_add_number);

SCM
scm_message_add_number (SCM mn, SCM name, SCM num)
{
	GMessage *msg = cast_as((GObject *)SCM_CDR(mn), GMessage);
	
	SCM_ASSERT(msg, mn, SCM_ARG1, s_message_add_number);
	SCM_ASSERT(SCM_NIMP(name) && SCM_ROSTRINGP(name),
		name, SCM_ARG2, s_message_add_number);

	if (SCM_INEXP(num)) {
		double dbl = scm_num2dbl(num, s_message_add_number);
		return msg->d.AddFloat(SCM_CHARS(name), (float)dbl) == B_OK ? mn : SCM_BOOL_F;
	}
	else if (SCM_INUMP(num)) {
		return msg->d.AddInt32(SCM_CHARS(name), SCM_INUM(num)) == B_OK ? mn : SCM_BOOL_F;
	}
	else {
	  	SCM_ASSERT (false, num, SCM_ARG3, s_message_add_number);
	  	return SCM_BOOL_F;
	}
}	

SCM_PROC(s_message_find_int32, "message-find-int32", 2, 0, 0, scm_message_find_int32);

SCM
scm_message_find_int32(SCM smsg, SCM sname)
{
	int32 n;
	GMessage *msg = cast_as((GObject *)SCM_CDR(smsg), GMessage);
	
	SCM_ASSERT(msg, smsg, SCM_ARG1, s_message_find_int32);
	SCM_ASSERT(SCM_NIMP(sname) && SCM_ROSTRINGP(sname),
		sname, SCM_ARG2, s_message_find_int32);

	if (msg->d.FindInt32(SCM_CHARS(sname), &n) != B_OK) {
		/* (what is the best way to inform the app of this condition? probably throwing an
			exception: ) */
		SCM_ASSERT(false, sname, "item not found in message",  s_message_find_int32);
	}
	
	return scm_long2num(n);
}		
		


SCM_PROC(s_messenger_send_message, "messenger-send-message", 2, 0, 0, scm_messenger_send_message);

SCM
scm_messenger_send_message (SCM smsgr, SCM smsg)
{
	GMessenger *msgr = cast_as((GObject *)SCM_CDR(smsgr), GMessenger);
	GMessage *msg = cast_as((GObject *)SCM_CDR(smsg), GMessage);
	SCM_ASSERT(msgr, smsgr, SCM_ARG1, s_messenger_send_message);
	SCM_ASSERT(msg, smsg, SCM_ARG2, s_messenger_send_message);

	BMessage breply;
	status_t err = msgr->d.SendMessage(&msg->d, &breply);
	if (err == B_OK) {
		GMessage *greply = new GMessage(breply);
		return greply->MakeScm();
	}
	else {
		return SCM_BOOL_F;
	}
}

/*
size_t
GMessenger::Size(void)
{
	return sizeof(BMessenger);
}
*/

void
scm_init_messages (void)
{
#if 0
#include "messages.x"
#else
 scm_make_gsubr (s_make_message, 1, 0, 0, (SCM (*) (void)) scm_make_message);
 scm_make_gsubr (s_make_messenger, 1, 0, 0, (SCM (*) (void)) scm_make_messenger);
 scm_make_gsubr (s_message_add_specifier, 2, 2, 0, (SCM (*) (void)) scm_message_add_specifier);
 scm_make_gsubr (s_message_add_data, 5, 0, 0, (SCM (*) (void)) scm_message_add_data);
 scm_make_gsubr (s_message_add_object, 4, 0, 0, (SCM (*) (void)) scm_message_add_object);
 scm_make_gsubr (s_message_add_number, 3, 0, 0, (SCM (*) (void)) scm_message_add_number);
 scm_make_gsubr (s_message_find_int32, 2, 0, 0, (SCM (*) (void)) scm_message_find_int32);
 scm_make_gsubr (s_messenger_send_message, 2, 0, 0, (SCM (*) (void)) scm_messenger_send_message); 
#endif
}

#pragma export on
void
scm_init_beos_messages_module()
{
	scm_register_module_xxx("beos messages", scm_init_messages);
}
#pragma export reset
