/* classes: h_files */

#ifndef ASYNCH
#define ASYNCH
/*	Copyright (C) 1995,1996,1997 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  */


#include "libguile/__scm.h"



#define SCM_ASYNCP(X) 	(scm_tc16_async == SCM_GCTYP16 (X))
#define SCM_ASYNC(X) 	((struct scm_async *)SCM_CDR (X))

struct scm_async
{
  int got_it;			/* needs to be delivered? */
  SCM thunk;			/* the handler. */
};



extern unsigned int scm_mask_ints;
extern SCM scm_gc_async;


extern void scm_async_click SCM_P ((void));
extern void scm_switch SCM_P ((void));
extern SCM scm_async SCM_P ((SCM thunk));
extern SCM scm_system_async SCM_P ((SCM thunk));
extern SCM scm_async_mark SCM_P ((SCM a));
extern SCM scm_system_async_mark SCM_P ((SCM a));
extern SCM scm_run_asyncs SCM_P ((SCM list_of_a));
extern SCM scm_noop SCM_P ((SCM args));
extern SCM scm_set_tick_rate SCM_P ((SCM n));
extern SCM scm_set_switch_rate SCM_P ((SCM n));
extern SCM scm_unmask_signals SCM_P ((void));
extern SCM scm_mask_signals SCM_P ((void));
extern void scm_init_async SCM_P ((void));

#endif  /* ASYNCH */
