/* -------------------------------------------------------------------

	Title:
		UGraph_Util

	Description:
		Misc graph utilities.

	Author:
		Stephen C. Wardlaw, M.D.
		Yale University School of Medicine
		462-CB Y-NHH
		20 York St.
		New Haven, CT  06504

	Edit History:
		25 October, 1995
			Adapted for MetroWerks C++
		17 May, 85
			First IBM version by author.

------------------------------------------------------------------- */

#include "UGraph_Util.h"
//#include <math.h>

// -------------------------------------------------------------------
void
UGraph_Util::AutoScale(AxisRecord &axis, double min, double max)
{
	int iter;
	
	if(min >= max) {
		return;
	}
	double span = ConvertDown((max-min)/10.0);	// Find a 'nice' number
	double tMax = ConvertUp(max);                // Find another 'nice' one
	
	while(tMax > max) {
		tMax = tMax - span;
	}
	
	while(tMax < max) {
		tMax = tMax + span;
	}  
	iter = 20;
	double tMin = tMax;
	while(tMin > min && iter > 0) {
		tMin = tMin - span;
		iter--;
	}
	// Special case handling for numbers close to zero *)
	if((min >= 0.0) && (tMin < 0.0)) {
		tMin = 0.0;
		tMax = tMin;
		while(tMax < max) {
			tMax = tMax + span;
		}
	}
	
   axis.max = tMax;
   axis.min = tMin;
   axis.ticInterval = span;
}		
// -------------------------------------------------------------------
//		Protected methods
// -------------------------------------------------------------------
// Convert to value LOWER than 'val'.
double
UGraph_Util::ConvertDown(double val)
{	
	int exp;
	Boolean isNeg;
	
	if(val == 0.0) {
		return 0.0;
	}
	
	isNeg = val < 0.0;
	val = fabs(val);
	exp = 0;
	
	while(val < 1.0) {
		exp++;
		val = val * 10.0;
	}
	while(val > 10.0) {
		exp--;
		val /= 10.0;
	}
	
	if(val < 1.5) {
		val = 1.0;
		
	} else if(val < 2.5) {
		val = 2.0;
		
	} else if(val < 7.5) {
		val = 5.0;
		
	} else {
		val = 10.0;
	}
	
	while(exp < 0) {
		exp++;
		val *= 10.0;
	}
	
	while(exp > 0) {
		exp--;
		val /= 10.0;
	}
	if(isNeg) {
		val *= -1.0;
	}
	return val;
}
// -------------------------------------------------------------------
// Convert to value HIGHER than 'val'.
double
UGraph_Util::ConvertUp(double val)
{
	int exp;
	Boolean isNeg;
	
	if(val == 0.0) {
		return 0.0;
	}
	
	isNeg = val < 0.0;
	val = fabs(val);
	exp = 0;
	while(val < 1.0) {
		exp++;
		val *= 10.0;
	}
	
	while(val > 10.0) {
		exp--;
		val /= 10.0;
	}
		
	if(val <= 1.0) {
		val = 1.0;
		
	} else if(val <= 2.0) {
		val = 2.0;
		
	} else if(val <= 2.5) {
		val = 2.5;
		
	} else if(val <= 5.0) {
		val = 5.0;
	
	} else {
		val = 10.0;
	}
		
	while(exp < 0) {
		exp++;
		val *= 10.0;
	}
	
	while(exp > 0) {
		exp--;
		val /= 10.0;
	}
	
	if(isNeg) {
		val *= -1.0;
	}
	return val;
}
// -------------------------------------------------------------------
							  							  
	
