/* ------------------------------------------------------------------ 

	Title: GDPolyPlot

	Description:  A class which puts a graph window to demonstrate
		polynomial data fitting and cubic spline interpolation

	Author :
		Stephen Wardlaw, M.D.
		Yale University School of Medicine
		20 York St.
		New Haven, CT  06504

	Edit History:
		27 Dewcember, 1997
			Adapted for BeOS
		31 March, 1995
			Broke original into three separate classes
		09 Dec 94
			Much alteration for new PP and other classes
		08 May 94
			Added cubic fit routine
		22 Mar 94
			Created for CW C++ from an earlier M2 program
		
------------------------------------------------------------------ */ 

#pragma once

#include "GDData.h"
#include "WGStdGraph.h"
#include "WGOdometer.h"


class GDPolyPlot : public WGStdGraph {

	public:
	
		GDPolyPlot(BRect frame,  
					  const char* title	= "GDPolyPlot",
					  uint32 mode			= B_FOLLOW_ALL_SIDES,
					  uint32 flags			= B_WILL_DRAW | 
					  							  B_FULL_UPDATE_ON_RESIZE | 
												  B_FRAME_EVENTS); 
	virtual	
		~GDPolyPlot();
		
	void
		AttachOdometer(WGOdometer* theOdo) {mOdometer = theOdo;}	
	void
		LinkToData(GDData* theData);	
	virtual void
		MouseMoved(BPoint thePt, uint32 transit, const BMessage* theMesg);
	void
		RefreshPlot();
		
	protected:

	virtual void
		MouseDown(BPoint thePoint);
	virtual void
		Draw(BRect frame);
	
	GDData*		mData;
	WGOdometer*	mOdometer;
};
