// VCard Parser Classes
// Copyright 2002 Peter J. Goodeve
/***************************************************************
You are permitted to use this code for any purpose, provided that
the original author is acknowledged.
No warranty as to fitness for any particular purpose, nor responsibility
for any consequential damage, is expressed or implied.
****************************************************************/


#include <String.h>
#include <List.h>

class VCardItem {
	friend class VCard;
 private:	
	BString line;
	BList keys, texts;
 protected:
	VCardItem *next;	// picked chain
	bool used;
 public:
	VCardItem(BString &s) : line(s), used(false), next(NULL) {parse();}
	VCardItem(const char *s) : line(s) {parse();}
	~VCardItem() {clear();}
	VCardItem& operator =(const char *s) {clear(); line = s; parse(); return *this;}
	VCardItem& operator =(BString &s) {clear(); line = s; parse(); return *this;}
	void clear();
	bool parse();
	int32 numKeys() {return keys.CountItems();}
	int32 numTexts() {return texts.CountItems();}
	BString *key(int32 n=0) {return (BString *)keys.ItemAt(n);}
	BString *text(int32 n=0) {return (BString *)texts.ItemAt(n);}
	bool hasText(int32 n=0) {return text(n) && text(n)->Length() > 0;}
	const char *keyStr(int32 n=0) {return key(n)? key(n)->String() : NULL;}
	const char *textStr(int32 n=0) {return text(n)? text(n)->String() : NULL;}
	int32 findModifier(BString &m);
	void processed(bool yes=true) {used = yes;}
};

class VCard {
 private:
	BList items;
	enum {EMPTY, BUILDING, COMPLETE} state;
	VCardItem *picked;
 public:
	VCard() : state(EMPTY), picked(NULL) {}
	~VCard() {clear();}
	void clear();
	bool addLine(char *s);
	int32 numLines() {return items.CountItems();}
	VCardItem *line(int32 n) {return (VCardItem *)items.ItemAt(n);}
	int32 pick(char *keyspec);
	VCardItem * getPicked();
};

