#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int 	stacks, slices;

void	print_usage( char *name );


void	print_connection(	char *prefix,
							int x1, int y1,
							int x2, int y2 );


void	print_triangle_face(	char *prefix,
								int x1, int y1, int x2,
								int y2, int x3, int y3 );

void	print_usage( char *name )
{
	fprintf(stderr, "usage:\n%s <stacks> <slices> <prefix>\n", name );
	fprintf(stderr, "note:\tYou will probably want to edit the templates and\n" );
	fprintf(stderr, "\tdefinitions after you have created a new ellipsoid.\n" );
}

void	print_connection(	char *prefix,
							int x1, int y1,
							int x2, int y2 )
{
	printf("connection\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s\" }\n", prefix );
	printf(	"\tconnect\t\t{ \"%s %d_%d\", \"%s %d_%d\" }\n",
			prefix, x1, y1, prefix, x2, y2 );
	printf(	"\tlength\t\t{ | object{\"%s %d_%d\"}.position - object{\"%s %d_%d\"}.position | }\n", prefix, x1, y1, prefix, x2, y2 );
	printf(	"\tname\t\t{ \"%s %d_%d->%d_%d\" }\n",
			prefix, x1, y1, x2, y2 );
	printf("}\n");
	printf("\n");
}


void	print_triangle_face(	char *prefix,
								int x1, int y1, int x2,
								int y2, int x3, int y3 )
{
	printf("\ttriangle\n");
	printf("\t{\n");
	printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
	printf("\t\tmount\n");
	printf("\t\t{\n");
	printf("\t\t\tvertex\t{\"%s vx %d_%d\"},\n", prefix, x1, y1);
	printf("\t\t\tvertex\t{\"%s vx %d_%d\"},\n", prefix, x2, y2);
	printf("\t\t\tvertex\t{\"%s vx %d_%d\"}\n", prefix, x3, y3);
	printf("\t\t}\n");

	printf("\t\tdepend\t{ connection{ object{\"%s %d_%d\"}, object{\"%s %d_%d\"} } }\n", prefix, x1,y1, prefix, x2,y2 );
	printf("\t\tdepend\t{ connection{ object{\"%s %d_%d\"}, object{\"%s %d_%d\"} } }\n", prefix, x2,y2, prefix, x3,y3 );
	printf("\t\tdepend\t{ connection{ object{\"%s %d_%d\"}, object{\"%s %d_%d\"} } }\n", prefix, x3,y3, prefix, x1,y1 );

	printf("\t}\n");
	printf("\n");
}


int main( int argc, char* argv[] )
{	
	char 	*prefix;

	int 	x, z;
	double xcoord, ycoord, zcoord;

	FILE	*vertices;
	int		c;
	
	vertices = tmpfile();

	if( argc == 4 )
	{
		stacks	= atoi( argv[1] );
		slices	= atoi( argv[2] );
		prefix	= argv[3];
	}
	else
	{
		print_usage( argv[0] );
		return -1;
	}

	if( ( stacks < 2 ) || ( slices < 3 ) )
	{
		fprintf(stderr, "%s error: stacks must be > 1 and slices > 2.\n", argv[0]);
		print_usage( argv[0] );
		return -1;
	}

	printf("air\t\t\t{ 0.1 }\n");
	printf("dt\t\t\t{ 0.001 }\n");
	printf("\n");

	/* useful definitions */

	printf("### start of ellipsoid named -- %s -- ###\n", prefix);
	printf("\n");
	printf("\n");

	printf("# %s definitions\n", prefix);
	printf("# These definititions control the creation of the ellipsoid\n");
	printf("\n");

	printf("# orientation of the x-axis of the ellipsoid\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s x axis\" }\n", prefix);
	printf("\texpression\t{ vector { 1, 0, 0 } }\n");
	printf("}\n");
	printf("\n");
	
	printf("# orientation of the y-axis of the ellipsoid, or \"up\" vector.\n");
	printf("# This doesn't need to be orthogonal to the x axis.\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y axis\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 1, 0 } }\n");
	printf("}\n");
	printf("\n");

	
	printf("# width, height and depth\n");
	printf("\n");
	printf("constant real\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s width\" }\n", prefix);
	printf("\texpression\t{ 1 }\n");
	printf("}\n");
	printf("\n");
	printf("constant real\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s height\" }\n", prefix);
	printf("\texpression\t{ 1 }\n");
	printf("}\n");
	printf("\n");
	printf("constant real\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s depth\" }\n", prefix);
	printf("\texpression\t{ 1 }\n");
	printf("}\n");

	printf("# position of the center of the ellipsoid\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s position\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# velocity of the ellipsoid\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s velocity\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# angular velocity of the ellipsoid\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s angular velocity\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# pivot point for the angular velocity\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s pivot\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# (all of the vectors above are specified in the scene coordinate system)\n");

	printf("\n");
	printf("# end of definitions\n");
	printf("\n");
	printf("\n");

	/* templates */
	printf("# %s templates\n", prefix);
	printf("# These templates are used by the objects and connections of the block.\n");
	printf("# At least the radius should be changed to fit the spacing.\n");
	printf("\n");

	printf("template object\n");
	printf("{\n");
	printf("\tmass\t\t{ 10 }\n");
	printf("\tradius\t\t{ 0.2 }\n");
	printf("\tdamp\t\t{ 1E2 }\n");
	printf("\tk\t\t\t{ 1E5 }\n");
	printf("\ttolerance\t{ 0.1 }\n");
	printf("\tgsource\t\t{ false }\n");
	printf("\tgrecipient\t{ false }\n");
	printf("\tname\t\t{ \"%s\" }\n", prefix);
	printf("}\n");

	printf("\n");


	printf("template connection\n");
	printf("{\n");
	printf("\tdamp\t\t{ 5E2 }\n");
	printf("\tk\t\t\t{ 1E4 }\n");
	printf("\ttolerance\t{ 9E9 }\n");
	printf("\tname\t\t{ \"%s\" }\n", prefix);
	printf("}\n");

	printf("\n");


	printf("# %s calculations\n", prefix);

	printf("\n");

	printf("# From the definitions we can now calculate the unit vectors for the block\n");
	printf("# coordinate system. First we normalize the x vector to get the x unit vector.\n");
	printf("# Then we find the y axis vector component orthogonal to the x unit vector.\n");
	printf("# We do this by projecting the y axis vector on the x unit vector, and then\n");
	printf("# subtracting this from the original y axis vector. This vector is then normalized\n");
	printf("# to produce the y unit vector. We can the take the cross product of the x and y\n");
	printf("# unit vectors to produce the z unit vector. We now have a new orthonormal basis\n");
	printf("# we can build the block with.\n");
	printf("\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s x unit\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s x axis\"} / | constant vector {\"%s x axis\"} | }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y normalized\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s y axis\"} / | constant vector {\"%s y axis\"} | }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y ortho x\" }\n", prefix);
	printf("\texpression\t{\tconstant vector {\"%s y normalized\"} - constant vector {\"%s x unit\"} *\n", prefix, prefix);
	printf("\t\t\t\t\t( constant vector {\"%s y normalized\"} * constant vector {\"%s x unit\"} ) }\n", prefix, prefix );
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y unit\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s y ortho x\"} / | constant vector {\"%s y ortho x\"} | }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s z unit\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s x unit\"} x constant vector {\"%s y unit\"} }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("object\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s\" }\n", prefix);
	printf("\tposition {\tconstant vector{\"%s position\"} }\n", prefix );
	printf("\tname\t\t{ \"%s center\" }\n", prefix );
	printf("}\n");
	printf("\n");


	xcoord = 0;
	ycoord = 0;
	zcoord = 1;


	printf("object\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s\" }\n", prefix);

	printf("\tposition {\tconstant vector{\"%s position\"} + vector {\n", prefix, prefix);

	printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.x +\n", prefix, xcoord, prefix );
	printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.x +\n", prefix, ycoord, prefix );
	printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.x,\n", prefix, zcoord, prefix );

	printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.y +\n", prefix, xcoord, prefix );
	printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.y +\n", prefix, ycoord, prefix );
	printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.y,\n", prefix, zcoord, prefix );

	printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.z +\n", prefix, xcoord, prefix );
	printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.z +\n", prefix, ycoord, prefix );
	printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.z } }\n", prefix, zcoord, prefix );

	printf("\tvelocity {\tconstant vector{\"%s velocity\"} + constant vector{\"%s angular velocity\"} x\n", prefix, prefix);
	printf("\t\t\t\t( object{this}.position - constant vector{\"%s pivot\"} ) }\n", prefix);


	printf("\tname\t\t{ \"%s end1\" }\n", prefix );
	printf("}\n");
	printf("\n");


	xcoord = 0;
	ycoord = 0;
	zcoord = -1;

	printf("object\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s\" }\n", prefix);
	printf("\tposition {\tconstant vector{\"%s position\"} + vector {\n", prefix, prefix);

	printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.x +\n", prefix, xcoord, prefix );
	printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.x +\n", prefix, ycoord, prefix );
	printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.x,\n", prefix, zcoord, prefix );

	printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.y +\n", prefix, xcoord, prefix );
	printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.y +\n", prefix, ycoord, prefix );
	printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.y,\n", prefix, zcoord, prefix );

	printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.z +\n", prefix, xcoord, prefix );
	printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.z +\n", prefix, ycoord, prefix );
	printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.z } }\n", prefix, zcoord, prefix );


	printf("\tvelocity {\tconstant vector{\"%s velocity\"} + constant vector{\"%s angular velocity\"} x\n", prefix, prefix);
	printf("\t\t\t\t( object{this}.position - constant vector{\"%s pivot\"} ) }\n", prefix);


	printf("\tname\t\t{ \"%s end2\" }\n", prefix );
	printf("}\n");
	printf("\n");

	for(x = 0; x < stacks; x++)
	{
		for(z = 0; z < slices; z++)
		{
			xcoord = sin( (x+1)*(  M_PI / (stacks+1) ) ) * cos( z*(  (2.0*M_PI) / (slices) ) );
			ycoord = sin( (x+1)*(  M_PI / (stacks+1) ) ) * sin( z*(  (2.0*M_PI) / (slices) ) );
			zcoord = cos( (x+1)*(  M_PI / (stacks+1) ) );


			printf("object\n");
			printf("{\n");
			printf("\ttemplate\t{ \"%s\" }\n", prefix);
			printf("\tposition {\tconstant vector{\"%s position\"} + vector {\n", prefix, prefix);
			printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.x +\n", prefix, xcoord, prefix );
			printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.x +\n", prefix, ycoord, prefix );
			printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.x,\n", prefix, zcoord, prefix );

			printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.y +\n", prefix, xcoord, prefix );
			printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.y +\n", prefix, ycoord, prefix );
			printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.y,\n", prefix, zcoord, prefix );

			printf("\t\t\t\tconstant real{\"%s width\"} * %lf * constant vector{\"%s x unit\"}.z +\n", prefix, xcoord, prefix );
			printf("\t\t\t\tconstant real{\"%s height\"} * %lf * constant vector{\"%s y unit\"}.z +\n", prefix, ycoord, prefix );
			printf("\t\t\t\tconstant real{\"%s depth\"} * %lf * constant vector{\"%s z unit\"}.z } }\n", prefix, zcoord, prefix );

			printf("\tvelocity {\tconstant vector{\"%s velocity\"} + constant vector{\"%s angular velocity\"} x\n", prefix, prefix);
			printf("\t\t\t\t( object{this}.position - constant vector{\"%s pivot\"} ) }\n", prefix);


			printf("\tname\t\t{ \"%s %d_%d\" }\n", prefix, x, z );
			printf("}\n");
			printf("\n");
		}
	}



	for(x = 0; x < stacks; x++)
	{
		for(z = 0; z < slices; z++)
		{
			if(x!=0)
			{
				print_connection( prefix, x, z, x-1, (z+1) % slices);
			}
			print_connection( prefix, x, z, x, (z+1) % slices);
			if(x!=stacks-1)
			{
				print_connection( prefix, x, z, x+1, (z+1) % slices);
				print_connection( prefix, x, z, x+1, z % slices);
			}

			printf("connection\n");
			printf("{\n");
			printf("\ttemplate\t{ \"%s\" }\n", prefix );
			printf(	"\tconnect\t\t{ \"%s %d_%d\", \"%s center\" }\n",
					prefix, x, z, prefix );
			printf(	"\tlength\t\t{ | object{\"%s %d_%d\"}.position - object{\"%s center\"}.position | }\n", prefix, x, z, prefix );
			printf(	"\tname\t\t{ \"%s %d_%d->center\" }\n",
					prefix, x, z );
			printf("}\n");
			printf("\n");
		}
	}

	for(z = 0; z < slices; z++)
	{
		printf("connection\n");
		printf("{\n");
		printf("\ttemplate\t{ \"%s\" }\n", prefix );
		printf(	"\tconnect\t\t{ \"%s %d_%d\", \"%s end1\" }\n", prefix, 0, z, prefix );
		printf(	"\tlength\t\t{ | object{\"%s %d_%d\"}.position - object{\"%s end1\"}.position | }\n",
				prefix, 0, z, prefix );
		printf(	"\tname\t\t{ \"%s %d_%d->end1\" }\n",
				prefix, 0, z );
		printf("}\n");
		printf("\n");

		printf("connection\n");
		printf("{\n");
		printf("\ttemplate\t{ \"%s\" }\n", prefix );
		printf(	"\tconnect\t\t{ \"%s %d_%d\", \"%s end2\" }\n", prefix, stacks-1, z, prefix );
		printf(	"\tlength\t\t{ | object{\"%s %d_%d\"}.position - object{\"%s end2\"}.position | }\n",
				prefix, stacks-1, z, prefix );
		printf(	"\tname\t\t{ \"%s %d_%d->end2\" }\n",
				prefix, stacks-1, z );
		printf("}\n");
		printf("\n");

	}



/* graphics */

	/* variables */

	printf("camera\n");
	printf("{\n");
	printf("\n");

	printf("\ttemplate triangle\n");
	printf("\t{\n");
	printf("\t\tname\t{\"%s triangle\"}\n", prefix);
	printf("\t}\n\n");

	for(x = 0; x < stacks; x++)
	{
		for(z = 0; z < slices; z++)
		{

			printf("\tvariable vector\n");
			printf("\t{\n");
			printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s %d_%d\"}.position - object{\"%s center\"}.position) +\n\t\t\t", prefix, x, z, prefix );
			printf("(template object{\"%s\"}.radius)) + object{\"%s center\"}.position\n\t\t}\n", prefix, prefix );
			printf("\t\tname\t\t{ \"%s %d_%d\" }\n", prefix, x, z );
			printf("\t}\n");
			printf("\n");

			fprintf( vertices, "\tvertex\n" );
			fprintf( vertices, "\t{\n" );
			fprintf( vertices, "\t\tmount\t\t{ variable vector{\"%s %d_%d\"} }\n", prefix, x, z );
			fprintf( vertices, "\t\tname\t\t{ \"%s vx %d_%d\" }\n", prefix, x, z );
			fprintf( vertices, "\t}\n" );
			fprintf( vertices, "\n" );
		}
	}


	printf("\tvariable vector\n");
	printf("\t{\n");
	printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s end1\"}.position - object{\"%s center\"}.position) +\n\t\t\t", prefix, prefix );
	printf("(template object{\"%s\"}.radius)) + object{\"%s center\"}.position\n\t\t}\n", prefix, prefix );
	printf("\t\tname\t\t{ \"%s end1\" }\n", prefix );
	printf("\t}\n");
	printf("\n");

	fprintf( vertices, "\tvertex\n" );
	fprintf( vertices, "\t{\n" );
	fprintf( vertices, "\t\tmount\t\t{ variable vector{\"%s end1\"} }\n", prefix );
	fprintf( vertices, "\t\tname\t\t{ \"%s vx end1\" }\n", prefix );
	fprintf( vertices, "\t}\n" );
	fprintf( vertices, "\n" );

	printf("\tvariable vector\n");
	printf("\t{\n");
	printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s end2\"}.position - object{\"%s center\"}.position) +\n\t\t\t", prefix, prefix );
	printf("(template object{\"%s\"}.radius)) + object{\"%s center\"}.position\n\t\t}\n", prefix, prefix );
	printf("\t\tname\t\t{ \"%s end2\" }\n", prefix );
	printf("\t}\n");
	printf("\n");

	fprintf( vertices, "\tvertex\n" );
	fprintf( vertices, "\t{\n" );
	fprintf( vertices, "\t\tmount\t\t{ variable vector{\"%s end2\"} }\n", prefix );
	fprintf( vertices, "\t\tname\t\t{ \"%s vx end2\" }\n", prefix );
	fprintf( vertices, "\t}\n" );
	fprintf( vertices, "\n" );



	rewind(vertices);
	while( (c=fgetc(vertices)) != EOF )
	{
		fputc(c,stdout);
	}
	if( fclose(vertices) == EOF )
		fprintf( stderr, "error closing tempfile\n" );


	for(x = 0; x < stacks; x++)
	{
		for(z = 0; z < slices; z++)
		{
			if(x!=0)
			{
				if(x%2==z%2)
				{
					print_triangle_face( prefix, x, z, x-1, (z+1) % slices, x-1, z );
					print_triangle_face( prefix, x, z, x, (z+1) % slices, x-1, (z+1) % slices );
				}
				else
				{
					print_triangle_face( prefix, x, z, x, (z+1) % slices, x-1, z );
					print_triangle_face( prefix, x, (z+1) % slices, x-1, (z+1) % slices, x-1, z );
				}
			}
		}
	}

	for(z = 0; z < slices; z++)
	{
		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex\t{\"%s vx end1\"},\n", prefix );
		printf("\t\t\tvertex\t{\"%s vx %d_%d\"},\n", prefix, 0, z);
		printf("\t\t\tvertex\t{\"%s vx %d_%d\"}\n", prefix, 0, (z+1) % slices );
		printf("\t\t}\n");

		printf("\t\tdepend\t{ connection{ object{\"%s end1\"}, object{\"%s %d_%d\"} } }\n", prefix, prefix, 0,z );
		printf("\t\tdepend\t{ connection{ object{\"%s end1\"}, object{\"%s %d_%d\"} } }\n", prefix, prefix, 0,(z+1) % slices );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d\"}, object{\"%s %d_%d\"} } }\n", prefix, 0,z, prefix, 0,(z+1) % slices );

		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex\t{\"%s vx end2\"},\n", prefix );
		printf("\t\t\tvertex\t{\"%s vx %d_%d\"},\n", prefix, stacks-1,(z+1) % slices );
		printf("\t\t\tvertex\t{\"%s vx %d_%d\"}\n", prefix, stacks-1, z );
		printf("\t\t}\n");

		printf("\t\tdepend\t{ connection{ object{\"%s end2\"}, object{\"%s %d_%d\"} } }\n", prefix, prefix, stacks-1,z );
		printf("\t\tdepend\t{ connection{ object{\"%s end2\"}, object{\"%s %d_%d\"} } }\n", prefix, prefix, stacks-1,(z+1) % slices );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d\"}, object{\"%s %d_%d\"} } }\n", prefix, stacks-1,z, prefix, stacks-1,(z+1) % slices );

		printf("\t}\n");
		printf("\n");

	}


/*
	for(x = 0; x < stacks; x++)
	{
		for(z = 0; z < slices; z++)
		{
			printf("\tsphere\n");
			printf("\t{\n");
			printf("\t\tradius\t{ template object{\"%s\"}.radius }\n", prefix );
			printf("\t\tmount\t\t{ \"%s %d_%d\" }\n", prefix, x, z);
			printf("\t}\n");
			printf("\n");
		}
	}

	printf("\tsphere\n");
	printf("\t{\n");
	printf("\t\tradius\t{ template object{\"%s\"}.radius }\n", prefix );
	printf("\t\tmount\t\t{ \"%s end1\" }\n", prefix );
	printf("\t}\n");
	printf("\n");

	printf("\tsphere\n");
	printf("\t{\n");
	printf("\t\tradius\t{ template object{\"%s\"}.radius }\n", prefix );
	printf("\t\tmount\t\t{ \"%s end2\" }\n", prefix );
	printf("\t}\n");
	printf("\n");
*/


	printf("\twindow\t\t{ 300, 300 }\n");
	printf("\tmount\t\t{ vector { 0, 0, 10 } }\n");
	printf("\tlookat\t\t{ vector { 0, 0, 0 } }\n", prefix);
	printf("\tsamplerate\t{ 20 }\n");
	printf("\tname\t\t{ \"Camera 1\" }\n");
	printf("\torbit\t{ true }\n");
	printf("}\n");

	return 0;
}

